/*
 * Copyright © 2019 Benny Bottema (benny@bennybottema.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.bbottema.clusteredobjectpool.util;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

import static java.util.concurrent.Executors.defaultThreadFactory;
import static java.util.concurrent.Executors.newSingleThreadExecutor;

public class CompositeFuturesAsFutureTask extends FutureTask<Void> {

	public static Future<Void> ofFutures(final List<Future<Void>> futures) {
		ExecutorService executorService = newSingleThreadExecutor(defaultThreadFactory());
		Future<Void> future = executorService.submit(new CompositeFuturesAsFutureTask(futures), null);
		executorService.shutdown();
		return future;
	}

	private CompositeFuturesAsFutureTask(final List<Future<Void>> futures) {
		super(new Callable<Void>() {
			@Override
			public Void call() throws ExecutionException, InterruptedException {
				for (Future<Void> future : futures) {
					future.get();
				}
				return null;
			}
		});
	}
}