/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.otp.helpers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;

public class URIHelper {
    public static Map<String, String> queryItems(URI uri) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, String> items = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        for (String pair : pairs = query.split("&")) {
            int index = pair.indexOf("=");
            items.put(URLDecoder.decode(pair.substring(0, index), "UTF-8"), URLDecoder.decode(pair.substring(index + 1), "UTF-8"));
        }
        return items;
    }

    public static URI createURI(String scheme, String host, String path, Map<String, String> query) throws URISyntaxException {
        StringBuilder uriString = new StringBuilder(String.format("%s://%s/%s", scheme, host, path));
        String[] queryKeys = query.keySet().toArray(new String[0]);
        for (int i = 0; i < queryKeys.length; ++i) {
            String sign = i == 0 ? "?" : "&";
            String key = queryKeys[i];
            uriString.append(String.format("%s%s=%s", sign, key, query.get(key)));
        }
        return new URI(uriString.toString());
    }
}

