/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.otp;

import com.bastiaanjansen.otp.HMACAlgorithm;
import com.bastiaanjansen.otp.OneTimePasswordGenerator;
import com.bastiaanjansen.otp.helpers.URIHelper;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TOTPGenerator
extends OneTimePasswordGenerator {
    private final Duration period;
    public static final Duration DEFAULT_PERIOD = Duration.ofSeconds(30L);

    public TOTPGenerator(String secret) {
        this(DEFAULT_PERIOD, secret);
    }

    public TOTPGenerator(int passwordLength, String secret) {
        super(passwordLength, secret);
        this.period = DEFAULT_PERIOD;
    }

    public TOTPGenerator(Duration period, String secret) {
        super(secret);
        this.period = period;
    }

    public TOTPGenerator(Duration period, HMACAlgorithm algorithm, String secret) {
        super(algorithm, secret);
        this.period = period;
    }

    public TOTPGenerator(HMACAlgorithm algorithm, String secret) {
        super(algorithm, secret);
        this.period = DEFAULT_PERIOD;
    }

    public TOTPGenerator(int passwordLength, Duration period, String secret) {
        super(passwordLength, secret);
        this.period = period;
    }

    public TOTPGenerator(int passwordLength, HMACAlgorithm algorithm, String secret) {
        super(passwordLength, algorithm, secret);
        this.period = DEFAULT_PERIOD;
    }

    public TOTPGenerator(int passwordLength, Duration period, HMACAlgorithm algorithm, String secret) {
        super(passwordLength, algorithm, secret);
        this.period = period;
    }

    public TOTPGenerator(URI uri) throws UnsupportedEncodingException {
        super(uri);
        Map<String, String> query = URIHelper.queryItems(uri);
        String period = query.get("period");
        if (period == null) {
            throw new IllegalArgumentException("Period query parameter must be set");
        }
        this.period = Duration.ofSeconds(Integer.parseInt(period));
    }

    public String generate() throws IllegalStateException {
        long counter = this.calculateCounter(this.period);
        return super.generate(BigInteger.valueOf(counter));
    }

    public String generate(Instant instant) throws IllegalStateException {
        return this.generate(instant.toEpochMilli());
    }

    public String generate(Date date) throws IllegalStateException {
        long secondsSince1970 = TimeUnit.MILLISECONDS.toSeconds(date.getTime());
        return this.generate(secondsSince1970);
    }

    public String generate(long secondsPast1970) throws IllegalArgumentException {
        if (!this.validateTime(secondsPast1970)) {
            throw new IllegalArgumentException("Time must be above zero");
        }
        long counter = this.calculateCounter(secondsPast1970, this.period);
        return super.generate(BigInteger.valueOf(counter));
    }

    public boolean verify(String code) {
        long counter = this.calculateCounter(this.period);
        return super.verify(code, counter);
    }

    public boolean verify(String code, int delayWindow) {
        long counter = this.calculateCounter(this.period);
        return super.verify(code, counter, delayWindow);
    }

    public Duration getPeriod() {
        return this.period;
    }

    public URI getURI(String issuer) throws URISyntaxException {
        return this.getURI(issuer, "");
    }

    public URI getURI(String issuer, String account) throws URISyntaxException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("period", String.valueOf(this.period.getSeconds()));
        query.put("digits", String.valueOf(this.passwordLength));
        query.put("algorithm", this.algorithm.name());
        query.put("secret", this.secret);
        String path = account.isEmpty() ? issuer : String.format("%s:%s", issuer, account);
        return this.getURI("totp", path, query);
    }

    private long calculateCounter(Date date, Duration period) {
        return this.calculateCounter(date.getTime(), period);
    }

    private long calculateCounter(long secondsPast1970, Duration period) {
        return TimeUnit.SECONDS.toMillis(secondsPast1970) / TimeUnit.SECONDS.toMillis(period.getSeconds());
    }

    private long calculateCounter(Duration period) {
        return System.currentTimeMillis() / TimeUnit.SECONDS.toMillis(period.getSeconds());
    }

    private boolean validateTime(long time) {
        return time > 0L;
    }
}

