/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.otp;

import com.bastiaanjansen.otp.HMACAlgorithm;
import com.bastiaanjansen.otp.helpers.URIHelper;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base32;

public class OneTimePasswordGenerator {
    protected final int passwordLength;
    protected final HMACAlgorithm algorithm;
    protected final String secret;
    public static final int DEFAULT_PASSWORD_LENGTH = 6;
    public static final HMACAlgorithm DEFAULT_HMAC_ALGORITHM = HMACAlgorithm.SHA1;

    protected OneTimePasswordGenerator(String secret) {
        this(6, DEFAULT_HMAC_ALGORITHM, secret);
    }

    protected OneTimePasswordGenerator(int passwordLength, String secret) {
        this(passwordLength, DEFAULT_HMAC_ALGORITHM, secret);
    }

    protected OneTimePasswordGenerator(HMACAlgorithm algorithm, String secret) {
        this(6, algorithm, secret);
    }

    protected OneTimePasswordGenerator(URI uri) throws UnsupportedEncodingException {
        Map<String, String> query = URIHelper.queryItems(uri);
        String secret = query.get("secret");
        String passwordLength = query.get("digits");
        String algorithm = query.get("algorithm");
        HMACAlgorithm HMACAlgorithm2 = null;
        if (algorithm != null) {
            switch (algorithm) {
                case "SHA1": {
                    HMACAlgorithm2 = HMACAlgorithm.SHA1;
                    break;
                }
                case "SHA256": {
                    HMACAlgorithm2 = HMACAlgorithm.SHA256;
                    break;
                }
                case "SHA512": {
                    HMACAlgorithm2 = HMACAlgorithm.SHA512;
                    break;
                }
                default: {
                    HMACAlgorithm2 = null;
                }
            }
        }
        if (secret == null) {
            throw new IllegalArgumentException("Secret query parameter must be set");
        }
        this.passwordLength = passwordLength == null ? 6 : Integer.parseInt(passwordLength);
        this.algorithm = algorithm == null ? DEFAULT_HMAC_ALGORITHM : HMACAlgorithm2;
        this.secret = secret;
    }

    protected OneTimePasswordGenerator(int passwordLength, HMACAlgorithm algorithm, String secret) {
        if (!this.validatePasswordLength(passwordLength)) {
            throw new IllegalArgumentException("Password length must be between 6 and 8 digits");
        }
        this.passwordLength = passwordLength;
        this.algorithm = algorithm;
        this.secret = secret.toUpperCase();
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public HMACAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean verify(String code, long counter) {
        return this.verify(code, counter, 0);
    }

    public boolean verify(String code, long counter, int delayWindow) {
        if (code.length() != this.passwordLength) {
            return false;
        }
        for (int i = -delayWindow; i <= delayWindow; ++i) {
            String currentCode = this.generate(BigInteger.valueOf(counter + (long)i));
            if (!code.equals(currentCode)) continue;
            return true;
        }
        return false;
    }

    protected String generate(BigInteger counter) throws IllegalStateException {
        byte[] hash = this.generateHash(this.secret, counter.longValue());
        return this.getCodeFromHash(hash);
    }

    protected URI getURI(String type, String path, Map<String, String> query) throws URISyntaxException {
        return URIHelper.createURI("otpauth", type, path, query);
    }

    private byte[] generateHash(String secret, long counter) {
        byte[] counterBytes = ByteBuffer.allocate(8).putLong(counter).array();
        Base32 codec = new Base32();
        byte[] decodedSecret = codec.decode(secret);
        try {
            return this.generateHash(decodedSecret, counterBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException();
        }
    }

    private byte[] generateHash(byte[] secret, byte[] data) throws InvalidKeyException, NoSuchAlgorithmException {
        SecretKeySpec signKey = new SecretKeySpec(secret, "RAW");
        Mac mac = Mac.getInstance(this.algorithm.getHMACName());
        mac.init(signKey);
        return mac.doFinal(data);
    }

    private String getCodeFromHash(byte[] hash) {
        int mask = 15;
        byte lastByte = hash[hash.length - 1];
        int offset = lastByte & mask;
        byte[] truncatedHashInBytes = new byte[]{hash[offset], hash[offset + 1], hash[offset + 2], hash[offset + 3]};
        ByteBuffer byteBuffer = ByteBuffer.wrap(truncatedHashInBytes);
        long truncatedHash = byteBuffer.getInt();
        truncatedHash &= Integer.MAX_VALUE;
        truncatedHash = (long)((double)truncatedHash % Math.pow(10.0, this.passwordLength));
        return String.format("%0" + this.passwordLength + "d", truncatedHash);
    }

    private boolean validatePasswordLength(int passwordLength) {
        return passwordLength >= 6 && passwordLength <= 8;
    }
}

