/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.otp;

import com.bastiaanjansen.otp.HMACAlgorithm;
import com.bastiaanjansen.otp.OneTimePasswordGenerator;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;

public class HOTPGenerator
extends OneTimePasswordGenerator {
    public HOTPGenerator(String secret) {
        super(HMACAlgorithm.SHA1, secret);
    }

    public HOTPGenerator(int passwordLength, String secret) {
        super(passwordLength, HMACAlgorithm.SHA1, secret);
    }

    public HOTPGenerator(URI uri) throws UnsupportedEncodingException {
        super(uri);
    }

    public String generate(long counter) throws IllegalArgumentException {
        return super.generate(BigInteger.valueOf(counter));
    }

    public URI getURI(int counter, String issuer) throws URISyntaxException {
        return this.getURI(counter, issuer, "");
    }

    public URI getURI(int counter, String issuer, String account) throws URISyntaxException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("counter", String.valueOf(counter));
        query.put("digits", String.valueOf(this.passwordLength));
        query.put("algorithm", this.algorithm.name());
        query.put("secret", this.secret);
        String path = account.isEmpty() ? issuer : String.format("%s:%s", issuer, account);
        return this.getURI("hotp", path, query);
    }
}

