/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.graphics.RectF;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.util.Constants;
import com.github.barteksc.pdfviewer.util.MathUtils;
import com.github.barteksc.pdfviewer.util.Util;
import com.shockwave.pdfium.util.SizeF;

class PagesLoader {
    private PDFView pdfView;
    private int cacheOrder;
    private float xOffset;
    private float yOffset;
    private float pageRelativePartWidth;
    private float pageRelativePartHeight;
    private float partRenderWidth;
    private float partRenderHeight;
    private final RectF thumbnailRect = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
    private final int preloadOffset;
    private final Holder firstHolder = new Holder();
    private final Holder lastHolder = new Holder();
    private final GridSize firstGrid = new GridSize();
    private final GridSize lastGrid = new GridSize();
    private final GridSize middleGrid = new GridSize();

    PagesLoader(PDFView pdfView) {
        this.pdfView = pdfView;
        this.preloadOffset = Util.getDP(pdfView.getContext(), Constants.PRELOAD_OFFSET);
    }

    private void getPageColsRows(GridSize grid, int pageIndex) {
        SizeF size = this.pdfView.pdfFile.getPageSize(pageIndex);
        float ratioX = 1.0f / size.getWidth();
        float ratioY = 1.0f / size.getHeight();
        float partHeight = Constants.PART_SIZE * ratioY / this.pdfView.getZoom();
        float partWidth = Constants.PART_SIZE * ratioX / this.pdfView.getZoom();
        grid.rows = MathUtils.ceil(1.0f / partHeight);
        grid.cols = MathUtils.ceil(1.0f / partWidth);
    }

    private Holder getPageAndCoordsByOffset(Holder holder, GridSize grid, float localXOffset, float localYOffset, boolean endOffset) {
        float col;
        float row;
        float fixedXOffset = -MathUtils.max(localXOffset, 0.0f);
        float fixedYOffset = -MathUtils.max(localYOffset, 0.0f);
        float offset = this.pdfView.isSwipeVertical() ? fixedYOffset : fixedXOffset;
        holder.page = this.pdfView.pdfFile.getPageAtOffset(offset, this.pdfView.getZoom());
        this.getPageColsRows(grid, holder.page);
        SizeF scaledPageSize = this.pdfView.pdfFile.getScaledPageSize(holder.page, this.pdfView.getZoom());
        float rowHeight = scaledPageSize.getHeight() / (float)grid.rows;
        float colWidth = scaledPageSize.getWidth() / (float)grid.cols;
        float secondaryOffset = this.pdfView.pdfFile.getSecondaryPageOffset(holder.page, this.pdfView.getZoom());
        if (this.pdfView.isSwipeVertical()) {
            row = Math.abs(fixedYOffset - this.pdfView.pdfFile.getPageOffset(holder.page, this.pdfView.getZoom())) / rowHeight;
            col = MathUtils.min(fixedXOffset - secondaryOffset, 0.0f) / colWidth;
        } else {
            col = Math.abs(fixedXOffset - this.pdfView.pdfFile.getPageOffset(holder.page, this.pdfView.getZoom())) / colWidth;
            row = MathUtils.min(fixedYOffset - secondaryOffset, 0.0f) / rowHeight;
        }
        if (endOffset) {
            holder.row = MathUtils.ceil(row);
            holder.col = MathUtils.ceil(col);
        } else {
            holder.row = MathUtils.floor(row);
            holder.col = MathUtils.floor(col);
        }
        return holder;
    }

    private void calculatePartSize(GridSize grid) {
        this.pageRelativePartWidth = 1.0f / (float)grid.cols;
        this.pageRelativePartHeight = 1.0f / (float)grid.rows;
        this.partRenderWidth = Constants.PART_SIZE / this.pageRelativePartWidth;
        this.partRenderHeight = Constants.PART_SIZE / this.pageRelativePartHeight;
    }

    private void loadVisible() {
        int parts = 0;
        float scaledPreloadOffset = (float)this.preloadOffset * this.pdfView.getZoom();
        float firstXOffset = -this.xOffset + scaledPreloadOffset;
        float lastXOffset = -this.xOffset - (float)this.pdfView.getWidth() - scaledPreloadOffset;
        float firstYOffset = -this.yOffset + scaledPreloadOffset;
        float lastYOffset = -this.yOffset - (float)this.pdfView.getHeight() - scaledPreloadOffset;
        this.getPageAndCoordsByOffset(this.firstHolder, this.firstGrid, firstXOffset, firstYOffset, false);
        this.getPageAndCoordsByOffset(this.lastHolder, this.lastGrid, lastXOffset, lastYOffset, true);
        for (int i = this.firstHolder.page; i <= this.lastHolder.page; ++i) {
            this.loadThumbnail(i);
        }
        int pagesCount = this.lastHolder.page - this.firstHolder.page + 1;
        for (int page = this.firstHolder.page; page <= this.lastHolder.page && parts < Constants.Cache.CACHE_SIZE; ++page) {
            if (page == this.firstHolder.page && pagesCount > 1) {
                parts += this.loadPageEnd(this.firstHolder, this.firstGrid, Constants.Cache.CACHE_SIZE - parts);
                continue;
            }
            if (page == this.lastHolder.page && pagesCount > 1) {
                parts += this.loadPageStart(this.lastHolder, this.lastGrid, Constants.Cache.CACHE_SIZE - parts);
                continue;
            }
            if (pagesCount == 1) {
                parts += this.loadPageCenter(this.firstHolder, this.lastHolder, this.firstGrid, Constants.Cache.CACHE_SIZE - parts);
                continue;
            }
            this.getPageColsRows(this.middleGrid, page);
            parts += this.loadWholePage(page, this.middleGrid, Constants.Cache.CACHE_SIZE - parts);
        }
    }

    private int loadWholePage(int page, GridSize grid, int nbOfPartsLoadable) {
        this.calculatePartSize(grid);
        return this.loadPage(page, 0, grid.rows - 1, 0, grid.cols - 1, nbOfPartsLoadable);
    }

    private int loadPageCenter(Holder firstHolder, Holder lastHolder, GridSize grid, int nbOfPartsLoadable) {
        this.calculatePartSize(grid);
        return this.loadPage(firstHolder.page, firstHolder.row, lastHolder.row, firstHolder.col, lastHolder.col, nbOfPartsLoadable);
    }

    private int loadPageEnd(Holder holder, GridSize grid, int nbOfPartsLoadable) {
        this.calculatePartSize(grid);
        if (this.pdfView.isSwipeVertical()) {
            int firstRow = holder.row;
            return this.loadPage(holder.page, firstRow, grid.rows - 1, 0, grid.cols - 1, nbOfPartsLoadable);
        }
        int firstCol = holder.col;
        return this.loadPage(holder.page, 0, grid.rows - 1, firstCol, grid.cols - 1, nbOfPartsLoadable);
    }

    private int loadPageStart(Holder holder, GridSize grid, int nbOfPartsLoadable) {
        this.calculatePartSize(grid);
        if (this.pdfView.isSwipeVertical()) {
            int lastRow = holder.row;
            return this.loadPage(holder.page, 0, lastRow, 0, grid.cols - 1, nbOfPartsLoadable);
        }
        int lastCol = holder.col;
        return this.loadPage(holder.page, 0, grid.rows - 1, 0, lastCol, nbOfPartsLoadable);
    }

    private int loadPage(int page, int firstRow, int lastRow, int firstCol, int lastCol, int nbOfPartsLoadable) {
        int loaded = 0;
        for (int row = firstRow; row <= lastRow; ++row) {
            for (int col = firstCol; col <= lastCol; ++col) {
                if (this.loadCell(page, row, col, this.pageRelativePartWidth, this.pageRelativePartHeight)) {
                    ++loaded;
                }
                if (loaded < nbOfPartsLoadable) continue;
                return loaded;
            }
        }
        return loaded;
    }

    private boolean loadCell(int page, int row, int col, float pageRelativePartWidth, float pageRelativePartHeight) {
        float relX = pageRelativePartWidth * (float)col;
        float relY = pageRelativePartHeight * (float)row;
        float relWidth = pageRelativePartWidth;
        float relHeight = pageRelativePartHeight;
        float renderWidth = this.partRenderWidth;
        float renderHeight = this.partRenderHeight;
        if (relX + relWidth > 1.0f) {
            relWidth = 1.0f - relX;
        }
        if (relY + relHeight > 1.0f) {
            relHeight = 1.0f - relY;
        }
        renderWidth *= relWidth;
        renderHeight *= relHeight;
        RectF pageRelativeBounds = new RectF(relX, relY, relX + relWidth, relY + relHeight);
        if (renderWidth > 0.0f && renderHeight > 0.0f) {
            if (!this.pdfView.cacheManager.upPartIfContained(page, pageRelativeBounds, this.cacheOrder)) {
                this.pdfView.renderingHandler.addRenderingTask(page, renderWidth, renderHeight, pageRelativeBounds, false, this.cacheOrder, this.pdfView.isBestQuality(), this.pdfView.isAnnotationRendering());
            }
            ++this.cacheOrder;
            return true;
        }
        return false;
    }

    private void loadThumbnail(int page) {
        SizeF pageSize = this.pdfView.pdfFile.getPageSize(page);
        float thumbnailWidth = pageSize.getWidth() * Constants.THUMBNAIL_RATIO;
        float thumbnailHeight = pageSize.getHeight() * Constants.THUMBNAIL_RATIO;
        if (!this.pdfView.cacheManager.containsThumbnail(page, this.thumbnailRect)) {
            this.pdfView.renderingHandler.addRenderingTask(page, thumbnailWidth, thumbnailHeight, this.thumbnailRect, true, 0, this.pdfView.isBestQuality(), this.pdfView.isAnnotationRendering());
        }
    }

    void loadPages() {
        this.cacheOrder = 1;
        this.xOffset = -MathUtils.max(this.pdfView.getCurrentXOffset(), 0.0f);
        this.yOffset = -MathUtils.max(this.pdfView.getCurrentYOffset(), 0.0f);
        this.loadVisible();
    }

    private class GridSize {
        int rows;
        int cols;

        private GridSize() {
        }
    }

    private class Holder {
        int page;
        int row;
        int col;

        private Holder() {
        }
    }
}

