/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.os.AsyncTask;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.PdfFile;
import com.github.barteksc.pdfviewer.source.DocumentSource;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import com.shockwave.pdfium.util.Size;

class DecodingAsyncTask
extends AsyncTask<Void, Void, Throwable> {
    private boolean cancelled;
    private PDFView pdfView;
    private PdfiumCore pdfiumCore;
    private String password;
    private DocumentSource docSource;
    private int[] userPages;
    private PdfFile pdfFile;

    DecodingAsyncTask(DocumentSource docSource, String password, int[] userPages, PDFView pdfView, PdfiumCore pdfiumCore) {
        this.docSource = docSource;
        this.userPages = userPages;
        this.cancelled = false;
        this.pdfView = pdfView;
        this.password = password;
        this.pdfiumCore = pdfiumCore;
    }

    protected Throwable doInBackground(Void ... params) {
        try {
            PdfDocument pdfDocument = this.docSource.createDocument(this.pdfView.getContext(), this.pdfiumCore, this.password);
            this.pdfFile = new PdfFile(this.pdfiumCore, pdfDocument, this.pdfView.getPageFitPolicy(), this.getViewSize(), this.userPages, this.pdfView.isSwipeVertical(), this.pdfView.getSpacingPx());
            return null;
        }
        catch (Throwable t) {
            return t;
        }
    }

    private Size getViewSize() {
        return new Size(this.pdfView.getWidth(), this.pdfView.getHeight());
    }

    protected void onPostExecute(Throwable t) {
        if (t != null) {
            this.pdfView.loadError(t);
            return;
        }
        if (!this.cancelled) {
            this.pdfView.loadComplete(this.pdfFile);
        }
    }

    protected void onCancelled() {
        this.cancelled = true;
    }
}

