/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.github.barteksc.pdfviewer.AnimationManager;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.scroll.ScrollHandle;
import com.github.barteksc.pdfviewer.util.Constants;

class DragPinchManager
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ScaleGestureDetector.OnScaleGestureListener,
View.OnTouchListener {
    private PDFView pdfView;
    private AnimationManager animationManager;
    private GestureDetector gestureDetector;
    private ScaleGestureDetector scaleGestureDetector;
    private boolean isSwipeEnabled;
    private boolean swipeVertical;
    private boolean scrolling = false;
    private boolean scaling = false;

    public DragPinchManager(PDFView pdfView, AnimationManager animationManager) {
        this.pdfView = pdfView;
        this.animationManager = animationManager;
        this.isSwipeEnabled = false;
        this.swipeVertical = pdfView.isSwipeVertical();
        this.gestureDetector = new GestureDetector(pdfView.getContext(), (GestureDetector.OnGestureListener)this);
        this.scaleGestureDetector = new ScaleGestureDetector(pdfView.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this);
        pdfView.setOnTouchListener(this);
    }

    public void enableDoubletap(boolean enableDoubletap) {
        if (enableDoubletap) {
            this.gestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this);
        } else {
            this.gestureDetector.setOnDoubleTapListener(null);
        }
    }

    public boolean isZooming() {
        return this.pdfView.isZooming();
    }

    private boolean isPageChange(float distance) {
        return Math.abs(distance) > Math.abs(this.pdfView.toCurrentScale(this.swipeVertical ? this.pdfView.getOptimalPageHeight() : this.pdfView.getOptimalPageWidth()) / 2.0f);
    }

    public void setSwipeEnabled(boolean isSwipeEnabled) {
        this.isSwipeEnabled = isSwipeEnabled;
    }

    public void setSwipeVertical(boolean swipeVertical) {
        this.swipeVertical = swipeVertical;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        ScrollHandle ps = this.pdfView.getScrollHandle();
        if (ps != null && !this.pdfView.documentFitsView()) {
            if (!ps.shown()) {
                ps.show();
            } else {
                ps.hide();
            }
        }
        this.pdfView.performClick();
        return true;
    }

    public boolean onDoubleTap(MotionEvent e) {
        if (this.pdfView.getZoom() < this.pdfView.getMidZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMidZoom());
        } else if (this.pdfView.getZoom() < this.pdfView.getMaxZoom()) {
            this.pdfView.zoomWithAnimation(e.getX(), e.getY(), this.pdfView.getMaxZoom());
        } else {
            this.pdfView.resetZoomWithAnimation();
        }
        return true;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        return false;
    }

    public boolean onDown(MotionEvent e) {
        this.animationManager.stopFling();
        return true;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.scrolling = true;
        if (this.isZooming() || this.isSwipeEnabled) {
            this.pdfView.moveRelativeTo(-distanceX, -distanceY);
        }
        if (!this.scaling || this.pdfView.doRenderDuringScale()) {
            this.pdfView.loadPageByOffset();
        }
        return true;
    }

    public void onScrollEnd(MotionEvent event) {
        this.pdfView.loadPages();
        this.hideHandle();
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        int xOffset = (int)this.pdfView.getCurrentXOffset();
        int yOffset = (int)this.pdfView.getCurrentYOffset();
        this.animationManager.startFlingAnimation(xOffset, yOffset, (int)velocityX, (int)velocityY, xOffset * (this.swipeVertical ? 2 : this.pdfView.getPageCount()), 0, yOffset * (this.swipeVertical ? this.pdfView.getPageCount() : 2), 0);
        return true;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float dr = detector.getScaleFactor();
        float wantedZoom = this.pdfView.getZoom() * dr;
        if (wantedZoom < Constants.Pinch.MINIMUM_ZOOM) {
            dr = Constants.Pinch.MINIMUM_ZOOM / this.pdfView.getZoom();
        } else if (wantedZoom > Constants.Pinch.MAXIMUM_ZOOM) {
            dr = Constants.Pinch.MAXIMUM_ZOOM / this.pdfView.getZoom();
        }
        this.pdfView.zoomCenteredRelativeTo(dr, new PointF(detector.getFocusX(), detector.getFocusY()));
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.scaling = true;
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        this.pdfView.loadPages();
        this.hideHandle();
        this.scaling = false;
    }

    public boolean onTouch(View v, MotionEvent event) {
        boolean retVal = this.scaleGestureDetector.onTouchEvent(event);
        boolean bl = retVal = this.gestureDetector.onTouchEvent(event) || retVal;
        if (event.getAction() == 1 && this.scrolling) {
            this.scrolling = false;
            this.onScrollEnd(event);
        }
        return retVal;
    }

    private void hideHandle() {
        if (this.pdfView.getScrollHandle() != null && this.pdfView.getScrollHandle().shown()) {
            this.pdfView.getScrollHandle().hideDelayed();
        }
    }
}

