/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer.util;

import android.graphics.PointF;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;

public class DragPinchListener
implements View.OnTouchListener {
    private static final long MAX_CLICK_TIME = 500L;
    private static final float MAX_CLICK_DISTANCE = 5.0f;
    private static final float MAX_DOUBLE_CLICK_TIME = 280.0f;
    private static final int POINTER1 = 0;
    private static final int POINTER2 = 1;
    private final Handler handlerClick = new Handler();
    private View mView;
    private final Runnable runnableClick = new Runnable(){

        @Override
        public void run() {
            DragPinchListener.this.mView.performClick();
        }
    };
    private State state = State.NONE;
    private float dragLastX;
    private float dragLastY;
    private float pointer2LastX;
    private float pointer2LastY;
    private float zoomLastDistance;
    private OnDragListener onDragListener;
    private OnPinchListener onPinchListener;
    private OnDoubleTapListener onDoubleTapListener;
    private float lastDownX;
    private float lastDownY;
    private long lastClickTime;

    public boolean onTouch(View v, MotionEvent event) {
        this.mView = v;
        block0 : switch (event.getAction()) {
            case 0: {
                this.startDrag(event);
                this.state = State.DRAG;
                this.lastDownX = event.getX();
                this.lastDownY = event.getY();
                break;
            }
            case 261: {
                this.startDrag(event);
                this.startZoom(event);
                this.state = State.ZOOM;
                break;
            }
            case 262: {
                this.state = State.DRAG;
                break;
            }
            case 1: {
                this.state = State.NONE;
                this.endDrag();
                if (!this.isClick(event, this.lastDownX, this.lastDownY, event.getX(), event.getY())) break;
                long time = System.currentTimeMillis();
                this.handlerClick.removeCallbacks(this.runnableClick);
                if (this.onDoubleTapListener != null) {
                    if ((float)(time - this.lastClickTime) < 280.0f) {
                        this.onDoubleTapListener.onDoubleTap(event.getX(), event.getY());
                        this.lastClickTime = 0L;
                        break;
                    }
                    this.lastClickTime = System.currentTimeMillis();
                    this.handlerClick.postDelayed(this.runnableClick, 500L);
                    break;
                }
                this.handlerClick.postDelayed(this.runnableClick, 0L);
                break;
            }
            case 6: {
                this.dragLastX = this.pointer2LastX;
                this.dragLastY = this.pointer2LastY;
                this.state = State.DRAG;
                break;
            }
            case 5: {
                this.pointer2LastX = event.getX(0);
                this.pointer2LastY = event.getY(0);
                this.startDrag(event);
                this.startZoom(event);
                this.state = State.ZOOM;
                break;
            }
            case 2: {
                switch (this.state) {
                    case ZOOM: {
                        this.pointer2LastX = event.getX(1);
                        this.pointer2LastY = event.getY(1);
                        this.zoom(event);
                    }
                    case DRAG: {
                        this.drag(event);
                        break block0;
                    }
                }
            }
        }
        return true;
    }

    private void endDrag() {
        this.onDragListener.endDrag(this.dragLastX, this.dragLastY);
    }

    private void startZoom(MotionEvent event) {
        this.zoomLastDistance = this.distance(event);
    }

    private void zoom(MotionEvent event) {
        float zoomCurrentDistance = this.distance(event);
        if (this.onPinchListener != null) {
            this.onPinchListener.onPinch(zoomCurrentDistance / this.zoomLastDistance, new PointF(event.getX(0), event.getY(0)));
        }
        this.zoomLastDistance = zoomCurrentDistance;
    }

    private void startDrag(MotionEvent event) {
        this.dragLastX = event.getX(0);
        this.dragLastY = event.getY(0);
        this.onDragListener.startDrag(this.dragLastX, this.dragLastY);
    }

    private void drag(MotionEvent event) {
        float dragCurrentX = event.getX(0);
        float dragCurrentY = event.getY(0);
        if (this.onDragListener != null) {
            this.onDragListener.onDrag(dragCurrentX - this.dragLastX, dragCurrentY - this.dragLastY);
        }
        this.dragLastX = dragCurrentX;
        this.dragLastY = dragCurrentY;
    }

    private float distance(MotionEvent event) {
        if (event.getPointerCount() < 2) {
            return 0.0f;
        }
        return PointF.length((float)(event.getX(0) - event.getX(1)), (float)(event.getY(0) - event.getY(1)));
    }

    private boolean isClick(MotionEvent upEvent, float xDown, float yDown, float xUp, float yUp) {
        if (upEvent == null) {
            return false;
        }
        long time = upEvent.getEventTime() - upEvent.getDownTime();
        float distance = PointF.length((float)(xDown - xUp), (float)(yDown - yUp));
        return time < 500L && distance < 5.0f;
    }

    public void setOnDragListener(OnDragListener onDragListener) {
        this.onDragListener = onDragListener;
    }

    public void setOnPinchListener(OnPinchListener onPinchListener) {
        this.onPinchListener = onPinchListener;
    }

    public void setOnDoubleTapListener(OnDoubleTapListener onDoubleTapListener) {
        this.onDoubleTapListener = onDoubleTapListener;
    }

    static enum State {
        NONE,
        ZOOM,
        DRAG;

    }

    public static interface OnDoubleTapListener {
        public void onDoubleTap(float var1, float var2);
    }

    public static interface OnPinchListener {
        public void onPinch(float var1, PointF var2);
    }

    public static interface OnDragListener {
        public void onDrag(float var1, float var2);

        public void startDrag(float var1, float var2);

        public void endDrag(float var1, float var2);
    }
}

