/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.view.animation.DecelerateInterpolator;
import com.github.barteksc.pdfviewer.PDFView;

class AnimationManager {
    private PDFView pdfView;
    private ValueAnimator animation;

    public AnimationManager(PDFView pdfView) {
        this.pdfView = pdfView;
    }

    public void startXAnimation(float xFrom, float xTo) {
        if (this.animation != null) {
            this.animation.cancel();
        }
        this.animation = ValueAnimator.ofFloat((float[])new float[]{xFrom, xTo});
        this.animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new XAnimation());
        this.animation.setDuration(400L);
        this.animation.start();
    }

    public void startYAnimation(float yFrom, float yTo) {
        if (this.animation != null) {
            this.animation.cancel();
        }
        this.animation = ValueAnimator.ofFloat((float[])new float[]{yFrom, yTo});
        this.animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.animation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new YAnimation());
        this.animation.setDuration(400L);
        this.animation.start();
    }

    public void startZoomAnimation(float zoomFrom, float zoomTo) {
        if (this.animation != null) {
            this.animation.cancel();
        }
        this.animation = ValueAnimator.ofFloat((float[])new float[]{zoomFrom, zoomTo});
        this.animation.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        ZoomAnimation zoomAnim = new ZoomAnimation();
        this.animation.addUpdateListener((ValueAnimator.AnimatorUpdateListener)zoomAnim);
        this.animation.addListener((Animator.AnimatorListener)zoomAnim);
        this.animation.setDuration(400L);
        this.animation.start();
    }

    public void stopAll() {
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
        }
    }

    class ZoomAnimation
    implements ValueAnimator.AnimatorUpdateListener,
    Animator.AnimatorListener {
        ZoomAnimation() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float zoom = ((Float)animation.getAnimatedValue()).floatValue();
            AnimationManager.this.pdfView.zoomCenteredTo(zoom, new PointF((float)(AnimationManager.this.pdfView.getWidth() / 2), (float)(AnimationManager.this.pdfView.getHeight() / 2)));
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            AnimationManager.this.pdfView.loadPages();
        }

        public void onAnimationRepeat(Animator animation) {
        }

        public void onAnimationStart(Animator animation) {
        }
    }

    class YAnimation
    implements ValueAnimator.AnimatorUpdateListener {
        YAnimation() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float offset = ((Float)animation.getAnimatedValue()).floatValue();
            AnimationManager.this.pdfView.moveTo(AnimationManager.this.pdfView.getCurrentXOffset(), offset);
        }
    }

    class XAnimation
    implements ValueAnimator.AnimatorUpdateListener {
        XAnimation() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float offset = ((Float)animation.getAnimatedValue()).floatValue();
            AnimationManager.this.pdfView.moveTo(offset, AnimationManager.this.pdfView.getCurrentYOffset());
        }
    }
}

