/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.model.PagePart;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import java.util.HashSet;
import java.util.Set;

class RenderingHandler
extends Handler {
    static final int MSG_RENDER_TASK = 1;
    private PdfiumCore pdfiumCore;
    private PdfDocument pdfDocument;
    private PDFView pdfView;
    private RectF renderBounds = new RectF();
    private Rect roundedRenderBounds = new Rect();
    private Matrix renderMatrix = new Matrix();
    private final Set<Integer> openedPages = new HashSet<Integer>();

    RenderingHandler(Looper looper, PDFView pdfView, PdfiumCore pdfiumCore, PdfDocument pdfDocument) {
        super(looper);
        this.pdfView = pdfView;
        this.pdfiumCore = pdfiumCore;
        this.pdfDocument = pdfDocument;
    }

    void addRenderingTask(int userPage, int page, float width, float height, RectF bounds, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering) {
        RenderingTask task = new RenderingTask(width, height, bounds, userPage, page, thumbnail, cacheOrder, bestQuality, annotationRendering);
        Message msg = this.obtainMessage(1, task);
        this.sendMessage(msg);
    }

    public void handleMessage(Message message) {
        RenderingTask task = (RenderingTask)message.obj;
        final PagePart part = this.proceed(task);
        if (part != null) {
            this.pdfView.post(new Runnable(){

                @Override
                public void run() {
                    RenderingHandler.this.pdfView.onBitmapRendered(part);
                }
            });
        }
    }

    private PagePart proceed(RenderingTask renderingTask) {
        if (!this.openedPages.contains(renderingTask.page)) {
            this.openedPages.add(renderingTask.page);
            this.pdfiumCore.openPage(this.pdfDocument, renderingTask.page);
        }
        int w = Math.round(renderingTask.width);
        int h = Math.round(renderingTask.height);
        Bitmap render = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.calculateBounds(w, h, renderingTask.bounds);
        this.pdfiumCore.renderPageBitmap(this.pdfDocument, render, renderingTask.page, this.roundedRenderBounds.left, this.roundedRenderBounds.top, this.roundedRenderBounds.width(), this.roundedRenderBounds.height(), renderingTask.annotationRendering);
        if (!renderingTask.bestQuality) {
            Bitmap cpy = render.copy(Bitmap.Config.RGB_565, false);
            render.recycle();
            render = cpy;
        }
        return new PagePart(renderingTask.userPage, renderingTask.page, render, renderingTask.width, renderingTask.height, renderingTask.bounds, renderingTask.thumbnail, renderingTask.cacheOrder);
    }

    private void calculateBounds(int width, int height, RectF pageSliceBounds) {
        this.renderMatrix.reset();
        this.renderMatrix.postTranslate(-pageSliceBounds.left * (float)width, -pageSliceBounds.top * (float)height);
        this.renderMatrix.postScale(1.0f / pageSliceBounds.width(), 1.0f / pageSliceBounds.height());
        this.renderBounds.set(0.0f, 0.0f, (float)width, (float)height);
        this.renderMatrix.mapRect(this.renderBounds);
        this.renderBounds.round(this.roundedRenderBounds);
    }

    private class RenderingTask {
        float width;
        float height;
        RectF bounds;
        int page;
        int userPage;
        boolean thumbnail;
        int cacheOrder;
        boolean bestQuality;
        boolean annotationRendering;

        RenderingTask(float width, float height, RectF bounds, int userPage, int page, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering) {
            this.page = page;
            this.width = width;
            this.height = height;
            this.bounds = bounds;
            this.userPage = userPage;
            this.thumbnail = thumbnail;
            this.cacheOrder = cacheOrder;
            this.bestQuality = bestQuality;
            this.annotationRendering = annotationRendering;
        }
    }
}

