/*
 * Decompiled with CFR 0.152.
 */
package net.badata.protobuf.converter.writer;

import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import net.badata.protobuf.converter.exception.WriteException;
import net.badata.protobuf.converter.resolver.FieldResolver;
import net.badata.protobuf.converter.type.TypeConverter;
import net.badata.protobuf.converter.utils.FieldUtils;
import net.badata.protobuf.converter.utils.Primitives;
import net.badata.protobuf.converter.writer.AbstractWriter;

public class ProtobufWriter
extends AbstractWriter {
    private final Class<? extends Message.Builder> destinationClass;

    public ProtobufWriter(Message.Builder destination) {
        super(destination);
        this.destinationClass = destination.getClass();
    }

    @Override
    protected void write(Object destination, FieldResolver fieldResolver, Object value) throws WriteException {
        if (value != null) {
            TypeConverter<?, ?> typeConverter = fieldResolver.getTypeConverter();
            this.writeValue(destination, fieldResolver, typeConverter.toProtobufValue(value));
        }
    }

    private void writeValue(Object destination, FieldResolver fieldResolver, Object value) throws WriteException {
        for (Class<?> valueClass = this.extractValueClass(value); valueClass != null; valueClass = valueClass.getSuperclass()) {
            String setterName = FieldUtils.createProtobufSetterName(fieldResolver);
            try {
                this.destinationClass.getMethod(setterName, valueClass).invoke(destination, value);
                break;
            }
            catch (IllegalAccessException e) {
                throw new WriteException(String.format("Access denied. '%s.%s(%s)'", this.destinationClass.getName(), setterName, valueClass));
            }
            catch (InvocationTargetException e) {
                throw new WriteException(String.format("Can't set field value through '%s.%s(%s)'", this.destinationClass.getName(), setterName, valueClass));
            }
            catch (NoSuchMethodException e) {
                if (valueClass.getSuperclass() != null) {
                    continue;
                }
                throw new WriteException(String.format("Setter not found: '%s.%s(%s)'", this.destinationClass.getName(), setterName, valueClass));
            }
        }
    }

    private Class<?> extractValueClass(Object value) {
        Class<?> valueClass = value.getClass();
        if (Primitives.isWrapperType(valueClass)) {
            return Primitives.unwrap(valueClass);
        }
        if (Collection.class.isAssignableFrom(valueClass)) {
            return Iterable.class;
        }
        return valueClass;
    }
}

