/*
 * Decompiled with CFR 0.152.
 */
package net.badata.protobuf.converter.utils;

import com.google.protobuf.Message;
import net.badata.protobuf.converter.annotation.ProtoClass;
import net.badata.protobuf.converter.annotation.ProtoClasses;
import net.badata.protobuf.converter.annotation.ProtoField;
import net.badata.protobuf.converter.exception.MappingException;
import net.badata.protobuf.converter.exception.WriteException;
import net.badata.protobuf.converter.inspection.DefaultValue;
import net.badata.protobuf.converter.inspection.NullValueInspector;
import net.badata.protobuf.converter.mapping.Mapper;
import net.badata.protobuf.converter.resolver.FieldResolverFactory;
import net.badata.protobuf.converter.type.TypeConverter;

public class AnnotationUtils {
    public static ProtoClass findProtoClass(Class<?> domainClass, Class<? extends Message> protobufClass) {
        if (domainClass.isAnnotationPresent(ProtoClass.class)) {
            return domainClass.getAnnotation(ProtoClass.class);
        }
        if (domainClass.isAnnotationPresent(ProtoClasses.class)) {
            ProtoClasses protoClasses = domainClass.getAnnotation(ProtoClasses.class);
            for (ProtoClass protoClass : protoClasses.value()) {
                if (!protobufClass.isAssignableFrom(protoClass.value())) continue;
                return protoClass;
            }
        }
        return null;
    }

    public static Mapper createMapper(ProtoClass annotation) throws MappingException {
        try {
            return annotation.mapper().newInstance();
        }
        catch (InstantiationException e) {
            throw new MappingException("Default constructor not found.");
        }
        catch (IllegalAccessException e) {
            throw new MappingException("Make default constructor public for " + annotation.mapper().getSimpleName(), e);
        }
    }

    public static FieldResolverFactory createFieldFactory(ProtoClass annotation) throws MappingException {
        try {
            return annotation.fieldFactory().newInstance();
        }
        catch (InstantiationException e) {
            throw new MappingException("Default constructor not found.");
        }
        catch (IllegalAccessException e) {
            throw new MappingException("Make default constructor public for " + annotation.fieldFactory().getSimpleName(), e);
        }
    }

    public static TypeConverter<?, ?> createTypeConverter(ProtoField annotation) throws WriteException {
        try {
            return annotation.converter().newInstance();
        }
        catch (InstantiationException e) {
            throw new WriteException("Default constructor not found.");
        }
        catch (IllegalAccessException e) {
            throw new WriteException("Make default constructor public for " + annotation.converter().getSimpleName(), e);
        }
    }

    public static NullValueInspector createNullValueInspector(ProtoField annotation) throws WriteException {
        try {
            return annotation.nullValue().newInstance();
        }
        catch (InstantiationException e) {
            throw new WriteException("Default constructor not found.");
        }
        catch (IllegalAccessException e) {
            throw new WriteException("Make default constructor public for " + annotation.nullValue().getSimpleName(), e);
        }
    }

    public static DefaultValue createDefaultValue(ProtoField annotation) throws WriteException {
        try {
            return annotation.defaultValue().newInstance();
        }
        catch (InstantiationException e) {
            throw new WriteException("Default constructor not found.");
        }
        catch (IllegalAccessException e) {
            throw new WriteException("Make default constructor public for " + annotation.defaultValue().getSimpleName(), e);
        }
    }
}

