/*
 * Decompiled with CFR 0.152.
 */
package net.badata.protobuf.converter;

import net.badata.protobuf.converter.FieldsIgnore;

public final class Configuration {
    private final FieldsIgnore ignoredFields;
    private final boolean includeInheritedFields;

    public static Builder builder() {
        return new Builder();
    }

    private Configuration(FieldsIgnore ignoredFields, boolean includeInheritedFields) {
        this.ignoredFields = ignoredFields;
        this.includeInheritedFields = includeInheritedFields;
    }

    public FieldsIgnore getIgnoredFields() {
        return this.ignoredFields;
    }

    public boolean withInheritedFields() {
        return this.includeInheritedFields;
    }

    public static final class Builder {
        private FieldsIgnore ignoredFields = new FieldsIgnore();
        private boolean includeInheritedFields;

        public Builder setIgnoredFields(FieldsIgnore ignoredFields) {
            this.checkIgnoredFields(ignoredFields);
            this.ignoredFields = ignoredFields;
            return this;
        }

        private void checkIgnoredFields(FieldsIgnore ignoredFields) {
            if (ignoredFields == null) {
                throw new IllegalArgumentException("Argument ignoredFields can't be null");
            }
        }

        public Builder addIgnoredFields(FieldsIgnore ignoredFields) {
            this.checkIgnoredFields(ignoredFields);
            this.ignoredFields.addAll(ignoredFields);
            return this;
        }

        public Builder withInheritedFields() {
            this.includeInheritedFields = true;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.ignoredFields.copy(), this.includeInheritedFields);
        }

        private Builder() {
        }
    }
}

