/*
 * Decompiled with CFR 0.152.
 */
package com.avito.android.krop;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.view.View;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/avito/android/krop/OverlayView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "paint", "Landroid/graphics/Paint;", "viewport", "Landroid/graphics/RectF;", "getViewport", "()Landroid/graphics/RectF;", "setViewport", "(Landroid/graphics/RectF;)V", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "krop_release"})
public final class OverlayView
extends View {
    private final Paint paint;
    @NotNull
    private RectF viewport;

    @NotNull
    public final RectF getViewport() {
        return this.viewport;
    }

    public final void setViewport(@NotNull RectF rectF) {
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
        this.viewport = rectF;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.viewport.isEmpty()) {
            RectF rectF;
            RectF $receiver = rectF = this.viewport;
            $receiver.left = 0.0f;
            $receiver.top = 0.0f;
            $receiver.right = width;
            $receiver.bottom = height;
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.drawOval(this.viewport, this.paint);
    }

    public OverlayView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.paint = new Paint(1);
        this.viewport = new RectF();
        this.setLayerType(1, null);
        this.paint.setColor(-16777216);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }
}

