/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class ProtobufUtils {
    public static int parseIndex(Field field) {
        JsonProperty annotation = field.getAnnotation(JsonProperty.class);
        Objects.requireNonNull(annotation, "Cannot parse index: missing property annotation");
        return Integer.parseUnsignedInt(annotation.value());
    }

    public static String parseType(Field field, Object value) {
        JsonPropertyDescription annotation = field.getAnnotation(JsonPropertyDescription.class);
        if (annotation != null) {
            return annotation.value();
        }
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, Double.class, Boolean.class, String.class, byte[].class, Integer.class, Long.class}, (Object)object, n)) {
            case 0 -> {
                Float ignored = (Float)object;
                yield "float";
            }
            case 1 -> {
                Double ignored = (Double)object;
                yield "double";
            }
            case 2 -> {
                Boolean ignored = (Boolean)object;
                yield "bool";
            }
            case 3 -> {
                String ignored = (String)object;
                yield "string";
            }
            case 4 -> {
                byte[] ignored = (byte[])object;
                yield "bytes";
            }
            case 5 -> {
                Integer ignored = (Integer)object;
                yield "int32";
            }
            case 6 -> {
                Long ignored = (Long)object;
                yield "int64";
            }
            default -> "object";
        };
    }

    public static boolean isRequired(Field field) {
        JsonProperty annotation = field.getAnnotation(JsonProperty.class);
        Objects.requireNonNull(annotation, "Cannot parse index: missing property annotation");
        return annotation.required();
    }

    private ProtobufUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

