/*
 * Decompiled with CFR 0.152.
 */
package it.auties.protobuf.decoder;

import it.auties.protobuf.decoder.DeserializationException;
import java.io.IOException;
import java.util.Arrays;

class ArrayInputStream {
    private final byte[] buffer;
    private final int limit;
    private int pos;
    private int lastTag;

    public ArrayInputStream(byte[] buffer) {
        this.buffer = buffer;
        this.limit = buffer.length;
        this.pos = 0;
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (this.getTagFieldNumber(this.lastTag) == 0) {
            throw DeserializationException.invalidTag();
        }
        return this.lastTag;
    }

    private int getTagFieldNumber(int tag) {
        return tag >>> 3;
    }

    public int readRawVarint32() throws IOException {
        block4: {
            int x;
            int tempPos;
            block6: {
                byte[] buffer;
                block8: {
                    block7: {
                        block5: {
                            tempPos = this.pos;
                            if (this.limit == tempPos) break block4;
                            buffer = this.buffer;
                            if ((x = buffer[tempPos++]) >= 0) {
                                this.pos = tempPos;
                                return x;
                            }
                            if (this.limit - tempPos < 9) break block4;
                            if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                            x ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                        x ^= 0x3F80;
                        break block6;
                    }
                    if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                    x ^= 0xFFE03F80;
                    break block6;
                }
                byte y = buffer[tempPos++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0) break block4;
            }
            this.pos = tempPos;
            return x;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    long readRawVarint64SlowPath() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw DeserializationException.malformedVarInt();
    }

    public byte readRawByte() throws IOException {
        if (this.pos == this.limit) {
            throw DeserializationException.truncatedMessage();
        }
        return this.buffer[this.pos++];
    }

    public void checkLastTagWas(int value) throws DeserializationException {
        if (this.lastTag == value) {
            return;
        }
        throw DeserializationException.invalidEndTag(this.lastTag);
    }

    public long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public long readRawVarint64() throws IOException {
        block4: {
            long x;
            int tempPos;
            block6: {
                byte[] buffer;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int y;
                                block8: {
                                    block7: {
                                        block5: {
                                            tempPos = this.pos;
                                            if (this.limit == tempPos) break block4;
                                            buffer = this.buffer;
                                            if ((y = buffer[tempPos++]) >= 0) {
                                                this.pos = tempPos;
                                                return y;
                                            }
                                            if (this.limit - tempPos < 9) break block4;
                                            if ((y ^= buffer[tempPos++] << 7) >= 0) break block5;
                                            x = y ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((y ^= buffer[tempPos++] << 14) < 0) break block7;
                                        x = y ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((y ^= buffer[tempPos++] << 21) >= 0) break block8;
                                    x = y ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((x = (long)y ^ (long)buffer[tempPos++] << 28) < 0L) break block9;
                                x ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((x ^= (long)buffer[tempPos++] << 35) >= 0L) break block10;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((x ^= (long)buffer[tempPos++] << 42) < 0L) break block11;
                        x ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((x ^= (long)buffer[tempPos++] << 49) >= 0L) break block12;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                x ^= (long)buffer[tempPos++] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buffer[tempPos++] < 0L) break block4;
            }
            this.pos = tempPos;
            return x;
        }
        return this.readRawVarint64SlowPath();
    }

    public long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public long readRawLittleEndian64() throws IOException {
        int tempPos = this.pos;
        if (this.limit - tempPos < 8) {
            throw DeserializationException.truncatedMessage();
        }
        byte[] buffer = this.buffer;
        this.pos = tempPos + 8;
        return (long)buffer[tempPos] & 0xFFL | ((long)buffer[tempPos + 1] & 0xFFL) << 8 | ((long)buffer[tempPos + 2] & 0xFFL) << 16 | ((long)buffer[tempPos + 3] & 0xFFL) << 24 | ((long)buffer[tempPos + 4] & 0xFFL) << 32 | ((long)buffer[tempPos + 5] & 0xFFL) << 40 | ((long)buffer[tempPos + 6] & 0xFFL) << 48 | ((long)buffer[tempPos + 7] & 0xFFL) << 56;
    }

    public byte[] readBytes() throws IOException {
        int size = this.readRawVarint32();
        if (size > 0 && size <= this.limit - this.pos) {
            byte[] result = new byte[size];
            System.arraycopy(this.buffer, this.pos, result, 0, size);
            this.pos += size;
            return result;
        }
        return size == 0 ? new byte[]{} : this.readRawBytes(size);
    }

    public byte[] readRawBytes(int length) throws IOException {
        if (length > 0 && length <= this.limit - this.pos) {
            int tempPos = this.pos;
            this.pos += length;
            return Arrays.copyOfRange(this.buffer, tempPos, this.pos);
        }
        if (length <= 0) {
            if (length == 0) {
                return new byte[0];
            }
            throw DeserializationException.negativeSize();
        }
        throw DeserializationException.truncatedMessage();
    }

    public int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public int readRawLittleEndian32() throws IOException {
        int tempPos = this.pos;
        if (this.limit - tempPos < 4) {
            throw DeserializationException.truncatedMessage();
        }
        byte[] buffer = this.buffer;
        this.pos = tempPos + 4;
        return buffer[tempPos] & 0xFF | (buffer[tempPos + 1] & 0xFF) << 8 | (buffer[tempPos + 2] & 0xFF) << 16 | (buffer[tempPos + 3] & 0xFF) << 24;
    }

    public boolean isAtEnd() {
        return this.pos == this.limit;
    }
}

