/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.content.Context;
import android.support.v4.view.animation.FastOutLinearInInterpolator;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.widget.OverScroller;
import com.alamkanak.weekview.Constants;
import com.alamkanak.weekview.EmptyViewClickListener;
import com.alamkanak.weekview.EmptyViewLongPressListener;
import com.alamkanak.weekview.EventChip;
import com.alamkanak.weekview.EventClickListener;
import com.alamkanak.weekview.EventLongPressListener;
import com.alamkanak.weekview.OnVerticalScrollListener;
import com.alamkanak.weekview.ScrollListener;
import com.alamkanak.weekview.WeekView;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewData;
import com.alamkanak.weekview.WeekViewDrawingConfig;
import com.alamkanak.weekview.WeekViewException;
import com.alamkanak.weekview.WeekViewLoader;
import com.alamkanak.weekview.WeekViewTouchHandler;
import java.util.Calendar;
import java.util.List;

final class WeekViewGestureHandler<T>
extends GestureDetector.SimpleOnGestureListener {
    private Listener listener;
    private WeekViewData<T> data;
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawingConfig;
    private WeekViewTouchHandler touchHandler;
    private OverScroller scroller;
    private Direction currentScrollDirection = Direction.NONE;
    private Direction currentFlingDirection = Direction.NONE;
    private GestureDetector gestureDetector;
    private ScaleGestureDetector scaleDetector;
    private boolean isZooming;
    private int minimumFlingVelocity;
    private int scaledTouchSlop;
    private EventClickListener<T> eventClickListener;
    private EventLongPressListener<T> eventLongPressListener;
    private EmptyViewClickListener emptyViewClickListener;
    private EmptyViewLongPressListener emptyViewLongPressListener;
    private WeekViewLoader<T> weekViewLoader;
    private ScrollListener scrollListener;
    private OnVerticalScrollListener onVerticalScrollListener;

    WeekViewGestureHandler(Context context, View view, WeekViewConfig config, WeekViewData<T> data) {
        this.listener = (Listener)view;
        this.data = data;
        this.config = config;
        this.drawingConfig = config.drawingConfig;
        this.touchHandler = new WeekViewTouchHandler(config);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
        this.scroller = new OverScroller(context, (Interpolator)new FastOutLinearInInterpolator());
        this.minimumFlingVelocity = ViewConfiguration.get((Context)context).getScaledMinimumFlingVelocity();
        this.scaledTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.scaleDetector = new ScaleGestureDetector(context, new ScaleGestureDetector.OnScaleGestureListener(){

            public void onScaleEnd(ScaleGestureDetector detector) {
                WeekViewGestureHandler.this.isZooming = false;
            }

            public boolean onScaleBegin(ScaleGestureDetector detector) {
                WeekViewGestureHandler.this.isZooming = true;
                WeekViewGestureHandler.this.goToNearestOrigin();
                return true;
            }

            public boolean onScale(ScaleGestureDetector detector) {
                float hourHeight = ((WeekViewGestureHandler)WeekViewGestureHandler.this).config.hourHeight;
                ((WeekViewGestureHandler)WeekViewGestureHandler.this).drawingConfig.newHourHeight = Math.round(hourHeight * detector.getScaleFactor());
                WeekViewGestureHandler.this.listener.onScaled();
                return true;
            }
        });
    }

    public void setVerticalScrollListener(OnVerticalScrollListener verticalScrollListener) {
        this.onVerticalScrollListener = verticalScrollListener;
    }

    public boolean onDown(MotionEvent e) {
        this.goToNearestOrigin();
        return true;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.isZooming) {
            return true;
        }
        float absDistanceX = Math.abs(distanceX);
        float absDistanceY = Math.abs(distanceY);
        boolean canScrollHorizontally = this.config.horizontalScrollingEnabled;
        switch (this.currentScrollDirection) {
            case NONE: {
                if (absDistanceX > absDistanceY && canScrollHorizontally) {
                    if (distanceX > 0.0f) {
                        this.currentScrollDirection = Direction.LEFT;
                        break;
                    }
                    this.currentScrollDirection = Direction.RIGHT;
                    break;
                }
                if (this.scroller.isFinished()) {
                    if (distanceY > 0.0f) {
                        this.onVerticalScrollListener.onScrollTop();
                    } else {
                        this.onVerticalScrollListener.onScrollDown();
                    }
                }
                this.currentScrollDirection = Direction.VERTICAL;
                break;
            }
            case LEFT: {
                if (!(absDistanceX > absDistanceY) || !(distanceX < (float)(-this.scaledTouchSlop))) break;
                this.currentScrollDirection = Direction.RIGHT;
                break;
            }
            case RIGHT: {
                if (!(absDistanceX > absDistanceY) || !(distanceX > (float)this.scaledTouchSlop)) break;
                this.currentScrollDirection = Direction.LEFT;
            }
        }
        switch (this.currentScrollDirection) {
            case LEFT: 
            case RIGHT: {
                this.drawingConfig.currentOrigin.x -= distanceX * this.config.xScrollingSpeed;
                this.listener.onScrolled();
                break;
            }
            case VERTICAL: {
                this.drawingConfig.currentOrigin.y -= distanceY;
                this.listener.onScrolled();
            }
        }
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.isZooming) {
            return true;
        }
        if (this.currentFlingDirection == Direction.LEFT && !this.config.horizontalFlingEnabled || this.currentFlingDirection == Direction.RIGHT && !this.config.horizontalFlingEnabled || this.currentFlingDirection == Direction.VERTICAL && !this.config.verticalFlingEnabled) {
            return true;
        }
        this.scroller.forceFinished(true);
        this.currentFlingDirection = this.currentScrollDirection;
        switch (this.currentFlingDirection) {
            case LEFT: 
            case RIGHT: {
                this.onFlingHorizontal(velocityX);
                break;
            }
            case VERTICAL: {
                this.onFlingVertical(velocityY);
            }
        }
        this.listener.onScrolled();
        return true;
    }

    private void onFlingHorizontal(float originalVelocityX) {
        int startX = (int)this.drawingConfig.currentOrigin.x;
        int startY = (int)this.drawingConfig.currentOrigin.y;
        boolean velocityY = false;
        int velocityX = originalVelocityX > 0.0f ? (int)(2000.0f * this.config.xScrollingSpeed) : (int)(-2000.0f * this.config.xScrollingSpeed);
        int minX = Integer.MIN_VALUE;
        int maxX = Integer.MAX_VALUE;
        int dayHeight = this.config.hourHeight * Constants.HOURS_PER_DAY;
        int viewHeight = WeekView.getViewHeight();
        float headerHeight = this.drawingConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawingConfig.headerMarginBottom;
        int minY = (int)((float)dayHeight + headerHeight - (float)viewHeight) * -1;
        boolean maxY = false;
        this.scroller.fling(startX, startY, velocityX, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, minY, 0);
    }

    private void onFlingVertical(float originalVelocityY) {
        int startX = (int)this.drawingConfig.currentOrigin.x;
        int startY = (int)this.drawingConfig.currentOrigin.y;
        boolean velocityX = false;
        int velocityY = (int)originalVelocityY;
        int minX = Integer.MIN_VALUE;
        int maxX = Integer.MAX_VALUE;
        int dayHeight = this.config.hourHeight * Constants.HOURS_PER_DAY;
        int viewHeight = WeekView.getViewHeight();
        float headerHeight = this.drawingConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawingConfig.headerMarginBottom;
        int minY = (int)((float)dayHeight + headerHeight - (float)viewHeight) * -1;
        boolean maxY = false;
        this.scroller.fling(startX, startY, 0, velocityY, Integer.MIN_VALUE, Integer.MAX_VALUE, minY, 0);
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        Calendar selectedTime;
        EventChip<T> eventChip = this.findHitEvent(e);
        if (eventChip != null && this.eventClickListener != null) {
            Object data = eventChip.event.getData();
            if (data == null) {
                throw new WeekViewException("No data to show. Did you pass the original object into the constructor of WeekViewEvent?");
            }
            this.eventClickListener.onEventClick(data, eventChip.rect);
            return super.onSingleTapConfirmed(e);
        }
        float headerHeight = this.drawingConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawingConfig.headerMarginBottom;
        float timeColumnWidth = this.drawingConfig.timeColumnWidth;
        if (this.emptyViewClickListener != null && e.getX() > timeColumnWidth && e.getY() > headerHeight && (selectedTime = this.touchHandler.getTimeFromPoint(e)) != null) {
            this.emptyViewClickListener.onEmptyViewClicked(selectedTime);
        }
        return super.onSingleTapConfirmed(e);
    }

    public void onLongPress(MotionEvent e) {
        Calendar selectedTime;
        super.onLongPress(e);
        EventChip<T> eventChip = this.findHitEvent(e);
        if (eventChip != null && this.eventLongPressListener != null) {
            Object data = eventChip.originalEvent.getData();
            if (data != null) {
                this.eventLongPressListener.onEventLongPress(data, eventChip.rect);
            } else {
                throw new WeekViewException("No data to show. Did you pass the original object into the constructor of WeekViewEvent?");
            }
        }
        float headerHeight = this.drawingConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawingConfig.headerMarginBottom;
        float timeColumnWidth = this.drawingConfig.timeColumnWidth;
        if (this.emptyViewLongPressListener != null && e.getX() > timeColumnWidth && e.getY() > headerHeight && (selectedTime = this.touchHandler.getTimeFromPoint(e)) != null) {
            this.emptyViewLongPressListener.onEmptyViewLongPress(selectedTime);
        }
    }

    private EventChip<T> findHitEvent(MotionEvent e) {
        List<EventChip<T>> eventChips = this.data.getAllEventChips();
        if (eventChips != null) {
            for (EventChip<T> eventChip : eventChips) {
                if (!eventChip.isHit(e)) continue;
                return eventChip;
            }
        }
        return null;
    }

    EventClickListener getEventClickListener() {
        return this.eventClickListener;
    }

    void setEventClickListener(EventClickListener<T> eventClickListener) {
        this.eventClickListener = eventClickListener;
    }

    EventLongPressListener getEventLongPressListener() {
        return this.eventLongPressListener;
    }

    void setEventLongPressListener(EventLongPressListener<T> eventLongPressListener) {
        this.eventLongPressListener = eventLongPressListener;
    }

    WeekViewLoader<T> getWeekViewLoader() {
        return this.weekViewLoader;
    }

    void setWeekViewLoader(WeekViewLoader<T> weekViewLoader) {
        this.weekViewLoader = weekViewLoader;
    }

    EmptyViewClickListener getEmptyViewClickListener() {
        return this.emptyViewClickListener;
    }

    void setEmptyViewClickListener(EmptyViewClickListener emptyViewClickListener) {
        this.emptyViewClickListener = emptyViewClickListener;
    }

    EmptyViewLongPressListener getEmptyViewLongPressListener() {
        return this.emptyViewLongPressListener;
    }

    void setEmptyViewLongPressListener(EmptyViewLongPressListener emptyViewLongPressListener) {
        this.emptyViewLongPressListener = emptyViewLongPressListener;
    }

    ScrollListener getScrollListener() {
        return this.scrollListener;
    }

    void setScrollListener(ScrollListener scrollListener) {
        this.scrollListener = scrollListener;
    }

    private void goToNearestOrigin() {
        float totalDayWidth = this.config.getTotalDayWidth();
        double leftDays = this.drawingConfig.currentOrigin.x / totalDayWidth;
        leftDays = this.currentFlingDirection != Direction.NONE ? (double)Math.round(leftDays) : (this.currentScrollDirection == Direction.LEFT ? Math.floor(leftDays) : (this.currentScrollDirection == Direction.RIGHT ? Math.ceil(leftDays) : (double)Math.round(leftDays)));
        int nearestOrigin = (int)((double)this.drawingConfig.currentOrigin.x - leftDays * (double)totalDayWidth);
        if (nearestOrigin != 0) {
            this.scroller.forceFinished(true);
            int startX = (int)this.drawingConfig.currentOrigin.x;
            int startY = (int)this.drawingConfig.currentOrigin.y;
            int distanceX = -nearestOrigin;
            boolean distanceY = false;
            float daysScrolled = (float)Math.abs(nearestOrigin) / this.drawingConfig.widthPerDay;
            int duration = (int)(daysScrolled * (float)this.config.scrollDuration);
            this.scroller.startScroll(startX, startY, distanceX, 0, duration);
            this.listener.onScrolled();
        }
        this.currentScrollDirection = this.currentFlingDirection = Direction.NONE;
    }

    boolean onTouchEvent(MotionEvent event) {
        this.scaleDetector.onTouchEvent(event);
        boolean val = this.gestureDetector.onTouchEvent(event);
        if (event.getAction() == 1 && !this.isZooming && this.currentFlingDirection == Direction.NONE) {
            if (this.currentScrollDirection == Direction.RIGHT || this.currentScrollDirection == Direction.LEFT) {
                this.goToNearestOrigin();
            }
            this.currentScrollDirection = Direction.NONE;
        }
        return val;
    }

    void forceScrollFinished() {
        this.scroller.forceFinished(true);
        this.currentScrollDirection = this.currentFlingDirection = Direction.NONE;
    }

    void computeScroll() {
        if (this.scroller.isFinished() && this.currentFlingDirection != Direction.NONE) {
            this.goToNearestOrigin();
        } else if (this.currentFlingDirection != Direction.NONE && this.shouldForceFinishScroll()) {
            this.goToNearestOrigin();
        } else if (this.scroller.computeScrollOffset()) {
            this.drawingConfig.currentOrigin.y = this.scroller.getCurrY();
            this.drawingConfig.currentOrigin.x = this.scroller.getCurrX();
            this.listener.onScrolled();
        }
    }

    private boolean shouldForceFinishScroll() {
        return this.scroller.getCurrVelocity() <= (float)this.minimumFlingVelocity;
    }

    static interface Listener {
        public void onScaled();

        public void onScrolled();
    }

    private static enum Direction {
        NONE,
        LEFT,
        RIGHT,
        VERTICAL;

    }
}

