/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.Color;
import android.support.annotation.NonNull;
import com.alamkanak.weekview.DateUtils;
import com.alamkanak.weekview.WeekViewDisplayable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class WeekViewEvent<T>
implements WeekViewDisplayable,
Comparable<WeekViewEvent> {
    private static final int DEFAULT_COLOR = Color.parseColor((String)"#9fc6e7");
    private long id;
    private String title;
    private Calendar startTime;
    private Calendar endTime;
    private String location;
    private int color;
    private boolean isAllDay;
    private T data;

    public WeekViewEvent() {
    }

    public WeekViewEvent(long id, String title, Calendar startTime, Calendar endTime) {
        this(id, title, startTime, endTime, null, false);
    }

    private WeekViewEvent(long id, String title, Calendar startTime, Calendar endTime, String location) {
        this(id, title, startTime, endTime, location, false);
    }

    public WeekViewEvent(long id, String title, Calendar startTime, Calendar endTime, String location, boolean isAllDay) {
        this(id, title, startTime, endTime, location, 0, isAllDay, null);
    }

    public WeekViewEvent(long id, String title, Calendar startTime, Calendar endTime, String location, int color, boolean isAllDay, T data) {
        this.id = id;
        this.title = title;
        this.startTime = startTime;
        this.endTime = endTime;
        this.location = location;
        this.color = color;
        this.isAllDay = isAllDay;
        this.data = data;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getColor() {
        return this.color;
    }

    public int getColorOrDefault() {
        return this.color != 0 ? this.color : DEFAULT_COLOR;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public boolean isAllDay() {
        return this.isAllDay;
    }

    public void setIsAllDay(boolean allDay) {
        this.isAllDay = allDay;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean isSameDay(Calendar other) {
        return DateUtils.isSameDay(this.startTime, other);
    }

    public boolean isSameDay(WeekViewEvent other) {
        return DateUtils.isSameDay(this.startTime, other.startTime);
    }

    public boolean collidesWith(WeekViewEvent other) {
        long thisStart = this.startTime.getTimeInMillis();
        long thisEnd = this.endTime.getTimeInMillis();
        long otherStart = other.getStartTime().getTimeInMillis();
        long otherEnd = other.getEndTime().getTimeInMillis();
        return thisStart < otherEnd && thisEnd > otherStart;
    }

    @Override
    public int compareTo(@NonNull WeekViewEvent other) {
        Long otherStart;
        Long thisStart = this.getStartTime().getTimeInMillis();
        int comparator = thisStart.compareTo(otherStart = Long.valueOf(other.getStartTime().getTimeInMillis()));
        if (comparator == 0) {
            Long thisEnd = this.getEndTime().getTimeInMillis();
            Long otherEnd = other.getEndTime().getTimeInMillis();
            comparator = thisEnd.compareTo(otherEnd);
        }
        return comparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeekViewEvent that = (WeekViewEvent)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    List<WeekViewEvent<T>> splitWeekViewEvents() {
        ArrayList<WeekViewEvent<T>> events = new ArrayList<WeekViewEvent>();
        Calendar newEndTime = (Calendar)this.endTime.clone();
        if (DateUtils.isAtStartOfNewDay(this.startTime, newEndTime)) {
            WeekViewEvent<T> shortenedEvent = this.shortenTooLongAllDayEvent(newEndTime);
            events.add(shortenedEvent);
        } else if (!this.isSameDay(newEndTime)) {
            events = this.splitEventByDays(newEndTime);
        } else {
            events.add(this);
        }
        return events;
    }

    private WeekViewEvent<T> shortenTooLongAllDayEvent(Calendar newEndTime) {
        return new WeekViewEvent<T>(this.id, this.title, this.startTime, DateUtils.withTimeAtEndOfDay(newEndTime), this.location, this.color, this.isAllDay, this.data);
    }

    private List<WeekViewEvent<T>> splitEventByDays(Calendar newEndTime) {
        ArrayList<WeekViewEvent<T>> results = new ArrayList<WeekViewEvent<T>>();
        newEndTime = DateUtils.withTimeAtEndOfDay(newEndTime);
        WeekViewEvent<T> event1 = new WeekViewEvent<T>(this.id, this.title, this.startTime, newEndTime, this.location, this.color, this.isAllDay, this.data);
        results.add(event1);
        Calendar otherDay = (Calendar)this.startTime.clone();
        otherDay.add(5, 1);
        while (!DateUtils.isSameDay(otherDay, this.endTime)) {
            Calendar overDay = (Calendar)otherDay.clone();
            overDay.set(11, 0);
            overDay.set(12, 0);
            Calendar endOfOverDay = (Calendar)overDay.clone();
            endOfOverDay.set(11, 23);
            endOfOverDay.set(12, 59);
            WeekViewEvent<T> eventMore = new WeekViewEvent<T>(this.id, this.title, overDay, endOfOverDay, this.location, this.color, this.isAllDay, this.data);
            results.add(eventMore);
            otherDay.add(5, 1);
        }
        Calendar startTime = (Calendar)this.endTime.clone();
        startTime.set(11, 0);
        startTime.set(12, 0);
        WeekViewEvent<T> event2 = new WeekViewEvent<T>(this.id, this.title, startTime, this.endTime, this.location, this.color, this.isAllDay, this.data);
        results.add(event2);
        return results;
    }

    @Override
    public WeekViewEvent<T> toWeekViewEvent() {
        return this;
    }
}

