/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextPaint;
import com.alamkanak.weekview.DateTimeInterpreter;
import com.alamkanak.weekview.DateUtils;
import com.alamkanak.weekview.WeekView;
import com.alamkanak.weekview.WeekViewConfig;
import java.text.SimpleDateFormat;
import java.util.Calendar;

class WeekViewDrawingConfig {
    Paint timeTextPaint;
    float timeTextWidth;
    float timeTextHeight;
    Paint headerTextPaint;
    float headerTextHeight;
    float headerHeight;
    Paint todayHeaderTextPaint;
    PointF currentOrigin = new PointF(0.0f, 0.0f);
    Paint headerBackgroundPaint;
    float widthPerDay;
    Paint dayBackgroundPaint;
    Paint hourSeparatorPaint;
    Paint daySeparatorPaint;
    float headerMarginBottom;
    Paint todayBackgroundPaint;
    private Paint futureBackgroundPaint;
    private Paint pastBackgroundPaint;
    private Paint futureWeekendBackgroundPaint;
    private Paint pastWeekendBackgroundPaint;
    Paint timeColumnSeparatorPaint;
    Paint nowLinePaint;
    Paint nowDotPaint;
    float timeColumnWidth;
    TextPaint eventTextPaint;
    Paint timeColumnBackgroundPaint;
    int newHourHeight = -1;
    DateTimeInterpreter dateTimeInterpreter;

    WeekViewDrawingConfig(Context context, WeekViewConfig config) {
        this.timeTextPaint = new Paint(1);
        this.timeTextPaint.setTextAlign(Paint.Align.RIGHT);
        this.timeTextPaint.setTextSize((float)config.timeColumnTextSize);
        this.timeTextPaint.setColor(config.timeColumnTextColor);
        Rect rect = new Rect();
        this.timeTextPaint.getTextBounds("00 PM", 0, "00 PM".length(), rect);
        this.timeTextHeight = rect.height();
        this.initTextTimeWidth(context);
        this.headerTextPaint = new Paint(1);
        this.headerTextPaint.setColor(config.headerRowTextColor);
        this.headerTextPaint.setTextAlign(Paint.Align.CENTER);
        this.headerTextPaint.setTextSize((float)config.headerRowTextSize);
        this.headerTextPaint.getTextBounds("00 PM", 0, "00 PM".length(), rect);
        this.headerTextHeight = rect.height();
        this.headerTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.headerBackgroundPaint = new Paint();
        this.headerBackgroundPaint.setColor(config.headerRowBackgroundColor);
        this.dayBackgroundPaint = new Paint();
        this.dayBackgroundPaint.setColor(config.dayBackgroundColor);
        this.futureBackgroundPaint = new Paint();
        this.futureBackgroundPaint.setColor(config.futureBackgroundColor);
        this.pastBackgroundPaint = new Paint();
        this.pastBackgroundPaint.setColor(config.pastBackgroundColor);
        this.futureWeekendBackgroundPaint = new Paint();
        this.futureWeekendBackgroundPaint.setColor(config.futureWeekendBackgroundColor);
        this.pastWeekendBackgroundPaint = new Paint();
        this.pastWeekendBackgroundPaint.setColor(config.pastWeekendBackgroundColor);
        this.timeColumnSeparatorPaint = new Paint();
        this.timeColumnSeparatorPaint.setColor(config.timeColumnSeparatorColor);
        this.timeColumnSeparatorPaint.setStrokeWidth((float)config.timeColumnSeparatorStrokeWidth);
        this.hourSeparatorPaint = new Paint();
        this.hourSeparatorPaint.setStyle(Paint.Style.STROKE);
        this.hourSeparatorPaint.setStrokeWidth((float)config.hourSeparatorStrokeWidth);
        this.hourSeparatorPaint.setColor(config.hourSeparatorColor);
        this.daySeparatorPaint = new Paint();
        this.daySeparatorPaint.setStyle(Paint.Style.STROKE);
        this.daySeparatorPaint.setStrokeWidth((float)config.daySeparatorStrokeWidth);
        this.daySeparatorPaint.setColor(config.daySeparatorColor);
        this.nowLinePaint = new Paint();
        this.nowLinePaint.setStrokeWidth((float)config.nowLineStrokeWidth);
        this.nowLinePaint.setColor(config.nowLineColor);
        this.nowDotPaint = new Paint();
        this.nowDotPaint.setStyle(Paint.Style.FILL);
        this.nowDotPaint.setStrokeWidth((float)config.nowLineDotRadius);
        this.nowDotPaint.setColor(config.nowLineDotColor);
        this.todayBackgroundPaint = new Paint();
        this.todayBackgroundPaint.setColor(config.todayBackgroundColor);
        this.todayHeaderTextPaint = new Paint(1);
        this.todayHeaderTextPaint.setTextAlign(Paint.Align.CENTER);
        this.todayHeaderTextPaint.setTextSize((float)config.headerRowTextSize);
        this.todayHeaderTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.todayHeaderTextPaint.setColor(config.todayHeaderTextColor);
        this.timeColumnBackgroundPaint = new Paint();
        this.timeColumnBackgroundPaint.setColor(config.timeColumnBackgroundColor);
        this.eventTextPaint = new TextPaint(65);
        this.eventTextPaint.setStyle(Paint.Style.FILL);
        this.eventTextPaint.setColor(config.eventTextColor);
        this.eventTextPaint.setTextSize((float)config.eventTextSize);
    }

    void moveCurrentOriginIfFirstDraw(WeekViewConfig config) {
        boolean currentDayIsNotToday;
        Calendar today = DateUtils.today();
        boolean isWeekView = config.numberOfVisibleDays >= 7;
        boolean bl = currentDayIsNotToday = today.get(7) != config.firstDayOfWeek;
        if (isWeekView && currentDayIsNotToday && config.showFirstDayOfWeekFirst) {
            int difference = today.get(7) - config.firstDayOfWeek;
            this.currentOrigin.x += (this.widthPerDay + (float)config.columnGap) * (float)difference;
        }
    }

    void refreshAfterZooming(WeekViewConfig config) {
        if (this.newHourHeight > 0) {
            if (this.newHourHeight < config.effectiveMinHourHeight) {
                this.newHourHeight = config.effectiveMinHourHeight;
            } else if (this.newHourHeight > config.maxHourHeight) {
                this.newHourHeight = config.maxHourHeight;
            }
            this.currentOrigin.y = this.currentOrigin.y / (float)config.hourHeight * (float)this.newHourHeight;
            config.hourHeight = this.newHourHeight;
            this.newHourHeight = -1;
        }
    }

    void updateVerticalOrigin(WeekViewConfig config) {
        int height = WeekView.getViewHeight();
        float dayHeight = config.hourHeight * 24;
        float headerHeight = this.headerHeight + (float)(config.headerRowPadding * 2) + this.headerMarginBottom;
        float potentialNewVerticalOrigin = (float)height - (dayHeight + headerHeight);
        this.currentOrigin.y = Math.max(this.currentOrigin.y, potentialNewVerticalOrigin);
        this.currentOrigin.y = Math.min(this.currentOrigin.y, 0.0f);
    }

    void resetOrigin() {
        this.currentOrigin = new PointF(0.0f, 0.0f);
    }

    void setTextSize(int textSize) {
        this.todayHeaderTextPaint.setTextSize((float)textSize);
        this.headerTextPaint.setTextSize((float)textSize);
        this.timeTextPaint.setTextSize((float)textSize);
    }

    void setHeaderRowTextColor(int headerRowTextColor) {
        this.headerTextPaint.setColor(headerRowTextColor);
    }

    void setTimeColumnTextColor(int timeColumnTextColor) {
        this.timeTextPaint.setColor(timeColumnTextColor);
    }

    void setDateTimeInterpreter(DateTimeInterpreter dateTimeInterpreter, Context context) {
        this.dateTimeInterpreter = dateTimeInterpreter;
        this.initTextTimeWidth(context);
    }

    Paint getPastBackgroundPaint(boolean useWeekendColor) {
        return useWeekendColor ? this.pastWeekendBackgroundPaint : this.pastBackgroundPaint;
    }

    Paint getFutureBackgroundPaint(boolean useWeekendColor) {
        return useWeekendColor ? this.futureWeekendBackgroundPaint : this.futureBackgroundPaint;
    }

    Paint getTodayBackgroundPaint(boolean isToday) {
        return isToday ? this.todayBackgroundPaint : this.dayBackgroundPaint;
    }

    private void initTextTimeWidth(Context context) {
        DateTimeInterpreter interpreter = this.getDateTimeInterpreter(context);
        this.timeTextWidth = 0.0f;
        for (int i = 0; i < 11; ++i) {
            String time = interpreter.interpretTime(i);
            if (time == null) {
                throw new IllegalStateException("A DateTimeInterpreter must not return null time");
            }
            this.timeTextWidth = Math.max(this.timeTextWidth, this.timeTextPaint.measureText(time));
        }
    }

    DateTimeInterpreter getDateTimeInterpreter(Context context) {
        if (this.dateTimeInterpreter == null) {
            this.dateTimeInterpreter = this.buildDefaultDateTimeInterpreter(context);
        }
        return this.dateTimeInterpreter;
    }

    private DateTimeInterpreter buildDefaultDateTimeInterpreter(final Context context) {
        return new DateTimeInterpreter(){
            private SimpleDateFormat sdfDate = DateUtils.getDateFormat();
            private SimpleDateFormat sdfTime = DateUtils.getTimeFormat(context);
            private Calendar calendar = Calendar.getInstance();

            @Override
            public String interpretDate(Calendar date) {
                try {
                    return this.sdfDate.format(date.getTime()).toUpperCase();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "";
                }
            }

            @Override
            public String interpretTime(int hour) {
                this.calendar.set(11, hour);
                this.calendar.set(12, 0);
                try {
                    return this.sdfTime.format(this.calendar.getTime());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "";
                }
            }
        };
    }
}

