/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import com.alamkanak.weekview.EventChip;
import com.alamkanak.weekview.WeekViewEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class WeekViewData<T> {
    private List<EventChip<T>> eventChips;
    private List<EventChip<T>> normalEventChips;
    private List<EventChip<T>> allDayEventChips;
    List<WeekViewEvent<T>> previousPeriodEvents;
    List<WeekViewEvent<T>> currentPeriodEvents;
    List<WeekViewEvent<T>> nextPeriodEvents;
    int fetchedPeriod = -1;

    WeekViewData() {
    }

    void setEventChips(List<EventChip<T>> eventChips) {
        this.eventChips = eventChips;
        this.normalEventChips = new ArrayList<EventChip<T>>();
        this.allDayEventChips = new ArrayList<EventChip<T>>();
        for (EventChip<T> eventChip : eventChips) {
            if (eventChip.event.isAllDay()) {
                this.allDayEventChips.add(eventChip);
                continue;
            }
            this.normalEventChips.add(eventChip);
        }
    }

    List<EventChip<T>> getAllEventChips() {
        return this.eventChips;
    }

    List<EventChip<T>> getNormalEventChips() {
        return this.normalEventChips;
    }

    List<EventChip<T>> getAllDayEventChips() {
        return this.allDayEventChips;
    }

    void clearEventChipsCache() {
        if (this.eventChips != null) {
            for (EventChip<T> eventChip : this.eventChips) {
                eventChip.rect = null;
            }
        }
    }

    void clear() {
        this.eventChips.clear();
        this.previousPeriodEvents = null;
        this.currentPeriodEvents = null;
        this.nextPeriodEvents = null;
        this.fetchedPeriod = -1;
    }

    void sortAndCacheEvents(List<WeekViewEvent<T>> events) {
        this.sortEvents(events);
        for (WeekViewEvent<T> event : events) {
            this.cacheEvent(event);
        }
    }

    private void sortEvents(List<WeekViewEvent<T>> events) {
        Collections.sort(events);
    }

    private void cacheEvent(WeekViewEvent<T> event) {
        if (event.getStartTime().compareTo(event.getEndTime()) >= 0) {
            return;
        }
        List<WeekViewEvent<T>> splittedEvents = event.splitWeekViewEvents();
        for (WeekViewEvent<T> splittedEvent : splittedEvents) {
            this.eventChips.add(new EventChip<T>(splittedEvent, event, null));
        }
    }
}

