/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.alamkanak.weekview.Constants;
import com.alamkanak.weekview.R;
import com.alamkanak.weekview.WeekViewDrawingConfig;

final class WeekViewConfig {
    WeekViewDrawingConfig drawingConfig;
    int firstDayOfWeek = 2;
    int numberOfVisibleDays = 3;
    boolean showFirstDayOfWeekFirst = false;
    boolean showHeaderRowBottomLine = false;
    int headerRowBottomLineColor = Color.rgb((int)102, (int)102, (int)102);
    int headerRowBottomLineWidth = 1;
    int timeColumnTextColor = -16777216;
    int timeColumnBackgroundColor = -1;
    int timeColumnPadding = 10;
    int timeColumnTextSize = 12;
    boolean showTimeColumnSeparator = false;
    int timeColumnSeparatorColor = Color.rgb((int)102, (int)102, (int)102);
    int timeColumnSeparatorStrokeWidth = 1;
    int headerRowTextSize = 12;
    int headerRowTextColor = -16777216;
    int headerRowBackgroundColor = -1;
    int headerRowPadding = 10;
    int todayHeaderTextColor = Color.rgb((int)39, (int)137, (int)228);
    int allDayEventHeight = 100;
    int eventCornerRadius = 0;
    int eventTextSize = 12;
    int eventTextColor = -16777216;
    int eventPadding = 8;
    int defaultEventColor = Color.parseColor((String)"#9fc6e7");
    int columnGap = 10;
    int overlappingEventGap = 0;
    int eventMarginVertical = 3;
    int eventMarginHorizontal = 0;
    int dayBackgroundColor = Color.rgb((int)255, (int)255, (int)255);
    int todayBackgroundColor = Color.rgb((int)255, (int)255, (int)255);
    boolean showDistinctWeekendColor = false;
    boolean showDistinctPastFutureColor = false;
    int pastBackgroundColor = Color.rgb((int)227, (int)227, (int)227);
    int futureBackgroundColor = Color.rgb((int)245, (int)245, (int)245);
    int pastWeekendBackgroundColor = 0;
    int futureWeekendBackgroundColor = 0;
    int hourHeight = 50;
    int minHourHeight = 0;
    int maxHourHeight = 250;
    int effectiveMinHourHeight = this.minHourHeight;
    boolean showNowLine = false;
    int nowLineColor = Color.rgb((int)102, (int)102, (int)102);
    int nowLineStrokeWidth = 5;
    boolean showNowLineDot = false;
    int nowLineDotColor = Color.rgb((int)102, (int)102, (int)102);
    int nowLineDotRadius = 16;
    boolean showHourSeparator = true;
    int hourSeparatorColor = Color.rgb((int)230, (int)230, (int)230);
    int hourSeparatorStrokeWidth = 2;
    boolean showDaySeparator = true;
    int daySeparatorColor = Color.rgb((int)230, (int)230, (int)230);
    int daySeparatorStrokeWidth = 2;
    float xScrollingSpeed = 1.0f;
    boolean verticalFlingEnabled = true;
    boolean horizontalFlingEnabled = true;
    boolean horizontalScrollingEnabled = true;
    int scrollDuration = 250;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WeekViewConfig(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.WeekView, 0, 0);
        try {
            this.firstDayOfWeek = a.getInteger(R.styleable.WeekView_firstDayOfWeek, this.firstDayOfWeek);
            this.numberOfVisibleDays = a.getInteger(R.styleable.WeekView_numberOfVisibleDays, this.numberOfVisibleDays);
            this.showFirstDayOfWeekFirst = a.getBoolean(R.styleable.WeekView_showFirstDayOfWeekFirst, this.showFirstDayOfWeekFirst);
            this.showHeaderRowBottomLine = a.getBoolean(R.styleable.WeekView_showHeaderRowBottomLine, this.showHeaderRowBottomLine);
            this.headerRowBottomLineColor = a.getColor(R.styleable.WeekView_headerRowBottomLineColor, this.headerRowBottomLineColor);
            this.headerRowBottomLineWidth = a.getDimensionPixelSize(R.styleable.WeekView_headerRowBottomLineWidth, this.headerRowBottomLineWidth);
            this.timeColumnTextColor = a.getColor(R.styleable.WeekView_timeColumnTextColor, this.timeColumnTextColor);
            this.timeColumnTextSize = a.getDimensionPixelSize(R.styleable.WeekView_timeColumnTextSize, (int)TypedValue.applyDimension((int)2, (float)this.timeColumnTextSize, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            this.timeColumnPadding = a.getDimensionPixelSize(R.styleable.WeekView_timeColumnPadding, this.timeColumnPadding);
            this.timeColumnBackgroundColor = a.getColor(R.styleable.WeekView_timeColumnBackgroundColor, this.timeColumnBackgroundColor);
            this.showTimeColumnSeparator = a.getBoolean(R.styleable.WeekView_showTimeColumnSeparator, this.showTimeColumnSeparator);
            this.timeColumnSeparatorColor = a.getColor(R.styleable.WeekView_timeColumnSeparatorColor, this.timeColumnSeparatorColor);
            this.timeColumnSeparatorStrokeWidth = a.getDimensionPixelSize(R.styleable.WeekView_timeColumnSeparatorStrokeWidth, this.timeColumnSeparatorStrokeWidth);
            this.headerRowTextColor = a.getColor(R.styleable.WeekView_headerRowTextColor, this.headerRowTextColor);
            this.headerRowBackgroundColor = a.getColor(R.styleable.WeekView_headerRowBackgroundColor, this.headerRowBackgroundColor);
            this.headerRowTextSize = a.getDimensionPixelSize(R.styleable.WeekView_headerRowTextSize, (int)TypedValue.applyDimension((int)2, (float)this.headerRowTextSize, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            this.headerRowPadding = a.getDimensionPixelSize(R.styleable.WeekView_headerRowPadding, this.headerRowPadding);
            this.todayHeaderTextColor = a.getColor(R.styleable.WeekView_todayHeaderTextColor, this.todayHeaderTextColor);
            this.allDayEventHeight = a.getDimensionPixelSize(R.styleable.WeekView_allDayEventHeight, this.allDayEventHeight);
            this.eventCornerRadius = a.getDimensionPixelSize(R.styleable.WeekView_eventCornerRadius, this.eventCornerRadius);
            this.eventTextSize = a.getDimensionPixelSize(R.styleable.WeekView_eventTextSize, (int)TypedValue.applyDimension((int)2, (float)this.eventTextSize, (DisplayMetrics)context.getResources().getDisplayMetrics()));
            this.eventTextColor = a.getColor(R.styleable.WeekView_eventTextColor, this.eventTextColor);
            this.eventPadding = a.getDimensionPixelSize(R.styleable.WeekView_eventPadding, this.eventPadding);
            this.defaultEventColor = a.getColor(R.styleable.WeekView_defaultEventColor, this.defaultEventColor);
            this.columnGap = a.getDimensionPixelSize(R.styleable.WeekView_columnGap, this.columnGap);
            this.overlappingEventGap = a.getDimensionPixelSize(R.styleable.WeekView_overlappingEventGap, this.overlappingEventGap);
            this.eventMarginVertical = a.getDimensionPixelSize(R.styleable.WeekView_eventMarginVertical, this.eventMarginVertical);
            this.eventMarginHorizontal = a.getDimensionPixelSize(R.styleable.WeekView_singleDayHorizontalMargin, this.eventMarginHorizontal);
            this.dayBackgroundColor = a.getColor(R.styleable.WeekView_dayBackgroundColor, this.dayBackgroundColor);
            this.todayBackgroundColor = a.getColor(R.styleable.WeekView_todayBackgroundColor, this.todayBackgroundColor);
            this.showDistinctPastFutureColor = a.getBoolean(R.styleable.WeekView_showDistinctPastFutureColor, this.showDistinctPastFutureColor);
            this.showDistinctWeekendColor = a.getBoolean(R.styleable.WeekView_showDistinctWeekendColor, this.showDistinctWeekendColor);
            this.pastBackgroundColor = a.getColor(R.styleable.WeekView_pastBackgroundColor, this.pastBackgroundColor);
            this.futureBackgroundColor = a.getColor(R.styleable.WeekView_futureBackgroundColor, this.futureBackgroundColor);
            this.pastWeekendBackgroundColor = a.getColor(R.styleable.WeekView_pastWeekendBackgroundColor, this.pastBackgroundColor);
            this.futureWeekendBackgroundColor = a.getColor(R.styleable.WeekView_futureWeekendBackgroundColor, this.futureBackgroundColor);
            this.hourHeight = a.getDimensionPixelSize(R.styleable.WeekView_hourHeight, this.hourHeight);
            this.minHourHeight = a.getDimensionPixelSize(R.styleable.WeekView_minHourHeight, this.minHourHeight);
            this.maxHourHeight = a.getDimensionPixelSize(R.styleable.WeekView_maxHourHeight, this.maxHourHeight);
            this.effectiveMinHourHeight = this.minHourHeight;
            this.showNowLine = a.getBoolean(R.styleable.WeekView_showNowLine, this.showNowLine);
            this.nowLineColor = a.getColor(R.styleable.WeekView_nowLineColor, this.nowLineColor);
            this.nowLineStrokeWidth = a.getDimensionPixelSize(R.styleable.WeekView_nowLineStrokeWidth, this.nowLineStrokeWidth);
            this.showNowLineDot = a.getBoolean(R.styleable.WeekView_showNowLineDot, this.showNowLineDot);
            this.nowLineDotColor = a.getColor(R.styleable.WeekView_nowLineDotColor, this.nowLineDotColor);
            this.nowLineDotRadius = a.getDimensionPixelSize(R.styleable.WeekView_nowLineDotRadius, this.nowLineDotRadius);
            this.showHourSeparator = a.getBoolean(R.styleable.WeekView_showHourSeparator, this.showHourSeparator);
            this.hourSeparatorColor = a.getColor(R.styleable.WeekView_hourSeparatorColor, this.hourSeparatorColor);
            this.hourSeparatorStrokeWidth = a.getDimensionPixelSize(R.styleable.WeekView_hourSeparatorStrokeWidth, this.hourSeparatorStrokeWidth);
            this.showDaySeparator = a.getBoolean(R.styleable.WeekView_showDaySeparator, this.showDaySeparator);
            this.daySeparatorColor = a.getColor(R.styleable.WeekView_daySeparatorColor, this.daySeparatorColor);
            this.daySeparatorStrokeWidth = a.getDimensionPixelSize(R.styleable.WeekView_daySeparatorStrokeWidth, this.daySeparatorStrokeWidth);
            this.xScrollingSpeed = a.getFloat(R.styleable.WeekView_xScrollingSpeed, this.xScrollingSpeed);
            this.horizontalFlingEnabled = a.getBoolean(R.styleable.WeekView_horizontalFlingEnabled, this.horizontalFlingEnabled);
            this.horizontalScrollingEnabled = a.getBoolean(R.styleable.WeekView_horizontalScrollingEnabled, this.horizontalScrollingEnabled);
            this.verticalFlingEnabled = a.getBoolean(R.styleable.WeekView_verticalFlingEnabled, this.verticalFlingEnabled);
            this.scrollDuration = a.getInt(R.styleable.WeekView_scrollDuration, this.scrollDuration);
        }
        finally {
            a.recycle();
        }
    }

    void setNumberOfVisibleDays(int numberOfVisibleDays) {
        this.numberOfVisibleDays = numberOfVisibleDays;
        this.drawingConfig.resetOrigin();
    }

    void setTimeColumnTextSize(int timeColumnTextSize) {
        this.timeColumnTextSize = timeColumnTextSize;
        this.drawingConfig.setTextSize(timeColumnTextSize);
    }

    void setTimeColumnTextColor(int textColor) {
        this.timeColumnTextColor = textColor;
        this.drawingConfig.setTimeColumnTextColor(textColor);
    }

    void setHeaderRowBackgroundColor(int headerRowBackgroundColor) {
        this.headerRowBackgroundColor = headerRowBackgroundColor;
        this.drawingConfig.headerBackgroundPaint.setColor(headerRowBackgroundColor);
    }

    void setDayBackgroundColor(int dayBackgroundColor) {
        this.dayBackgroundColor = dayBackgroundColor;
        this.drawingConfig.dayBackgroundPaint.setColor(dayBackgroundColor);
    }

    void setTodayBackgroundColor(int todayBackgroundColor) {
        this.todayBackgroundColor = todayBackgroundColor;
        this.drawingConfig.todayBackgroundPaint.setColor(todayBackgroundColor);
    }

    void setHourSeparatorStrokeWidth(int hourSeparatorWidth) {
        this.hourSeparatorStrokeWidth = hourSeparatorWidth;
        this.drawingConfig.hourSeparatorPaint.setStrokeWidth((float)hourSeparatorWidth);
    }

    void setTodayHeaderTextColor(int todayHeaderTextColor) {
        this.todayHeaderTextColor = todayHeaderTextColor;
        this.drawingConfig.todayHeaderTextPaint.setColor(todayHeaderTextColor);
    }

    void setEventTextSize(int eventTextSize) {
        this.eventTextSize = eventTextSize;
        this.drawingConfig.eventTextPaint.setTextSize((float)eventTextSize);
    }

    void setEventTextColor(int eventTextColor) {
        this.eventTextColor = eventTextColor;
        this.drawingConfig.eventTextPaint.setColor(eventTextColor);
    }

    void setTimeColumnBackgroundColor(int timeColumnBackgroundColor) {
        this.timeColumnBackgroundColor = timeColumnBackgroundColor;
        this.drawingConfig.timeColumnBackgroundPaint.setColor(timeColumnBackgroundColor);
    }

    float getTotalDayWidth() {
        return this.drawingConfig.widthPerDay + (float)this.columnGap;
    }

    float getTotalDayHeight() {
        float dayHeight = this.hourHeight * Constants.HOURS_PER_DAY;
        float headerHeight = this.drawingConfig.headerHeight;
        float totalHeaderPadding = this.headerRowPadding * 2;
        float headerBottomMargin = this.drawingConfig.headerMarginBottom;
        return dayHeight + headerHeight + totalHeaderPadding + headerBottomMargin;
    }

    boolean isSingleDay() {
        return this.numberOfVisibleDays == 1;
    }

    boolean isWeek() {
        return this.numberOfVisibleDays == 7;
    }
}

