/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.alamkanak.weekview.BackgroundGridDrawer;
import com.alamkanak.weekview.Constants;
import com.alamkanak.weekview.DateTimeInterpreter;
import com.alamkanak.weekview.DateUtils;
import com.alamkanak.weekview.DayBackgroundDrawer;
import com.alamkanak.weekview.DayLabelDrawer;
import com.alamkanak.weekview.DrawingContext;
import com.alamkanak.weekview.EmptyViewClickListener;
import com.alamkanak.weekview.EmptyViewLongPressListener;
import com.alamkanak.weekview.EventChipsProvider;
import com.alamkanak.weekview.EventClickListener;
import com.alamkanak.weekview.EventLongPressListener;
import com.alamkanak.weekview.EventsDrawer;
import com.alamkanak.weekview.HeaderRowDrawer;
import com.alamkanak.weekview.MonthLoader;
import com.alamkanak.weekview.NowLineDrawer;
import com.alamkanak.weekview.OnVerticalScrollListener;
import com.alamkanak.weekview.ScrollListener;
import com.alamkanak.weekview.TimeColumnDrawer;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewData;
import com.alamkanak.weekview.WeekViewDrawingConfig;
import com.alamkanak.weekview.WeekViewGestureHandler;
import com.alamkanak.weekview.WeekViewLoader;
import com.alamkanak.weekview.WeekViewViewState;
import java.util.Calendar;

public final class WeekView<T>
extends View
implements WeekViewGestureHandler.Listener,
WeekViewViewState.UpdateListener {
    private static int width;
    private static int height;
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawConfig;
    private WeekViewData<T> data;
    private WeekViewViewState viewState;
    private WeekViewGestureHandler<T> gestureHandler;
    private HeaderRowDrawer<T> headerRowDrawer;
    private DayLabelDrawer dayLabelDrawer;
    private EventsDrawer<T> eventsDrawer;
    private TimeColumnDrawer timeColumnDrawer;
    private DayBackgroundDrawer dayBackgroundDrawer;
    private BackgroundGridDrawer backgroundGridDrawer;
    private NowLineDrawer nowLineDrawer;
    private EventChipsProvider<T> eventChipsProvider;

    public WeekView(Context context) {
        this(context, null);
    }

    public WeekView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WeekView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.config = new WeekViewConfig(context, attrs);
        this.config.drawingConfig = this.drawConfig = new WeekViewDrawingConfig(context, this.config);
        this.data = new WeekViewData();
        this.viewState = new WeekViewViewState();
        this.gestureHandler = new WeekViewGestureHandler<T>(context, this, this.config, this.data);
        this.eventsDrawer = new EventsDrawer(this.config);
        this.timeColumnDrawer = new TimeColumnDrawer(this.config);
        this.headerRowDrawer = new HeaderRowDrawer<T>(this.config, this.data, this.viewState);
        this.dayLabelDrawer = new DayLabelDrawer(this.config);
        this.dayBackgroundDrawer = new DayBackgroundDrawer(this.config);
        this.backgroundGridDrawer = new BackgroundGridDrawer(this.config);
        this.nowLineDrawer = new NowLineDrawer(this.config);
        this.eventChipsProvider = new EventChipsProvider<T>(this.config, this.data, this.viewState);
        this.eventChipsProvider.setWeekViewLoader(this.getWeekViewLoader());
    }

    public static int getViewWidth() {
        return width;
    }

    public static int getViewHeight() {
        return height;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.config.numberOfVisibleDays);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.config.setNumberOfVisibleDays(savedState.numberOfVisibleDays);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.viewState.areDimensionsInvalid = true;
        WeekView.width = width;
        WeekView.height = height;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        boolean isFirstDraw = this.viewState.isFirstDraw;
        this.viewState.update(this.config, this);
        if (this.viewState.isFirstDraw) {
            this.viewState.isFirstDraw = false;
            this.config.drawingConfig.moveCurrentOriginIfFirstDraw(this.config);
        }
        this.config.drawingConfig.refreshAfterZooming(this.config);
        this.config.drawingConfig.updateVerticalOrigin(this.config);
        this.notifyScrollListeners();
        this.prepareEventDrawing(canvas);
        DrawingContext drawingContext = DrawingContext.create(this.config);
        this.eventChipsProvider.loadEventsIfNecessary(this, drawingContext.dayRange);
        this.dayBackgroundDrawer.draw(drawingContext, canvas);
        this.backgroundGridDrawer.draw(drawingContext, canvas);
        this.eventsDrawer.drawSingleEvents(this.data.getNormalEventChips(), drawingContext, canvas);
        this.nowLineDrawer.draw(drawingContext, canvas);
        this.headerRowDrawer.draw(canvas);
        this.dayLabelDrawer.draw(drawingContext, canvas);
        this.eventsDrawer.drawAllDayEvents(this.data.getAllDayEventChips(), drawingContext, canvas);
        this.timeColumnDrawer.drawTimeColumn(canvas);
        if (isFirstDraw) {
            this.invalidate();
        }
    }

    private void notifyScrollListeners() {
        boolean hasFirstVisibleDayChanged;
        Calendar oldFirstVisibleDay = this.viewState.firstVisibleDay;
        Calendar today = DateUtils.today();
        this.viewState.firstVisibleDay = (Calendar)today.clone();
        float totalDayWidth = this.config.getTotalDayWidth();
        int delta = (int)Math.ceil(this.drawConfig.currentOrigin.x / totalDayWidth) * -1;
        this.viewState.firstVisibleDay.add(5, delta);
        boolean bl = hasFirstVisibleDayChanged = !this.viewState.firstVisibleDay.equals(oldFirstVisibleDay);
        if (hasFirstVisibleDayChanged && this.getScrollListener() != null) {
            this.getScrollListener().onFirstVisibleDayChanged(this.viewState.firstVisibleDay, oldFirstVisibleDay);
        }
    }

    private void prepareEventDrawing(Canvas canvas) {
        this.data.clearEventChipsCache();
        canvas.save();
        this.clipEventsRect(canvas);
        this.calculateWidthPerDay();
    }

    private void calculateWidthPerDay() {
        this.drawConfig.widthPerDay = (float)this.getWidth() - this.drawConfig.timeColumnWidth - (float)(this.config.columnGap * (this.config.numberOfVisibleDays - 1));
        this.drawConfig.widthPerDay /= (float)this.config.numberOfVisibleDays;
    }

    private void clipEventsRect(Canvas canvas) {
        int width = WeekView.getViewWidth();
        int height = WeekView.getViewHeight();
        float headerHeight = this.drawConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawConfig.headerMarginBottom;
        canvas.clipRect(this.drawConfig.timeColumnWidth, headerHeight, (float)width, (float)height);
    }

    @Override
    public void onScaled() {
        this.invalidate();
    }

    @Override
    public void onScrolled() {
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public void invalidate() {
        super.invalidate();
        this.viewState.invalidate();
    }

    public void setVerticalScrollListener(OnVerticalScrollListener verticalScrollListener) {
        this.gestureHandler.setVerticalScrollListener(verticalScrollListener);
    }

    public int getFirstDayOfWeek() {
        return this.config.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.config.firstDayOfWeek = firstDayOfWeek;
        this.invalidate();
    }

    public int getNumberOfVisibleDays() {
        return this.config.numberOfVisibleDays;
    }

    public void setNumberOfVisibleDays(int numberOfVisibleDays) {
        this.config.setNumberOfVisibleDays(numberOfVisibleDays);
        this.invalidate();
    }

    public boolean isShowFirstDayOfWeekFirst() {
        return this.config.showFirstDayOfWeekFirst;
    }

    public void setShowFirstDayOfWeekFirst(boolean show) {
        this.config.showFirstDayOfWeekFirst = show;
    }

    public boolean getShowHeaderRowBottomLine() {
        return this.config.showHeaderRowBottomLine;
    }

    public void setShowHeaderRowBottomLine(boolean showHeaderRowBottomLine) {
        this.config.showHeaderRowBottomLine = showHeaderRowBottomLine;
        this.invalidate();
    }

    public int getHeaderRowBottomLineColor() {
        return this.config.headerRowBottomLineColor;
    }

    public void setHeaderRowBottomLineColor(int headerRowBottomLineColor) {
        this.config.headerRowBottomLineColor = headerRowBottomLineColor;
        this.invalidate();
    }

    public int getHeaderRowBottomLineWidth() {
        return this.config.headerRowBottomLineWidth;
    }

    public void setHeaderRowBottomLineWidth(int headerRowBottomLineWidth) {
        this.config.headerRowBottomLineWidth = headerRowBottomLineWidth;
        this.invalidate();
    }

    public int getTodayHeaderTextColor() {
        return this.config.todayHeaderTextColor;
    }

    public void setTodayHeaderTextColor(int todayHeaderTextColor) {
        this.config.setTodayHeaderTextColor(todayHeaderTextColor);
        this.invalidate();
    }

    public int getTimeColumnPadding() {
        return this.config.timeColumnPadding;
    }

    public void setTimeColumnPadding(int timeColumnPadding) {
        this.config.timeColumnPadding = timeColumnPadding;
        this.invalidate();
    }

    public int getTimeColumnTextColor() {
        return this.config.timeColumnTextColor;
    }

    public void setTimeColumnTextColor(int timeColumnTextColor) {
        this.config.setTimeColumnTextColor(timeColumnTextColor);
        this.invalidate();
    }

    public int getTimeColumnBackgroundColor() {
        return this.config.timeColumnBackgroundColor;
    }

    public void setTimeColumnBackgroundColor(int timeColumnBackgroundColor) {
        this.config.setTimeColumnBackgroundColor(timeColumnBackgroundColor);
        this.invalidate();
    }

    public int getTimeColumTextSize() {
        return this.config.timeColumnTextSize;
    }

    public void setTimeColumnTextSize(int textSize) {
        this.config.setTimeColumnTextSize(textSize);
        this.invalidate();
    }

    public boolean getShowTimeColumnSeparator() {
        return this.config.showTimeColumnSeparator;
    }

    public void setShowTimeColumnSeparator(boolean showTimeColumnSeparator) {
        this.config.showTimeColumnSeparator = showTimeColumnSeparator;
        this.invalidate();
    }

    public int getTimeColumnSeparatorColor() {
        return this.config.timeColumnSeparatorColor;
    }

    public void setTimeColumnSeparatorColor(int timeColumnSeparatorColor) {
        this.config.timeColumnSeparatorColor = timeColumnSeparatorColor;
        this.invalidate();
    }

    public int getTimeColumnSeparatorWidth() {
        return this.config.timeColumnSeparatorStrokeWidth;
    }

    public void setTimeColumnSeparatorWidth(int timeColumnSeparatorStrokeWidth) {
        this.config.timeColumnSeparatorStrokeWidth = timeColumnSeparatorStrokeWidth;
        this.invalidate();
    }

    public int getHeaderRowPadding() {
        return this.config.headerRowPadding;
    }

    public void setHeaderRowPadding(int headerRowPadding) {
        this.config.headerRowPadding = headerRowPadding;
        this.invalidate();
    }

    public int getHeaderRowBackgroundColor() {
        return this.config.headerRowBackgroundColor;
    }

    public void setHeaderRowBackgroundColor(int headerRowBackgroundColor) {
        this.config.setHeaderRowBackgroundColor(headerRowBackgroundColor);
        this.invalidate();
    }

    public int getHeaderRowTextColor() {
        return this.config.headerRowTextColor;
    }

    public void setHeaderRowTextColor(int headerRowTextColor) {
        this.config.headerRowTextColor = headerRowTextColor;
        this.invalidate();
    }

    public int getHeaderRowTextSize() {
        return this.config.headerRowTextSize;
    }

    public void setHeaderRowTextSize(int textSize) {
        this.config.headerRowTextSize = textSize;
        this.invalidate();
    }

    public int getAllDayEventHeight() {
        return this.config.allDayEventHeight;
    }

    public void setAllDayEventHeight(int height) {
        this.config.allDayEventHeight = height;
    }

    public int getEventCornerRadius() {
        return this.config.eventCornerRadius;
    }

    public void setEventCornerRadius(int eventCornerRadius) {
        this.config.eventCornerRadius = eventCornerRadius;
    }

    public int getEventTextSize() {
        return this.config.eventTextSize;
    }

    public void setEventTextSize(int eventTextSize) {
        this.config.setEventTextSize(eventTextSize);
        this.invalidate();
    }

    public int getEventTextColor() {
        return this.config.eventTextColor;
    }

    public void setEventTextColor(int eventTextColor) {
        this.config.setEventTextColor(eventTextColor);
        this.invalidate();
    }

    public int getEventPadding() {
        return this.config.eventPadding;
    }

    public void setEventPadding(int eventPadding) {
        this.config.eventPadding = eventPadding;
        this.invalidate();
    }

    public int getDefaultEventColor() {
        return this.config.defaultEventColor;
    }

    public void setDefaultEventColor(int defaultEventColor) {
        this.config.defaultEventColor = defaultEventColor;
        this.invalidate();
    }

    public int getColumnGap() {
        return this.config.columnGap;
    }

    public void setColumnGap(int columnGap) {
        this.config.columnGap = columnGap;
        this.invalidate();
    }

    public int getOverlappingEventGap() {
        return this.config.overlappingEventGap;
    }

    public void setOverlappingEventGap(int overlappingEventGap) {
        this.config.overlappingEventGap = overlappingEventGap;
        this.invalidate();
    }

    public int getEventMarginVertical() {
        return this.config.eventMarginVertical;
    }

    public void setEventMarginVertical(int eventMarginVertical) {
        this.config.eventMarginVertical = eventMarginVertical;
        this.invalidate();
    }

    public void setEventMarginHorizontal(int eventMarginHorizontal) {
        this.config.eventMarginHorizontal = eventMarginHorizontal;
        this.invalidate();
    }

    public int getEventMarginHorizontal() {
        return this.config.eventMarginHorizontal;
    }

    public int getDayBackgroundColor() {
        return this.config.dayBackgroundColor;
    }

    public void setDayBackgroundColor(int dayBackgroundColor) {
        this.config.setDayBackgroundColor(dayBackgroundColor);
        this.invalidate();
    }

    public int getTodayBackgroundColor() {
        return this.config.todayBackgroundColor;
    }

    public void setTodayBackgroundColor(int todayBackgroundColor) {
        this.config.setTodayBackgroundColor(todayBackgroundColor);
        this.invalidate();
    }

    public boolean isShowDistinctWeekendColor() {
        return this.config.showDistinctWeekendColor;
    }

    public void setShowDistinctWeekendColor(boolean showDistinctWeekendColor) {
        this.config.showDistinctWeekendColor = showDistinctWeekendColor;
        this.invalidate();
    }

    public boolean isShowDistinctPastFutureColor() {
        return this.config.showDistinctPastFutureColor;
    }

    public void setShowDistinctPastFutureColor(boolean showDistinctPastFutureColor) {
        this.config.showDistinctPastFutureColor = showDistinctPastFutureColor;
        this.invalidate();
    }

    public int getHourHeight() {
        return this.config.hourHeight;
    }

    public void setHourHeight(int hourHeight) {
        this.config.drawingConfig.newHourHeight = hourHeight;
        this.invalidate();
    }

    public boolean isShowNowLine() {
        return this.config.showNowLine;
    }

    public void setShowNowLine(boolean showNowLine) {
        this.config.showNowLine = showNowLine;
        this.invalidate();
    }

    public int getNowLineColor() {
        return this.config.nowLineColor;
    }

    public void setNowLineColor(int nowLineColor) {
        this.config.nowLineColor = nowLineColor;
        this.invalidate();
    }

    public int getNowLineStrokeWidth() {
        return this.config.nowLineStrokeWidth;
    }

    public void setNowLineStrokeWidth(int nowLineStrokeWidth) {
        this.config.nowLineStrokeWidth = nowLineStrokeWidth;
        this.invalidate();
    }

    public boolean isShowNowLineDot() {
        return this.config.showNowLineDot;
    }

    public void setShowNowLineDot(boolean showNowLineDot) {
        this.config.showNowLineDot = showNowLineDot;
        this.invalidate();
    }

    public int getNowLineDotColor() {
        return this.config.nowLineDotColor;
    }

    public void setNowLineDotColor(int nowLineDotColor) {
        this.config.nowLineDotColor = nowLineDotColor;
        this.invalidate();
    }

    public int getNowLineDotRadius() {
        return this.config.nowLineDotRadius;
    }

    public void setNowLineDotRadius(int nowLineDotRadius) {
        this.config.nowLineDotRadius = nowLineDotRadius;
        this.invalidate();
    }

    public boolean showHourSeparators() {
        return this.config.showHourSeparator;
    }

    public void setShowHourSeparators(boolean showHourSeparators) {
        this.config.showHourSeparator = showHourSeparators;
        this.invalidate();
    }

    public int getHourSeparatorColor() {
        return this.config.hourSeparatorColor;
    }

    public void setHourSeparatorColor(int hourSeparatorColor) {
        this.config.hourSeparatorColor = hourSeparatorColor;
        this.config.drawingConfig.hourSeparatorPaint.setColor(hourSeparatorColor);
        this.invalidate();
    }

    public int getHourSeparatorStrokeWidth() {
        return this.config.hourSeparatorStrokeWidth;
    }

    public void setHourSeparatorStrokeWidth(int hourSeparatorWidth) {
        this.config.setHourSeparatorStrokeWidth(hourSeparatorWidth);
        this.invalidate();
    }

    public boolean showDaySeparators() {
        return this.config.showDaySeparator;
    }

    public void setShowDaySeparators(boolean showDaySeparators) {
        this.config.showDaySeparator = showDaySeparators;
        this.invalidate();
    }

    public int getDaySeparatorColor() {
        return this.config.daySeparatorColor;
    }

    public void setDaySeparatorColor(int daySeparatorColor) {
        this.config.daySeparatorColor = daySeparatorColor;
        this.config.drawingConfig.daySeparatorPaint.setColor(daySeparatorColor);
        this.invalidate();
    }

    public int getDaySeparatorStrokeWidth() {
        return this.config.daySeparatorStrokeWidth;
    }

    public void setDaySeparatorStrokeWidth(int daySeparatorWidth) {
        this.config.daySeparatorStrokeWidth = daySeparatorWidth;
        this.invalidate();
    }

    public float getXScrollingSpeed() {
        return this.config.xScrollingSpeed;
    }

    public void setXScrollingSpeed(float xScrollingSpeed) {
        this.config.xScrollingSpeed = xScrollingSpeed;
    }

    public boolean isHorizontalFlingEnabled() {
        return this.config.horizontalFlingEnabled;
    }

    public void setHorizontalFlingEnabled(boolean enabled) {
        this.config.horizontalFlingEnabled = enabled;
    }

    public boolean isHorizontalScrollingEnabled() {
        return this.config.horizontalScrollingEnabled;
    }

    public void setHorizontalScrollingEnabled(boolean enabled) {
        this.config.horizontalScrollingEnabled = enabled;
    }

    public boolean isVerticalFlingEnabled() {
        return this.config.verticalFlingEnabled;
    }

    public void setVerticalFlingEnabled(boolean enabled) {
        this.config.verticalFlingEnabled = enabled;
    }

    public int getScrollDuration() {
        return this.config.scrollDuration;
    }

    public void setScrollDuration(int scrollDuration) {
        this.config.scrollDuration = scrollDuration;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        return this.gestureHandler.onTouchEvent(event);
    }

    public void computeScroll() {
        super.computeScroll();
        this.gestureHandler.computeScroll();
    }

    public Calendar getFirstVisibleDay() {
        return this.viewState.firstVisibleDay;
    }

    public Calendar getLastVisibleDay() {
        return this.viewState.lastVisibleDay;
    }

    public void goToToday() {
        this.goToDate(DateUtils.today());
    }

    public void goToCurrentTime() {
        Calendar today = Calendar.getInstance();
        int hour = today.get(11);
        this.goToDate(today);
        this.goToHour(hour);
    }

    @Override
    public void goToDate(Calendar date) {
        this.gestureHandler.forceScrollFinished();
        if (this.viewState.areDimensionsInvalid) {
            this.viewState.scrollToDay = date;
            return;
        }
        this.viewState.shouldRefreshEvents = true;
        int diff = DateUtils.getDaysUntilDate(date);
        this.config.drawingConfig.currentOrigin.x = (float)(diff * -1) * this.config.getTotalDayWidth();
        this.invalidate();
    }

    public void notifyDataSetChanged() {
        this.viewState.shouldRefreshEvents = true;
        this.invalidate();
    }

    @Override
    public void goToHour(int hour) {
        if (this.viewState.areDimensionsInvalid) {
            this.viewState.scrollToHour = hour;
            return;
        }
        hour = Math.min(hour, Constants.HOURS_PER_DAY);
        int verticalOffset = this.config.hourHeight * hour;
        float dayHeight = this.config.getTotalDayHeight();
        double viewHeight = this.getHeight();
        double desiredOffset = (double)dayHeight - viewHeight;
        verticalOffset = (int)Math.min(desiredOffset, (double)verticalOffset);
        this.config.drawingConfig.currentOrigin.y = -verticalOffset;
        this.invalidate();
    }

    public double getFirstVisibleHour() {
        return this.config.drawingConfig.currentOrigin.y * -1.0f / (float)this.config.hourHeight;
    }

    public void setOnEventClickListener(EventClickListener<T> listener) {
        this.gestureHandler.setEventClickListener(listener);
    }

    public EventClickListener getEventClickListener() {
        return this.gestureHandler.getEventClickListener();
    }

    @Nullable
    public MonthLoader.MonthChangeListener getMonthChangeListener() {
        if (this.gestureHandler.getWeekViewLoader() instanceof MonthLoader) {
            return ((MonthLoader)this.gestureHandler.getWeekViewLoader()).getOnMonthChangeListener();
        }
        return null;
    }

    public void setMonthChangeListener(@Nullable MonthLoader.MonthChangeListener<T> monthChangeListener) {
        MonthLoader<T> weekViewLoader = new MonthLoader<T>(monthChangeListener);
        this.gestureHandler.setWeekViewLoader(weekViewLoader);
        this.eventChipsProvider.setWeekViewLoader(weekViewLoader);
    }

    public WeekViewLoader<T> getWeekViewLoader() {
        return this.gestureHandler.getWeekViewLoader();
    }

    public void setWeekViewLoader(WeekViewLoader<T> weekViewLoader) {
        this.gestureHandler.setWeekViewLoader(weekViewLoader);
        this.eventChipsProvider.setWeekViewLoader(weekViewLoader);
    }

    public EventLongPressListener getEventLongPressListener() {
        return this.gestureHandler.getEventLongPressListener();
    }

    public void setEventLongPressListener(EventLongPressListener<T> eventLongPressListener) {
        this.gestureHandler.setEventLongPressListener(eventLongPressListener);
    }

    public void setEmptyViewClickListener(EmptyViewClickListener emptyViewClickListener) {
        this.gestureHandler.setEmptyViewClickListener(emptyViewClickListener);
    }

    public EmptyViewClickListener getEmptyViewClickListener() {
        return this.gestureHandler.getEmptyViewClickListener();
    }

    public void setEmptyViewLongPressListener(EmptyViewLongPressListener emptyViewLongPressListener) {
        this.gestureHandler.setEmptyViewLongPressListener(emptyViewLongPressListener);
    }

    public EmptyViewLongPressListener getEmptyViewLongPressListener() {
        return this.gestureHandler.getEmptyViewLongPressListener();
    }

    public void setScrollListener(ScrollListener scrollListener) {
        this.gestureHandler.setScrollListener(scrollListener);
    }

    public ScrollListener getScrollListener() {
        return this.gestureHandler.getScrollListener();
    }

    public DateTimeInterpreter getDateTimeInterpreter() {
        return this.config.drawingConfig.getDateTimeInterpreter(this.getContext());
    }

    public void setDateTimeInterpreter(DateTimeInterpreter dateTimeInterpreter) {
        this.config.drawingConfig.setDateTimeInterpreter(dateTimeInterpreter, this.getContext());
    }

    protected static class SavedState
    extends View.BaseSavedState {
        private final int numberOfVisibleDays;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int numberOfVisibleDays) {
            super(superState);
            this.numberOfVisibleDays = numberOfVisibleDays;
        }

        private SavedState(Parcel in) {
            super(in);
            this.numberOfVisibleDays = in.readInt();
        }

        public void writeToParcel(Parcel destination, int flags) {
            super.writeToParcel(destination, flags);
            destination.writeInt(this.numberOfVisibleDays);
        }
    }
}

