/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.alamkanak.weekview.EventChip;
import com.alamkanak.weekview.WeekView;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewData;
import com.alamkanak.weekview.WeekViewDrawingConfig;
import com.alamkanak.weekview.WeekViewEvent;
import com.alamkanak.weekview.WeekViewViewState;
import java.util.Calendar;
import java.util.List;

class HeaderRowDrawer<T> {
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawConfig;
    private WeekViewData<T> data;
    private WeekViewViewState viewState;

    HeaderRowDrawer(WeekViewConfig config, WeekViewData<T> data, WeekViewViewState viewState) {
        this.config = config;
        this.drawConfig = config.drawingConfig;
        this.data = data;
        this.viewState = viewState;
    }

    void draw(Canvas canvas) {
        this.calculateAvailableSpaceForHeader();
        this.drawHeaderRow(canvas);
    }

    private void calculateAvailableSpaceForHeader() {
        this.drawConfig.timeColumnWidth = this.drawConfig.timeTextWidth + (float)(this.config.timeColumnPadding * 2);
        this.drawConfig.headerHeight = this.calculateHeaderHeight();
    }

    private float calculateHeaderHeight() {
        List<EventChip<T>> eventChips = this.data.getAllDayEventChips();
        if (eventChips == null || eventChips.isEmpty()) {
            return this.drawConfig.headerTextHeight;
        }
        boolean containsAllDayEvent = false;
        for (int i = 0; i < this.config.numberOfVisibleDays; ++i) {
            Calendar day = (Calendar)this.viewState.firstVisibleDay.clone();
            day.add(5, i);
            for (int j = 0; j < eventChips.size(); ++j) {
                WeekViewEvent event = eventChips.get((int)j).event;
                if (!event.isSameDay(day) || !event.isAllDay()) continue;
                containsAllDayEvent = true;
                break;
            }
            if (containsAllDayEvent) break;
        }
        int headerRowBottomLine = 0;
        if (this.config.showHeaderRowBottomLine) {
            headerRowBottomLine = this.config.headerRowBottomLineWidth;
        }
        if (containsAllDayEvent) {
            float headerTextSize = this.drawConfig.eventTextPaint.getTextSize();
            float totalEventPadding = this.config.eventPadding * 2;
            float eventChipBottomPadding = this.config.timeColumnTextSize / 4;
            return this.drawConfig.headerTextHeight + (headerTextSize + totalEventPadding + eventChipBottomPadding + (float)headerRowBottomLine + this.drawConfig.headerMarginBottom);
        }
        return this.drawConfig.headerTextHeight + (float)headerRowBottomLine;
    }

    private void drawHeaderRow(Canvas canvas) {
        int width = WeekView.getViewWidth();
        canvas.restore();
        canvas.save();
        Paint headerBackground = this.drawConfig.headerBackgroundPaint;
        float headerHeight = this.drawConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + (float)this.config.headerRowBottomLineWidth;
        float topLeftCornerWidth = this.drawConfig.timeTextWidth + (float)(this.config.timeColumnPadding * 2);
        canvas.clipRect(0.0f, 0.0f, topLeftCornerWidth, headerHeight);
        canvas.drawRect(0.0f, 0.0f, topLeftCornerWidth, headerHeight, headerBackground);
        canvas.restore();
        canvas.save();
        canvas.clipRect(this.drawConfig.timeColumnWidth, 0.0f, (float)width, headerHeight);
        canvas.drawRect(0.0f, 0.0f, (float)width, headerHeight, headerBackground);
        canvas.restore();
        canvas.save();
        if (this.config.showHeaderRowBottomLine) {
            this.drawHeaderBottomLine(headerHeight, width, canvas);
        }
    }

    private void drawHeaderBottomLine(float headerHeight, int width, Canvas canvas) {
        int headerRowBottomLineWidth = this.config.headerRowBottomLineWidth;
        float topMargin = headerHeight - (float)headerRowBottomLineWidth;
        Paint paint = new Paint();
        paint.setStrokeWidth((float)headerRowBottomLineWidth);
        paint.setColor(this.config.headerRowBottomLineColor);
        canvas.drawLine(0.0f, topMargin, (float)width, topMargin, paint);
    }
}

