/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import com.alamkanak.weekview.DrawingContext;
import com.alamkanak.weekview.EventChip;
import com.alamkanak.weekview.EventChipRectCalculator;
import com.alamkanak.weekview.WeekView;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewDrawingConfig;
import com.alamkanak.weekview.WeekViewEvent;
import java.util.Calendar;
import java.util.List;

class EventsDrawer<T> {
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawingConfig;
    private EventChipRectCalculator rectCalculator;

    EventsDrawer(WeekViewConfig config) {
        this.config = config;
        this.drawingConfig = config.drawingConfig;
        this.rectCalculator = new EventChipRectCalculator(config);
    }

    void drawSingleEvents(List<EventChip<T>> eventChips, DrawingContext drawingContext, Canvas canvas) {
        float startPixel = drawingContext.startPixel;
        for (Calendar day : drawingContext.dayRange) {
            if (this.config.isSingleDay()) {
                startPixel += (float)this.config.eventMarginHorizontal;
            }
            this.drawEventsForDate(eventChips, day, startPixel, canvas);
            startPixel += this.config.getTotalDayWidth();
        }
    }

    private void drawEventsForDate(List<EventChip<T>> eventChips, Calendar date, float startFromPixel, Canvas canvas) {
        if (eventChips == null) {
            return;
        }
        for (int i = 0; i < eventChips.size(); ++i) {
            EventChip<T> eventChip = eventChips.get(i);
            WeekViewEvent event = eventChip.event;
            if (!event.isSameDay(date)) continue;
            RectF chipRect = this.rectCalculator.calculateSingleEvent(eventChip, startFromPixel);
            if (this.isValidSingleEventRect(chipRect)) {
                eventChip.rect = chipRect;
                eventChip.draw(this.config, canvas);
                continue;
            }
            eventChip.rect = null;
        }
    }

    void drawAllDayEvents(List<EventChip<T>> eventChips, DrawingContext drawingContext, Canvas canvas) {
        if (eventChips == null) {
            return;
        }
        float startPixel = drawingContext.startPixel;
        for (Calendar day : drawingContext.dayRange) {
            if (this.config.isSingleDay()) {
                startPixel += (float)this.config.eventMarginHorizontal;
            }
            for (EventChip<T> eventChip : eventChips) {
                WeekViewEvent event = eventChip.event;
                if (!event.isSameDay(day)) continue;
                this.drawAllDayEvent(eventChip, startPixel, canvas);
            }
            startPixel += this.config.getTotalDayWidth();
        }
        Paint headerBackground = this.drawingConfig.headerBackgroundPaint;
        float headerRowBottomLine = 0.0f;
        if (this.config.showHeaderRowBottomLine) {
            headerRowBottomLine = this.config.headerRowBottomLineWidth;
        }
        float height = this.drawingConfig.headerHeight + (float)(this.config.headerRowPadding * 2) - headerRowBottomLine;
        float width = this.drawingConfig.timeTextWidth + (float)(this.config.timeColumnPadding * 2);
        canvas.clipRect(0.0f, 0.0f, width, height);
        canvas.drawRect(0.0f, 0.0f, width, height, headerBackground);
        canvas.restore();
        canvas.save();
    }

    private void drawAllDayEvent(EventChip eventChip, float startFromPixel, Canvas canvas) {
        RectF chipRect = this.rectCalculator.calculateAllDayEvent(eventChip, startFromPixel);
        if (this.isValidAllDayEventRect(chipRect)) {
            eventChip.rect = chipRect;
            StaticLayout textLayout = this.calculateChipTextLayout(eventChip);
            if (textLayout != null) {
                eventChip.draw(this.config, textLayout, canvas);
            }
        } else {
            eventChip.rect = null;
        }
    }

    private boolean isValidSingleEventRect(RectF rect) {
        float totalHeaderHeight = this.drawingConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawingConfig.headerMarginBottom;
        return rect.left < rect.right && rect.left < (float)WeekView.getViewWidth() && rect.top < (float)WeekView.getViewHeight() && rect.right > this.drawingConfig.timeColumnWidth && rect.bottom > totalHeaderHeight;
    }

    private boolean isValidAllDayEventRect(RectF rect) {
        return rect.left < rect.right && rect.left < (float)WeekView.getViewWidth() && rect.top < (float)WeekView.getViewHeight() && rect.right > this.drawingConfig.timeColumnWidth && rect.bottom > 0.0f;
    }

    @Nullable
    private StaticLayout calculateChipTextLayout(EventChip eventChip) {
        int availableWidth;
        TextPaint textPaint;
        StaticLayout textLayout;
        int lineHeight;
        int availableHeight;
        boolean negativeHeight;
        WeekViewEvent event = eventChip.event;
        float left = eventChip.rect.left;
        float top = eventChip.rect.top;
        float right = eventChip.rect.right;
        float bottom = eventChip.rect.bottom;
        boolean negativeWidth = right - left - (float)(this.config.eventPadding * 2) < 0.0f;
        boolean bl = negativeHeight = bottom - top - (float)(this.config.eventPadding * 2) < 0.0f;
        if (negativeWidth || negativeHeight) {
            return null;
        }
        SpannableStringBuilder stringBuilder = new SpannableStringBuilder();
        if (event.getTitle() != null) {
            stringBuilder.append((CharSequence)event.getTitle());
            stringBuilder.setSpan((Object)new StyleSpan(1), 0, stringBuilder.length(), 0);
        }
        if (event.getLocation() != null) {
            stringBuilder.append(' ');
            stringBuilder.append((CharSequence)event.getLocation());
        }
        if ((availableHeight = (int)(bottom - top - (float)(this.config.eventPadding * 2))) >= (lineHeight = (textLayout = new StaticLayout((CharSequence)stringBuilder, textPaint = this.drawingConfig.eventTextPaint, availableWidth = (int)(right - left - (float)(this.config.eventPadding * 2)), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false)).getHeight() / textLayout.getLineCount())) {
            int availableLineCount = availableHeight / lineHeight;
            do {
                int availableArea = availableLineCount * availableWidth;
                CharSequence ellipsized = TextUtils.ellipsize((CharSequence)stringBuilder, (TextPaint)textPaint, (float)availableArea, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
                int width = (int)(right - left - (float)(this.config.eventPadding * 2));
                textLayout = new StaticLayout(ellipsized, textPaint, width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
                --availableLineCount;
            } while (textLayout.getHeight() > availableHeight);
        }
        int chipHeight = lineHeight + this.config.eventPadding * 2;
        eventChip.rect.bottom = eventChip.rect.top + (float)chipHeight;
        return textLayout;
    }
}

