/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import com.alamkanak.weekview.DateUtils;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewDrawingConfig;
import java.util.Calendar;
import java.util.List;

class DrawingContext {
    final List<Calendar> dayRange;
    final float startPixel;

    private DrawingContext(List<Calendar> dayRange, float startPixel) {
        this.dayRange = dayRange;
        this.startPixel = startPixel;
    }

    static DrawingContext create(WeekViewConfig config) {
        WeekViewDrawingConfig drawConfig = config.drawingConfig;
        float totalDayWidth = config.getTotalDayWidth();
        int leftDaysWithGaps = (int)(Math.ceil(drawConfig.currentOrigin.x / totalDayWidth) * -1.0);
        float startPixel = drawConfig.currentOrigin.x + totalDayWidth * (float)leftDaysWithGaps + drawConfig.timeColumnWidth;
        int start = leftDaysWithGaps + 1;
        int end = start + config.numberOfVisibleDays + 1;
        List<Calendar> dayRange = DateUtils.getDateRange(start, end);
        return new DrawingContext(dayRange, startPixel);
    }
}

