/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.alamkanak.weekview.DateUtils;
import com.alamkanak.weekview.DrawingContext;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewDrawingConfig;
import java.util.Calendar;

class DayLabelDrawer {
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawingConfig;

    DayLabelDrawer(WeekViewConfig config) {
        this.config = config;
        this.drawingConfig = config.drawingConfig;
    }

    void draw(DrawingContext drawingContext, Canvas canvas) {
        float startPixel = drawingContext.startPixel;
        for (Calendar day : drawingContext.dayRange) {
            this.drawLabel(day, startPixel, canvas);
            if (this.config.isSingleDay()) {
                startPixel += (float)this.config.eventMarginHorizontal;
            }
            startPixel += this.config.getTotalDayWidth();
        }
    }

    private void drawLabel(Calendar day, float startPixel, Canvas canvas) {
        Calendar today = DateUtils.today();
        boolean isSameDay = DateUtils.isSameDay(day, today);
        String dayLabel = this.drawingConfig.dateTimeInterpreter.interpretDate(day);
        if (dayLabel == null) {
            throw new IllegalStateException("A DateTimeInterpreter must not return null date");
        }
        float x = startPixel + this.drawingConfig.widthPerDay / 2.0f;
        float y = this.drawingConfig.headerTextHeight + (float)this.config.headerRowPadding;
        Paint textPaint = isSameDay ? this.drawingConfig.todayHeaderTextPaint : this.drawingConfig.headerTextPaint;
        canvas.drawText(dayLabel, x, y, textPaint);
    }
}

