/*
 * Decompiled with CFR 0.152.
 */
package com.alamkanak.weekview;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.alamkanak.weekview.DateUtils;
import com.alamkanak.weekview.DrawingContext;
import com.alamkanak.weekview.WeekView;
import com.alamkanak.weekview.WeekViewConfig;
import com.alamkanak.weekview.WeekViewDrawingConfig;
import java.util.Calendar;

class DayBackgroundDrawer {
    private WeekViewConfig config;
    private WeekViewDrawingConfig drawConfig;

    DayBackgroundDrawer(WeekViewConfig config) {
        this.config = config;
        this.drawConfig = config.drawingConfig;
    }

    void draw(DrawingContext drawingContext, Canvas canvas) {
        float startPixel = drawingContext.startPixel;
        for (Calendar day : drawingContext.dayRange) {
            float startX = Math.max(startPixel, this.drawConfig.timeColumnWidth);
            this.drawDayBackground(day, startX, startPixel, canvas);
            if (this.config.isSingleDay()) {
                startPixel += (float)this.config.eventMarginHorizontal;
            }
            startPixel += this.config.getTotalDayWidth();
        }
    }

    private void drawDayBackground(Calendar day, float startX, float startPixel, Canvas canvas) {
        Calendar today = DateUtils.today();
        boolean isToday = DateUtils.isSameDay(day, today);
        if (this.drawConfig.widthPerDay + startPixel - startX <= 0.0f) {
            return;
        }
        float headerHeight = this.drawConfig.headerHeight + (float)(this.config.headerRowPadding * 2) + this.drawConfig.headerMarginBottom;
        int height = WeekView.getViewHeight();
        if (this.config.showDistinctPastFutureColor) {
            boolean isWeekend = day.get(7) == 7 || day.get(7) == 1;
            boolean useWeekendColor = isWeekend && this.config.showDistinctWeekendColor;
            Paint pastPaint = this.drawConfig.getPastBackgroundPaint(useWeekendColor);
            Paint futurePaint = this.drawConfig.getFutureBackgroundPaint(useWeekendColor);
            float startY = headerHeight + this.drawConfig.currentOrigin.y;
            float endX = startPixel + this.drawConfig.widthPerDay;
            if (isToday) {
                Calendar now = Calendar.getInstance();
                float beforeNow = ((float)now.get(11) + (float)now.get(12) / 60.0f) * (float)this.config.hourHeight;
                canvas.drawRect(startX, startY, endX, startY + beforeNow, pastPaint);
                canvas.drawRect(startX, startY + beforeNow, endX, (float)height, futurePaint);
            } else if (day.before(today)) {
                canvas.drawRect(startX, startY, endX, (float)height, pastPaint);
            } else {
                canvas.drawRect(startX, startY, endX, (float)height, futurePaint);
            }
        } else {
            Paint todayPaint = this.drawConfig.getTodayBackgroundPaint(isToday);
            float right = startPixel + this.drawConfig.widthPerDay;
            canvas.drawRect(startX, headerHeight, right, (float)height, todayPaint);
        }
    }
}

