/*
 * Decompiled with CFR 0.152.
 */
package com.artemkopan.widget.vector;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.TextViewCompat;
import android.util.AttributeSet;
import android.widget.TextView;
import com.artemkopan.widget.R;

public final class VectorCompatViewHelper {
    private static final int NO_VALUE = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromAttributes(TextView textView, AttributeSet attrs) {
        if (textView == null || attrs == null) {
            return;
        }
        Context context = textView.getContext();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.VectorCompatTextView);
        try {
            int drawableBottomId;
            int drawableEndId;
            int drawableTopId;
            Drawable drawableStart = null;
            Drawable drawableEnd = null;
            Drawable drawableTop = null;
            Drawable drawableBottom = null;
            int width = -1;
            int height = -1;
            int drawableStartId = ta.getResourceId(R.styleable.VectorCompatTextView_drawableStartCompat, -1);
            if (drawableStartId != -1) {
                drawableStart = ContextCompat.getDrawable((Context)context, (int)drawableStartId);
            }
            if ((drawableTopId = ta.getResourceId(R.styleable.VectorCompatTextView_drawableTopCompat, -1)) != -1) {
                drawableTop = ContextCompat.getDrawable((Context)context, (int)drawableTopId);
            }
            if ((drawableEndId = ta.getResourceId(R.styleable.VectorCompatTextView_drawableEndCompat, -1)) != -1) {
                drawableEnd = ContextCompat.getDrawable((Context)context, (int)drawableEndId);
            }
            if ((drawableBottomId = ta.getResourceId(R.styleable.VectorCompatTextView_drawableBottomCompat, -1)) != -1) {
                drawableBottom = ContextCompat.getDrawable((Context)context, (int)drawableBottomId);
            }
            if (drawableStart != null || drawableEnd != null || drawableTop != null || drawableBottom != null) {
                width = ta.getDimensionPixelSize(R.styleable.VectorCompatTextView_drawableWidth, width);
                height = ta.getDimensionPixelSize(R.styleable.VectorCompatTextView_drawableHeight, height);
                if (width != -1 && height != -1) {
                    VectorCompatViewHelper.setDrawableSize(drawableStart, width, height);
                    VectorCompatViewHelper.setDrawableSize(drawableEnd, width, height);
                    VectorCompatViewHelper.setDrawableSize(drawableTop, width, height);
                    VectorCompatViewHelper.setDrawableSize(drawableBottom, width, height);
                    TextViewCompat.setCompoundDrawablesRelative((TextView)textView, (Drawable)drawableStart, (Drawable)drawableTop, (Drawable)drawableEnd, (Drawable)drawableBottom);
                } else {
                    TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)textView, (Drawable)drawableStart, (Drawable)drawableTop, (Drawable)drawableEnd, (Drawable)drawableBottom);
                }
            }
        }
        finally {
            ta.recycle();
        }
    }

    private static void setDrawableSize(Drawable drawable, int width, int height) {
        if (drawable == null) {
            return;
        }
        Rect rect = drawable.getBounds();
        drawable.setBounds(rect.left, rect.top, width, height);
    }
}

