/*
 * Decompiled with CFR 0.152.
 */
package com.luseen.logger;

import android.util.Log;
import com.luseen.logger.LogType;

public class Logger {
    private static LogType logType = LogType.INFO;
    private static boolean isLoggable = true;
    private static String TAG = "Logger";

    private Logger() {
        throw new RuntimeException("Private constructor cannot be accessed");
    }

    private static void init(Builder builder) {
        logType = builder.getLogType();
        TAG = builder.getTag();
        isLoggable = builder.isIsLoggable();
    }

    public static void e(Object message) {
        if (isLoggable) {
            Log.e((String)TAG, (String)("| " + Logger.makeLog(message, "e")));
        }
    }

    public static void e(Object message, Throwable throwable) {
        if (isLoggable) {
            Log.e((String)TAG, (String)("| " + Logger.makeLog(message, "e")), (Throwable)throwable);
        }
    }

    public static void i(Object message) {
        if (isLoggable) {
            Log.i((String)TAG, (String)("| " + Logger.makeLog(message, "i")));
        }
    }

    public static void w(Object message) {
        if (isLoggable) {
            Log.w((String)TAG, (String)("| " + Logger.makeLog(message, "w")));
        }
    }

    public static void d(Object message) {
        if (isLoggable) {
            Log.d((String)TAG, (String)("| " + Logger.makeLog(message, "d")));
        }
    }

    public static void log(Object message) {
        if (isLoggable) {
            String body = "| " + Logger.makeLog(message, "log");
            switch (logType) {
                case INFO: {
                    Log.i((String)TAG, (String)body);
                    break;
                }
                case DEBUG: {
                    Log.d((String)TAG, (String)body);
                    break;
                }
                case ERROR: {
                    Log.e((String)TAG, (String)body);
                    break;
                }
                case WARN: {
                    Log.w((String)TAG, (String)body);
                }
            }
        }
    }

    private static String makeLog(Object message, String calledMethodName) {
        StackTraceElement[] stackTraceElement = Thread.currentThread().getStackTrace();
        int currentIndex = -1;
        for (int i = 0; i < stackTraceElement.length; ++i) {
            if (stackTraceElement[i].getMethodName().compareTo(calledMethodName) != 0) continue;
            currentIndex = ++i;
            break;
        }
        StackTraceElement traceElement = Thread.currentThread().getStackTrace()[currentIndex];
        String fullClassName = traceElement.getClassName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String methodName = traceElement.getMethodName();
        int lineNumber = traceElement.getLineNumber();
        String logMessage = message == null ? null : message.toString();
        return logMessage + " | (" + className + ".java:" + lineNumber + ")";
    }

    public static class Builder {
        private static LogType logType = LogType.INFO;
        private static boolean isLoggable = true;
        private static String tag = "Logger";

        public Builder logType(LogType logType) {
            Builder.logType = logType;
            return this;
        }

        public Builder isLoggable(boolean isLoggable) {
            Builder.isLoggable = isLoggable;
            return this;
        }

        public Builder tag(String tag) {
            Builder.tag = tag;
            return this;
        }

        public void build() {
            Logger.init(this);
        }

        LogType getLogType() {
            return logType;
        }

        boolean isIsLoggable() {
            return isLoggable;
        }

        String getTag() {
            return tag;
        }
    }
}

