/*
 * Decompiled with CFR 0.152.
 */
package com.arlib.floatingsearchview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.support.v7.graphics.drawable.DrawerArrowDrawable;
import android.support.v7.view.menu.MenuBuilder;
import android.support.v7.widget.CardView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.arlib.floatingsearchview.R;
import com.arlib.floatingsearchview.suggestions.SearchSuggestionsAdapter;
import com.arlib.floatingsearchview.suggestions.model.SearchSuggestion;
import com.arlib.floatingsearchview.util.Util;
import com.arlib.floatingsearchview.util.adapter.GestureDetectorListenerAdapter;
import com.arlib.floatingsearchview.util.adapter.OnItemTouchListenerAdapter;
import com.arlib.floatingsearchview.util.adapter.TextWatcherAdapter;
import com.arlib.floatingsearchview.util.view.MenuView;
import com.bartoszlipinski.viewpropertyobjectanimator.ViewPropertyObjectAnimator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FloatingSearchView
extends FrameLayout {
    private static final String TAG = "FloatingSearchView";
    private final int BACKGROUND_DRAWABLE_ALPHA_SEARCH_ACTIVE = 150;
    private final int BACKGROUND_DRAWABLE_ALPHA_SEARCH_INACTIVE = 0;
    private final int MENU_ICON_ANIM_DURATION = 250;
    private final int BACKGROUND_FADE__ANIM_DURATION = 250;
    private final int ATTRS_SEARCH_BAR_MARGIN_DEFAULT = 0;
    public final int SEARCH_BAR_LEFT_SECTION_DESIRED_WIDTH;
    public static final int LEFT_ACTION_MODE_SHOW_HAMBURGER_ENUM_VAL = 1;
    public static final int LEFT_ACTION_MODE_SHOW_SEARCH_ENUM_VAL = 2;
    public static final int LEFT_ACTION_MODE_SHOW_HOME_ENUM_VAL = 3;
    public static final int LEFT_ACTION_MODE_NO_LEFT_ACTION_ENUM_VAL = 4;
    private final int ATTRS_SEARCH_BAR_LEFT_ACTION_MODE_DEFAULT = 4;
    private final boolean ATTRS_DISMISS_ON_OUTSIDE_TOUCH_DEFAULT = false;
    private final boolean ATTRS_SEARCH_BAR_SHOW_SEARCH_KEY_DEFAULT = true;
    private final boolean ATTRS_SEARCH_BAR_SHOW_SEARCH_HINT_NOT_FOCUSED_DEFAULT = true;
    private final int ATTRS_SUGGESTION_TEXT_SIZE_SP_DEFAULT = 18;
    private final int SUGGEST_LIST_COLLAPSE_ANIM_DURATION = 200;
    private final Interpolator SUGGEST_LIST_COLLAPSE_ANIM_INTERPOLATOR = new LinearInterpolator();
    private final int SUGGEST_ITEM_ADD_ANIM_DURATION = 250;
    private final Interpolator SUGGEST_ITEM_ADD_ANIM_INTERPOLATOR = new LinearInterpolator();
    private final int SUGGESTION_ITEM_ANIM_DURATION = 120;
    private Activity mHostActivity;
    private Drawable mBackgroundDrawable;
    private boolean mDismissOnOutsideTouch = true;
    private CardView mQuerySection;
    private OnSearchListener mSearchListener;
    private boolean mIsFocused;
    private OnFocusChangeListener mFocusChangeListener;
    private TextView mSearchBarTitle;
    private EditText mSearchInput;
    private int mSearchInputTextColor = -1;
    private int mSearchInputHintColor = -1;
    private View mSearchInputParent;
    private String mOldQuery = "";
    private OnQueryChangeListener mQueryListener;
    private ImageView mLeftAction;
    private OnLeftMenuClickListener mOnMenuClickListener;
    private OnHomeActionClickListener mOnHomeActionClickListener;
    private ProgressBar mSearchProgress;
    private DrawerArrowDrawable mMenuBtnDrawable;
    private Drawable mIconBackArrow;
    private Drawable mIconSearch;
    int mLeftActionMode;
    private boolean mShowHintNotFocused;
    private String mSearchHint;
    private boolean mShowSearchKey;
    private boolean mMenuOpen = false;
    private MenuView mMenuView;
    private int mActionMenuItemColor;
    private int mOverflowIconColor;
    private OnMenuItemClickListener mActionMenuItemListener;
    private ImageView mClearButton;
    private Drawable mIconClear;
    private boolean mSkipQueryFocusChangeEvent;
    private boolean mSkipTextChangeEvent;
    private View mDivider;
    private RelativeLayout mSuggestionsSection;
    private View mSuggestionListContainer;
    private RecyclerView mSuggestionsList;
    private int mSuggestionTextColor = -1;
    private int mSuggestionRightIconColor;
    private SearchSuggestionsAdapter mSuggestionsAdapter;
    private SearchSuggestionsAdapter.OnBindSuggestionCallback mOnBindSuggestionCallback;
    private boolean mIsCollapsing = false;
    private int mSuggestionsTextSizePx;
    private boolean mIsInitialLayout = true;
    private boolean mIsSuggestionsSecHeightSet;
    private OnSuggestionSecHeightSetListener mSuggestionSecHeightListener;

    public FloatingSearchView(Context context) {
        this(context, null);
    }

    public FloatingSearchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.SEARCH_BAR_LEFT_SECTION_DESIRED_WIDTH = Util.dpToPx(225);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.mHostActivity = this.getHostActivity();
        LayoutInflater layoutInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        FloatingSearchView.inflate((Context)this.getContext(), (int)R.layout.floating_search_layout, (ViewGroup)this);
        this.mBackgroundDrawable = new ColorDrawable(-16777216);
        this.mQuerySection = (CardView)this.findViewById(R.id.search_query_section);
        this.mClearButton = (ImageView)this.findViewById(R.id.clear_btn);
        this.mSearchInput = (EditText)this.findViewById(R.id.search_bar_text);
        this.mSearchInputParent = this.findViewById(R.id.search_input_parent);
        this.mSearchBarTitle = (TextView)this.findViewById(R.id.search_bar_title);
        this.mLeftAction = (ImageView)this.findViewById(R.id.left_action);
        this.mSearchProgress = (ProgressBar)this.findViewById(R.id.search_bar_search_progress);
        this.initDrawables();
        this.mClearButton.setImageDrawable(this.mIconClear);
        this.mMenuView = (MenuView)this.findViewById(R.id.menu_view);
        this.mDivider = this.findViewById(R.id.divider);
        this.mSuggestionsSection = (RelativeLayout)this.findViewById(R.id.search_suggestions_section);
        this.mSuggestionListContainer = this.findViewById(R.id.suggestions_list_container);
        this.mSuggestionsList = (RecyclerView)this.findViewById(R.id.suggestions_list);
        this.setupViews(attrs);
    }

    private void initDrawables() {
        this.mMenuBtnDrawable = new DrawerArrowDrawable(this.getContext());
        this.mIconClear = this.getResources().getDrawable(R.drawable.ic_clear_black_24dp);
        this.mIconClear = DrawableCompat.wrap((Drawable)this.mIconClear);
        this.mIconBackArrow = this.getResources().getDrawable(R.drawable.ic_arrow_back_black_24dp);
        this.mIconBackArrow = DrawableCompat.wrap((Drawable)this.mIconBackArrow);
        this.mIconSearch = this.getResources().getDrawable(R.drawable.ic_search_black_24dp);
        this.mIconSearch = DrawableCompat.wrap((Drawable)this.mIconSearch);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mIsInitialLayout) {
            int finalHeight;
            int addedHeight = Util.dpToPx(15);
            this.mSuggestionsSection.getLayoutParams().height = finalHeight = this.mSuggestionsSection.getMeasuredHeight() + addedHeight;
            this.mSuggestionsSection.requestLayout();
            ViewTreeObserver vto = this.mSuggestionListContainer.getViewTreeObserver();
            vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (FloatingSearchView.this.mSuggestionsSection.getHeight() == finalHeight) {
                        if (Build.VERSION.SDK_INT < 16) {
                            FloatingSearchView.this.mSuggestionListContainer.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            FloatingSearchView.this.mSuggestionListContainer.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        }
                        if (FloatingSearchView.this.mSuggestionSecHeightListener != null) {
                            FloatingSearchView.this.mSuggestionSecHeightListener.onSuggestionSecHeightSet();
                        }
                        FloatingSearchView.this.mIsSuggestionsSecHeightSet = true;
                    }
                }
            });
            this.mIsInitialLayout = false;
        }
        super.onLayout(changed, l, t, r, b);
    }

    private void setupViews(AttributeSet attrs) {
        if (attrs != null) {
            this.applyXmlAttributes(attrs);
        }
        this.mBackgroundDrawable.setAlpha(0);
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion < 16) {
            this.setBackgroundDrawable(this.mBackgroundDrawable);
        } else {
            this.setBackground(this.mBackgroundDrawable);
        }
        this.setupQueryBar();
        if (!this.isInEditMode()) {
            this.setupSuggestionSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyXmlAttributes(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.FloatingSearchView);
        try {
            int searchBarWidth;
            this.setDismissOnOutsideClick(true);
            this.mQuerySection.getLayoutParams().width = searchBarWidth = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarWidth, -1);
            this.mDivider.getLayoutParams().width = searchBarWidth;
            this.mSuggestionListContainer.getLayoutParams().width = searchBarWidth;
            int searchBarLeftMargin = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarMarginLeft, 0);
            int searchBarTopMargin = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarMarginTop, 0);
            int searchBarRightMargin = a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchBarMarginRight, 0);
            FrameLayout.LayoutParams querySectionLP = (FrameLayout.LayoutParams)this.mQuerySection.getLayoutParams();
            FrameLayout.LayoutParams dividerLP = (FrameLayout.LayoutParams)this.mDivider.getLayoutParams();
            LinearLayout.LayoutParams suggestListSectionLP = (LinearLayout.LayoutParams)this.mSuggestionsSection.getLayoutParams();
            int cardPadding = Util.dpToPx(3);
            querySectionLP.setMargins(searchBarLeftMargin, searchBarTopMargin, searchBarRightMargin, 0);
            dividerLP.setMargins(searchBarLeftMargin + cardPadding, 0, searchBarRightMargin + cardPadding, ((ViewGroup.MarginLayoutParams)this.mDivider.getLayoutParams()).bottomMargin);
            suggestListSectionLP.setMargins(searchBarLeftMargin, 0, searchBarRightMargin, 0);
            this.mQuerySection.setLayoutParams((ViewGroup.LayoutParams)querySectionLP);
            this.mDivider.setLayoutParams((ViewGroup.LayoutParams)dividerLP);
            this.mSuggestionsSection.setLayoutParams((ViewGroup.LayoutParams)suggestListSectionLP);
            this.setSearchHint(a.getString(R.styleable.FloatingSearchView_floatingSearch_searchHint));
            this.setShowHintWhenNotFocused(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_showSearchHintWhenNotFocused, true));
            this.setShowSearchKey(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_showSearchKey, true));
            this.setDismissOnOutsideClick(a.getBoolean(R.styleable.FloatingSearchView_floatingSearch_dismissOnOutsideTouch, false));
            this.setSuggestionItemTextSize(a.getDimensionPixelSize(R.styleable.FloatingSearchView_floatingSearch_searchSuggestionTextSize, Util.spToPx(18)));
            this.setLeftActionMode(a.getInt(R.styleable.FloatingSearchView_floatingSearch_leftActionMode, 4));
            if (a.hasValue(R.styleable.FloatingSearchView_floatingSearch_menu)) {
                this.mMenuView.resetMenuResource(a.getResourceId(R.styleable.FloatingSearchView_floatingSearch_menu, 0));
            }
            this.setBackgroundColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_backgroundColor, this.getResources().getColor(R.color.background)));
            this.setLeftActionIconColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_leftActionColor, this.getResources().getColor(R.color.left_action_icon)));
            this.setActionMenuOverflowColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_actionMenuOverflowColor, this.getResources().getColor(R.color.overflow_icon_color)));
            this.setMenuItemIconColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_menuItemIconColor, this.getResources().getColor(R.color.menu_icon_color)));
            this.setDividerColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_dividerColor, this.getResources().getColor(R.color.divider)));
            this.setClearBtnColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_clearBtnColor, this.getResources().getColor(R.color.clear_btn_color)));
            this.setViewTextColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_viewTextColor, this.getResources().getColor(R.color.dark_gray)));
            this.setHintTextColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_hintTextColor, this.getResources().getColor(R.color.hint_color)));
            this.setSuggestionRightIconColor(a.getColor(R.styleable.FloatingSearchView_floatingSearch_suggestionRightIconColor, this.getResources().getColor(R.color.gray_active_icon)));
        }
        finally {
            a.recycle();
        }
    }

    private Activity getHostActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    private void setupQueryBar() {
        this.mSearchInput.setTextColor(this.mSearchInputTextColor);
        this.mSearchInput.setHintTextColor(this.mSearchInputHintColor);
        this.mSearchBarTitle.setTextColor(this.mSearchInputTextColor);
        if (!this.isInEditMode() && this.mHostActivity != null) {
            this.mHostActivity.getWindow().setSoftInputMode(32);
        }
        if (this.isInEditMode()) {
            this.mMenuView.reset(this.actionMenuAvailWidth());
        }
        ViewTreeObserver vto = this.mQuerySection.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (Build.VERSION.SDK_INT < 16) {
                    FloatingSearchView.this.mQuerySection.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    FloatingSearchView.this.mQuerySection.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                FloatingSearchView.this.mMenuView.reset(FloatingSearchView.this.actionMenuAvailWidth());
                if (FloatingSearchView.this.mIsFocused) {
                    FloatingSearchView.this.mMenuView.hideIfRoomItems(false);
                }
            }
        });
        this.mMenuView.setMenuCallback(new MenuBuilder.Callback(){

            public boolean onMenuItemSelected(MenuBuilder menu, MenuItem item) {
                if (FloatingSearchView.this.mActionMenuItemListener != null) {
                    FloatingSearchView.this.mActionMenuItemListener.onActionMenuItemSelected(item);
                }
                return false;
            }

            public void onMenuModeChange(MenuBuilder menu) {
            }
        });
        this.mMenuView.setOnVisibleWidthChanged(new MenuView.OnVisibleWidthChanged(){

            @Override
            public void onVisibleWidthChanged(int newVisibleWidth) {
                if (newVisibleWidth == 0) {
                    FloatingSearchView.this.mClearButton.setTranslationX((float)(-Util.dpToPx(4)));
                    FloatingSearchView.this.mSearchInput.setPadding(0, 0, newVisibleWidth + Util.dpToPx(48) + Util.dpToPx(4), 0);
                } else {
                    FloatingSearchView.this.mClearButton.setTranslationX((float)(-newVisibleWidth));
                    FloatingSearchView.this.mSearchInput.setPadding(0, 0, newVisibleWidth + Util.dpToPx(48), 0);
                }
            }
        });
        this.mMenuView.setActionIconColor(this.mActionMenuItemColor);
        this.mMenuView.setOverflowColor(this.mOverflowIconColor);
        this.mClearButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FloatingSearchView.this.mSearchInput.setText((CharSequence)"");
            }
        });
        this.mSearchBarTitle.setVisibility(8);
        this.mClearButton.setVisibility(4);
        this.mSearchInput.addTextChangedListener((TextWatcher)new TextWatcherAdapter(){

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (FloatingSearchView.this.mSkipTextChangeEvent) {
                    FloatingSearchView.this.mSkipTextChangeEvent = false;
                } else {
                    if (FloatingSearchView.this.mSearchInput.getText().toString().length() != 0 && FloatingSearchView.this.mClearButton.getVisibility() == 4) {
                        FloatingSearchView.this.mClearButton.setAlpha(0.0f);
                        FloatingSearchView.this.mClearButton.setVisibility(0);
                        ViewCompat.animate((View)FloatingSearchView.this.mClearButton).alpha(1.0f).setDuration(500L).start();
                    } else if (FloatingSearchView.this.mSearchInput.getText().toString().length() == 0) {
                        FloatingSearchView.this.mClearButton.setVisibility(4);
                    }
                    if (FloatingSearchView.this.mQueryListener != null && FloatingSearchView.this.mIsFocused) {
                        FloatingSearchView.this.mQueryListener.onSearchTextChanged(FloatingSearchView.this.mOldQuery, FloatingSearchView.this.mSearchInput.getText().toString());
                    }
                    FloatingSearchView.this.mOldQuery = FloatingSearchView.this.mSearchInput.getText().toString();
                }
            }
        });
        this.mSearchInput.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (FloatingSearchView.this.mSkipQueryFocusChangeEvent) {
                    FloatingSearchView.this.mSkipQueryFocusChangeEvent = false;
                } else if (hasFocus != FloatingSearchView.this.mIsFocused) {
                    FloatingSearchView.this.setSearchFocusedInternal(hasFocus);
                }
            }
        });
        this.mSearchInput.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View view, int keyCode, KeyEvent keyEvent) {
                if (FloatingSearchView.this.mShowSearchKey && keyCode == 66) {
                    FloatingSearchView.this.setSearchFocusedInternal(false);
                    if (FloatingSearchView.this.mSearchListener != null) {
                        FloatingSearchView.this.mSearchListener.onSearchAction();
                    }
                    return true;
                }
                return false;
            }
        });
        if (this.mLeftActionMode == 4) {
            this.mSearchInputParent.setTranslationX((float)(-Util.dpToPx(52)));
        }
        this.refreshLeftIcon();
        this.mLeftAction.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FloatingSearchView.this.mSearchInput.isFocused()) {
                    FloatingSearchView.this.setSearchFocusedInternal(false);
                } else {
                    switch (FloatingSearchView.this.mLeftActionMode) {
                        case 1: {
                            FloatingSearchView.this.toggleLeftMenu();
                            break;
                        }
                        case 2: {
                            FloatingSearchView.this.setSearchFocusedInternal(true);
                            break;
                        }
                        case 3: {
                            if (FloatingSearchView.this.mOnHomeActionClickListener == null) break;
                            FloatingSearchView.this.mOnHomeActionClickListener.onHomeClicked();
                            break;
                        }
                    }
                }
            }
        });
    }

    public void setLeftActionIconColor(int color2) {
        this.mMenuBtnDrawable.setColor(color2);
        DrawableCompat.setTint((Drawable)this.mIconBackArrow, (int)color2);
        DrawableCompat.setTint((Drawable)this.mIconSearch, (int)color2);
    }

    public void setClearBtnColor(int color2) {
        DrawableCompat.setTint((Drawable)this.mIconClear, (int)color2);
    }

    public void setMenuItemIconColor(int color2) {
        this.mActionMenuItemColor = color2;
        if (this.mMenuView != null) {
            this.mMenuView.setActionIconColor(this.mActionMenuItemColor);
        }
    }

    public void setActionMenuOverflowColor(int color2) {
        this.mOverflowIconColor = color2;
        if (this.mMenuView != null) {
            this.mMenuView.setOverflowColor(this.mOverflowIconColor);
        }
    }

    public void setBackgroundColor(int color2) {
        if (this.mQuerySection != null && this.mSuggestionsList != null) {
            this.mQuerySection.setCardBackgroundColor(color2);
            this.mSuggestionsList.setBackgroundColor(color2);
        }
    }

    public void setViewTextColor(int color2) {
        this.mSearchInputTextColor = color2;
        this.mSuggestionTextColor = color2;
        if (this.mSearchInput != null && this.mSearchBarTitle != null && this.mSuggestionsAdapter != null) {
            Log.d((String)"dfsdfsdf", (String)("setting text color to: " + color2));
            this.mSearchInput.setTextColor(color2);
            this.mSuggestionsAdapter.setTextColor(color2);
            this.mSearchBarTitle.setTextColor(color2);
        }
    }

    public void setHintTextColor(int color2) {
        this.mSearchInputHintColor = color2;
        if (this.mSearchInput != null) {
            this.mSearchInput.setHintTextColor(color2);
        }
    }

    public void setDividerColor(int color2) {
        if (this.mDivider != null) {
            this.mDivider.setBackgroundColor(color2);
        }
    }

    public void openMenu(boolean withAnim) {
        this.openMenu(true, withAnim, false);
    }

    public void closeMenu(boolean withAnim) {
        this.closeMenu(true, withAnim, false);
    }

    private void setLeftActionMode(int mode) {
        this.mLeftActionMode = mode;
    }

    private void refreshLeftIcon() {
        this.mLeftAction.setVisibility(0);
        switch (this.mLeftActionMode) {
            case 1: {
                this.mLeftAction.setImageDrawable((Drawable)this.mMenuBtnDrawable);
                break;
            }
            case 2: {
                this.mLeftAction.setImageDrawable(this.mIconSearch);
                break;
            }
            case 3: {
                this.mLeftAction.setImageDrawable((Drawable)this.mMenuBtnDrawable);
                this.mMenuBtnDrawable.setProgress(1.0f);
                break;
            }
            case 4: {
                this.mLeftAction.setVisibility(4);
            }
        }
    }

    public void inflateOverflowMenu(int menuId) {
        this.mMenuView.resetMenuResource(menuId);
        this.mMenuView.reset(this.actionMenuAvailWidth());
        if (this.mIsFocused) {
            this.mMenuView.hideIfRoomItems(false);
        }
    }

    private int actionMenuAvailWidth() {
        if (this.isInEditMode()) {
            return Util.dpToPx(360) - this.SEARCH_BAR_LEFT_SECTION_DESIRED_WIDTH;
        }
        return this.mQuerySection.getWidth() - this.SEARCH_BAR_LEFT_SECTION_DESIRED_WIDTH;
    }

    private void toggleLeftMenu() {
        if (this.mMenuOpen) {
            this.closeMenu(true, true, true);
        } else {
            this.openMenu(true, true, true);
        }
    }

    private void openMenu(boolean changeMenuIcon, boolean withAnim, boolean notifyListener) {
        if (this.mOnMenuClickListener != null && notifyListener) {
            this.mOnMenuClickListener.onMenuOpened();
        }
        this.mMenuOpen = true;
        if (changeMenuIcon) {
            this.openMenuDrawable(this.mMenuBtnDrawable, withAnim);
        }
    }

    private void closeMenu(boolean changeMenuIcon, boolean withAnim, boolean notifyListener) {
        if (this.mOnMenuClickListener != null && notifyListener) {
            this.mOnMenuClickListener.onMenuClosed();
        }
        this.mMenuOpen = false;
        if (changeMenuIcon) {
            this.closeMenuDrawable(this.mMenuBtnDrawable, withAnim);
        }
    }

    public void setMenuIconProgress(float progress) {
        this.mMenuBtnDrawable.setProgress(progress);
        if (progress == 0.0f) {
            this.closeMenu(false, true, true);
        } else if ((double)progress == 1.0) {
            this.openMenu(false);
        }
    }

    public void setSearchHint(String searchHint) {
        String string2 = this.mSearchHint = searchHint != null ? searchHint : this.getResources().getString(R.string.abc_search_hint);
        if (this.mShowHintNotFocused || this.mSearchInput.isFocused()) {
            this.mSearchInput.setHint((CharSequence)this.mSearchHint);
        } else {
            this.mSearchInput.setHint((CharSequence)"");
        }
    }

    public void setShowHintWhenNotFocused(boolean show) {
        this.mShowHintNotFocused = show;
        if (this.mShowHintNotFocused) {
            this.mSearchInput.setHint((CharSequence)this.mSearchHint);
        }
    }

    public void setSearchBarTitle(CharSequence title) {
        this.mSearchBarTitle.setText(title);
    }

    public void setShowSearchKey(boolean show) {
        this.mShowSearchKey = show;
        if (show) {
            this.mSearchInput.setImeOptions(3);
        } else {
            this.mSearchInput.setImeOptions(1);
        }
    }

    public String getQuery() {
        return this.mSearchInput.getText().toString();
    }

    public void showProgress() {
        this.mLeftAction.setVisibility(8);
        this.mSearchProgress.setVisibility(0);
        new ObjectAnimator();
        ObjectAnimator fadeInProgress = ObjectAnimator.ofFloat((Object)this.mSearchProgress, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        fadeInProgress.start();
    }

    public void hideProgress() {
        this.mLeftAction.setVisibility(0);
        this.mSearchProgress.setVisibility(8);
        new ObjectAnimator();
        ObjectAnimator fadeInExit = ObjectAnimator.ofFloat((Object)this.mLeftAction, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        fadeInExit.start();
    }

    public void setSearchFocused(boolean focused) {
        if (!this.mIsFocused && this.mSuggestionSecHeightListener == null) {
            if (this.mIsSuggestionsSecHeightSet) {
                this.setSearchFocusedInternal(true);
            } else {
                this.mSuggestionSecHeightListener = new OnSuggestionSecHeightSetListener(){

                    @Override
                    public void onSuggestionSecHeightSet() {
                        FloatingSearchView.this.setSearchFocusedInternal(true);
                        FloatingSearchView.this.mSuggestionSecHeightListener = null;
                    }
                };
            }
        }
    }

    public void setOnBindSuggestionCallback(SearchSuggestionsAdapter.OnBindSuggestionCallback callback) {
        this.mOnBindSuggestionCallback = callback;
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.setOnBindSuggestionCallback(this.mOnBindSuggestionCallback);
        }
    }

    public void setSuggestionRightIconColor(int color2) {
        this.mSuggestionRightIconColor = color2;
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.setRightIconColor(this.mSuggestionRightIconColor);
        }
    }

    private void setSuggestionItemTextSize(int sizePx) {
        this.mSuggestionsTextSizePx = sizePx;
    }

    private void setupSuggestionSection() {
        boolean showItemsFromBottom = true;
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext(), 1, showItemsFromBottom);
        this.mSuggestionsList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mSuggestionsList.setItemAnimator(null);
        final GestureDetector gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetectorListenerAdapter(){

            @Override
            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (FloatingSearchView.this.mHostActivity != null) {
                    Util.closeSoftKeyboard(FloatingSearchView.this.mHostActivity);
                }
                return false;
            }
        });
        this.mSuggestionsList.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new OnItemTouchListenerAdapter(){

            @Override
            public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
                gestureDetector.onTouchEvent(e);
                return false;
            }
        });
        this.mSuggestionsAdapter = new SearchSuggestionsAdapter(this.getContext(), this.mSuggestionsTextSizePx, new SearchSuggestionsAdapter.Listener(){

            @Override
            public void onItemSelected(SearchSuggestion item) {
                FloatingSearchView.this.setSearchFocusedInternal(false);
                if (FloatingSearchView.this.mSearchListener != null) {
                    FloatingSearchView.this.mSearchListener.onSuggestionClicked(item);
                }
            }

            @Override
            public void onMoveItemToSearchClicked(SearchSuggestion item) {
                FloatingSearchView.this.mSearchInput.setText((CharSequence)item.getBody());
                FloatingSearchView.this.mSearchInput.setSelection(FloatingSearchView.this.mSearchInput.getText().length());
            }
        });
        this.mSuggestionsAdapter.setTextColor(this.mSuggestionTextColor);
        this.mSuggestionsAdapter.setRightIconColor(this.mSuggestionRightIconColor);
        this.mSuggestionsList.setAdapter((RecyclerView.Adapter)this.mSuggestionsAdapter);
        int cardViewBottomPadding = Util.dpToPx(5);
        this.mSuggestionsSection.setTranslationY((float)(-cardViewBottomPadding));
    }

    private void moveSuggestListToInitialPos() {
        this.mSuggestionListContainer.setTranslationY((float)(-this.mSuggestionListContainer.getMeasuredHeight()));
    }

    public void swapSuggestions(List<? extends SearchSuggestion> newSearchSuggestions) {
        Collections.reverse(newSearchSuggestions);
        this.swapSuggestions(newSearchSuggestions, true);
    }

    private void swapSuggestions(List<? extends SearchSuggestion> newSearchSuggestions, boolean withAnim) {
        float newTranslationY;
        this.mDivider.setVisibility(8);
        this.mSuggestionsAdapter.swapData(newSearchSuggestions);
        this.mSuggestionsList.scrollBy(0, -(newSearchSuggestions.size() * this.getTotalItemsHeight(newSearchSuggestions)));
        int fiveDp = Util.dpToPx(6);
        int threeDp = Util.dpToPx(3);
        ViewCompat.animate((View)this.mSuggestionListContainer).cancel();
        float translationY = -this.mSuggestionListContainer.getHeight() + this.getVisibleItemsHeight(newSearchSuggestions);
        float f = translationY < 0.0f ? (newSearchSuggestions.size() == 0 ? translationY : translationY + (float)threeDp) : (newTranslationY = (float)(-fiveDp));
        if (withAnim) {
            ViewCompat.animate((View)this.mSuggestionListContainer).setStartDelay(120L).setInterpolator(this.SUGGEST_ITEM_ADD_ANIM_INTERPOLATOR).setDuration(250L).translationY(newTranslationY).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationCancel(View view) {
                    FloatingSearchView.this.mSuggestionListContainer.setTranslationY(newTranslationY);
                }
            }).start();
        } else {
            this.mSuggestionListContainer.setTranslationY(newTranslationY);
        }
        if (newSearchSuggestions.size() > 0) {
            this.mDivider.setVisibility(0);
        } else {
            this.mDivider.setVisibility(8);
        }
    }

    private int getVisibleItemsHeight(List<? extends SearchSuggestion> suggestions) {
        int visibleItemsHeight = 0;
        for (SearchSuggestion searchSuggestion : suggestions) {
            if ((visibleItemsHeight += this.getSuggestionItemHeight(searchSuggestion)) > this.mSuggestionListContainer.getHeight()) break;
        }
        return visibleItemsHeight;
    }

    private int getTotalItemsHeight(List<? extends SearchSuggestion> suggestions) {
        int totalItemHeight = 0;
        for (SearchSuggestion searchSuggestion : suggestions) {
            totalItemHeight += this.getSuggestionItemHeight(searchSuggestion);
        }
        return totalItemHeight;
    }

    private int getSuggestionItemHeight(SearchSuggestion suggestion) {
        int leftRightMarginsWidth = Util.dpToPx(124);
        TextView textView = new TextView(this.getContext());
        textView.setTypeface(Typeface.DEFAULT);
        textView.setText((CharSequence)suggestion.getBody(), TextView.BufferType.SPANNABLE);
        textView.setTextSize(0, (float)this.mSuggestionsTextSizePx);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.mSuggestionsList.getWidth() - leftRightMarginsWidth), (int)Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        textView.measure(widthMeasureSpec, heightMeasureSpec);
        int heightPlusPadding = textView.getMeasuredHeight() + Util.dpToPx(8);
        int minHeight = Util.dpToPx(48);
        int height = heightPlusPadding >= minHeight ? heightPlusPadding : minHeight;
        return heightPlusPadding >= minHeight ? heightPlusPadding : minHeight;
    }

    public void clearSuggestions() {
        this.clearSuggestions(null);
    }

    private void clearSuggestions(final OnSuggestionsClearListener listener) {
        if (!this.mIsCollapsing) {
            this.collapseSuggestionsSection(new OnSuggestionsCollapsedListener(){

                @Override
                public void onCollapsed() {
                    FloatingSearchView.this.mSuggestionsAdapter.clearDataSet();
                    if (listener != null) {
                        listener.onCleared();
                    }
                    FloatingSearchView.this.mDivider.setVisibility(8);
                }
            });
        }
    }

    private void collapseSuggestionsSection(final OnSuggestionsCollapsedListener listener) {
        this.mIsCollapsing = true;
        final int destTranslationY = -(this.mSuggestionListContainer.getHeight() + Util.dpToPx(3));
        ViewCompat.animate((View)this.mSuggestionListContainer).translationY((float)destTranslationY).setDuration(200L).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationEnd(View view) {
                if (listener != null) {
                    listener.onCollapsed();
                }
                FloatingSearchView.this.mIsCollapsing = false;
            }

            public void onAnimationCancel(View view) {
                FloatingSearchView.this.mSuggestionListContainer.setTranslationY((float)destTranslationY);
            }
        }).start();
    }

    public void clearSearchFocus() {
        this.setSearchFocusedInternal(false);
    }

    public boolean isSearchBarFocused() {
        return this.mIsFocused;
    }

    private void setSearchFocusedInternal(boolean focused) {
        this.mIsFocused = focused;
        if (focused) {
            this.mLeftAction.setVisibility(0);
            this.transitionInLeftSection(true);
            if (this.mMenuOpen) {
                this.closeMenu(false, true, true);
            }
            this.moveSuggestListToInitialPos();
            this.mSuggestionsSection.setVisibility(0);
            this.fadeInBackground();
            this.mSearchInput.requestFocus();
            this.mMenuView.hideIfRoomItems(true);
            Util.showSoftKeyboard(this.getContext(), this.mSearchInput);
            if (this.mFocusChangeListener != null) {
                this.mFocusChangeListener.onFocus();
            }
        } else {
            this.transitionOutLeftSection(true);
            this.clearSuggestions(new OnSuggestionsClearListener(){

                @Override
                public void onCleared() {
                    FloatingSearchView.this.mSuggestionsSection.setVisibility(4);
                }
            });
            this.fadeOutBackground();
            this.findViewById(R.id.search_bar).requestFocus();
            if (this.mHostActivity != null) {
                Util.closeSoftKeyboard(this.mHostActivity);
            }
            this.mMenuView.showIfRoomItems(true);
            this.mClearButton.setVisibility(4);
            if (this.mSearchInput.length() != 0) {
                this.mSearchInput.setText((CharSequence)"");
            }
            if (this.mFocusChangeListener != null) {
                this.mFocusChangeListener.onFocusCleared();
            }
        }
    }

    private void changeIcon(ImageView imageView, Drawable newIcon, boolean withAnim) {
        imageView.setImageDrawable(newIcon);
        if (withAnim) {
            new ObjectAnimator();
            ObjectAnimator fadeInVoiceInputOrClear = ObjectAnimator.ofFloat((Object)imageView, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
            fadeInVoiceInputOrClear.start();
        } else {
            imageView.setAlpha(1.0f);
        }
    }

    private void transitionInLeftSection(boolean withAnim) {
        switch (this.mLeftActionMode) {
            case 1: {
                this.openMenuDrawable(this.mMenuBtnDrawable, withAnim);
                if (this.mMenuOpen) break;
                break;
            }
            case 2: {
                this.mLeftAction.setImageDrawable(this.mIconBackArrow);
                if (!withAnim) break;
                this.mLeftAction.setRotation(45.0f);
                this.mLeftAction.setAlpha(0.0f);
                ObjectAnimator rotateAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).rotation(0.0f).get();
                ObjectAnimator fadeAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).alpha(1.0f).get();
                AnimatorSet animSet = new AnimatorSet();
                animSet.setDuration(500L);
                animSet.playTogether(new Animator[]{rotateAnim, fadeAnim});
                animSet.start();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.mLeftAction.setImageDrawable(this.mIconBackArrow);
                if (withAnim) {
                    ObjectAnimator searchInputTransXAnim = ViewPropertyObjectAnimator.animate((View)this.mSearchInputParent).translationX(0.0f).get();
                    this.mLeftAction.setScaleX(0.5f);
                    this.mLeftAction.setScaleY(0.5f);
                    this.mLeftAction.setAlpha(0.0f);
                    this.mLeftAction.setTranslationX((float)Util.dpToPx(8));
                    ObjectAnimator transXArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).translationX(1.0f).get();
                    ObjectAnimator scaleXArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).scaleX(1.0f).get();
                    ObjectAnimator scaleYArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).scaleY(1.0f).get();
                    ObjectAnimator fadeArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).alpha(1.0f).get();
                    transXArrowAnim.setStartDelay(150L);
                    scaleXArrowAnim.setStartDelay(150L);
                    scaleYArrowAnim.setStartDelay(150L);
                    fadeArrowAnim.setStartDelay(150L);
                    AnimatorSet animSet = new AnimatorSet();
                    animSet.setDuration(500L);
                    animSet.playTogether(new Animator[]{searchInputTransXAnim, transXArrowAnim, scaleXArrowAnim, scaleYArrowAnim, fadeArrowAnim});
                    animSet.start();
                    break;
                }
                this.mSearchInputParent.setTranslationX(0.0f);
            }
        }
    }

    private void transitionOutLeftSection(boolean withAnim) {
        switch (this.mLeftActionMode) {
            case 1: {
                this.closeMenuDrawable(this.mMenuBtnDrawable, withAnim);
                break;
            }
            case 2: {
                this.changeIcon(this.mLeftAction, this.mIconSearch, withAnim);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.mLeftAction.setImageDrawable(this.mIconBackArrow);
                if (withAnim) {
                    ObjectAnimator searchInputTransXAnim = ViewPropertyObjectAnimator.animate((View)this.mSearchInputParent).translationX((float)(-Util.dpToPx(52))).get();
                    ObjectAnimator scaleXArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).scaleX(0.5f).get();
                    ObjectAnimator scaleYArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).scaleY(0.5f).get();
                    ObjectAnimator fadeArrowAnim = ViewPropertyObjectAnimator.animate((View)this.mLeftAction).alpha(0.5f).get();
                    scaleXArrowAnim.setDuration(300L);
                    scaleYArrowAnim.setDuration(300L);
                    fadeArrowAnim.setDuration(300L);
                    scaleXArrowAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            FloatingSearchView.this.mLeftAction.setScaleX(1.0f);
                            FloatingSearchView.this.mLeftAction.setScaleY(1.0f);
                            FloatingSearchView.this.mLeftAction.setAlpha(1.0f);
                            FloatingSearchView.this.mLeftAction.setVisibility(4);
                        }
                    });
                    AnimatorSet animSet = new AnimatorSet();
                    animSet.setDuration(350L);
                    animSet.playTogether(new Animator[]{scaleXArrowAnim, scaleYArrowAnim, fadeArrowAnim, searchInputTransXAnim});
                    animSet.start();
                    break;
                }
                this.mLeftAction.setVisibility(4);
            }
        }
    }

    public void setOnQueryChangeListener(OnQueryChangeListener listener) {
        this.mQueryListener = listener;
    }

    public void setOnSearchListener(OnSearchListener listener) {
        this.mSearchListener = listener;
    }

    public void setOnFocusChangeListener(OnFocusChangeListener listener) {
        this.mFocusChangeListener = listener;
    }

    public void setOnLeftMenuClickListener(OnLeftMenuClickListener listener) {
        this.mOnMenuClickListener = listener;
    }

    public void setOnHomeActionClickListener(OnHomeActionClickListener listener) {
        this.mOnHomeActionClickListener = listener;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mActionMenuItemListener = listener;
    }

    private void openMenuDrawable(final DrawerArrowDrawable drawerArrowDrawable, boolean withAnim) {
        if (withAnim) {
            ValueAnimator anim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    drawerArrowDrawable.setProgress(value);
                }
            });
            anim.setDuration(250L);
            anim.start();
        } else {
            drawerArrowDrawable.setProgress(1.0f);
        }
    }

    private void closeMenuDrawable(final DrawerArrowDrawable drawerArrowDrawable, boolean withAnim) {
        if (withAnim) {
            ValueAnimator anim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    drawerArrowDrawable.setProgress(value);
                }
            });
            anim.setDuration(250L);
            anim.start();
        } else {
            drawerArrowDrawable.setProgress(0.0f);
        }
    }

    private void fadeOutBackground() {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{150, 0});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                FloatingSearchView.this.mBackgroundDrawable.setAlpha(value);
            }
        });
        anim.setDuration(250L);
        anim.start();
    }

    private void fadeInBackground() {
        ValueAnimator anim = ValueAnimator.ofInt((int[])new int[]{0, 150});
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                FloatingSearchView.this.mBackgroundDrawable.setAlpha(value);
            }
        });
        anim.setDuration(250L);
        anim.start();
    }

    public void setDismissOnOutsideClick(boolean enable) {
        this.mDismissOnOutsideTouch = enable;
        this.mSuggestionsSection.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (FloatingSearchView.this.mDismissOnOutsideTouch && FloatingSearchView.this.mIsFocused) {
                    FloatingSearchView.this.setSearchFocusedInternal(false);
                }
                return true;
            }
        });
    }

    private boolean isRTL() {
        Configuration config = this.getResources().getConfiguration();
        return ViewCompat.getLayoutDirection((View)this) == 1;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.suggestions = this.mSuggestionsAdapter.getDataSet();
        if (!this.mSuggestionsAdapter.getDataSet().isEmpty()) {
            savedState.suggestObjectCreator = this.mSuggestionsAdapter.getDataSet().get(0).getCreator();
        }
        savedState.isFocused = this.mIsFocused;
        savedState.query = this.getQuery();
        savedState.suggestionTextSize = this.mSuggestionsTextSizePx;
        savedState.searchHint = this.mSearchHint;
        savedState.dismissOnOutsideClick = this.mDismissOnOutsideTouch;
        savedState.showSearchKey = this.mShowSearchKey;
        savedState.showHintWhenNotFocused = this.mShowHintNotFocused;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        final SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mIsFocused = savedState.isFocused;
        this.setSuggestionItemTextSize(savedState.suggestionTextSize);
        this.setDismissOnOutsideClick(savedState.dismissOnOutsideClick);
        this.setShowSearchKey(savedState.showSearchKey);
        this.setShowHintWhenNotFocused(savedState.showHintWhenNotFocused);
        this.setSearchHint(savedState.searchHint);
        if (this.mIsFocused) {
            this.mBackgroundDrawable.setAlpha(150);
            this.mSkipTextChangeEvent = true;
            this.mSkipQueryFocusChangeEvent = true;
            this.mSuggestionsSection.setVisibility(0);
            this.mSuggestionSecHeightListener = new OnSuggestionSecHeightSetListener(){

                @Override
                public void onSuggestionSecHeightSet() {
                    FloatingSearchView.this.swapSuggestions(savedState.suggestions, false);
                    FloatingSearchView.this.mSuggestionSecHeightListener = null;
                    FloatingSearchView.this.transitionInLeftSection(false);
                }
            };
            this.mClearButton.setVisibility(savedState.query.length() == 0 ? 4 : 0);
            this.mLeftAction.setVisibility(0);
            Util.showSoftKeyboard(this.getContext(), this.mSearchInput);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewCompat.animate((View)this.mSuggestionListContainer).cancel();
    }

    static class SavedState
    extends View.BaseSavedState {
        private Parcelable.Creator suggestObjectCreator;
        private List<? extends SearchSuggestion> suggestions = new ArrayList<SearchSuggestion>();
        private boolean isFocused;
        private String query;
        private int suggestionTextSize;
        private String searchHint;
        private boolean dismissOnOutsideClick;
        private boolean showSearchKey;
        private boolean showHintWhenNotFocused;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            if (this.suggestObjectCreator != null) {
                in.readTypedList(this.suggestions, this.suggestObjectCreator);
            }
            this.isFocused = in.readInt() != 0;
            this.query = in.readString();
            this.suggestionTextSize = in.readInt();
            this.searchHint = in.readString();
            this.dismissOnOutsideClick = in.readInt() != 0;
            this.showSearchKey = in.readInt() != 0;
            this.showHintWhenNotFocused = in.readInt() != 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeTypedList(this.suggestions);
            out.writeInt(this.isFocused ? 1 : 0);
            out.writeString(this.query);
            out.writeInt(this.suggestionTextSize);
            out.writeString(this.searchHint);
            out.writeInt(this.dismissOnOutsideClick ? 1 : 0);
            out.writeInt(this.showSearchKey ? 1 : 0);
            out.writeInt(this.showHintWhenNotFocused ? 1 : 0);
        }
    }

    private static interface OnSuggestionsCollapsedListener {
        public void onCollapsed();
    }

    private static interface OnSuggestionsClearListener {
        public void onCleared();
    }

    public static interface OnFocusChangeListener {
        public void onFocus();

        public void onFocusCleared();
    }

    public static interface OnQueryChangeListener {
        public void onSearchTextChanged(String var1, String var2);
    }

    public static interface OnMenuItemClickListener {
        public void onActionMenuItemSelected(MenuItem var1);
    }

    public static interface OnSearchListener {
        public void onSuggestionClicked(SearchSuggestion var1);

        public void onSearchAction();
    }

    public static interface OnHomeActionClickListener {
        public void onHomeClicked();
    }

    public static interface OnLeftMenuClickListener {
        public void onMenuOpened();

        public void onMenuClosed();
    }

    private static interface OnSuggestionSecHeightSetListener {
        public void onSuggestionSecHeightSet();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LeftActionMode {
    }
}

