/*
 * Decompiled with CFR 0.152.
 */
package org.angmarch.views;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import java.util.Arrays;
import java.util.List;
import org.angmarch.views.NiceSpinnerAdapter;
import org.angmarch.views.NiceSpinnerAdapterWrapper;
import org.angmarch.views.NiceSpinnerBaseAdapter;
import org.angmarch.views.PopUpTextAlignment;
import org.angmarch.views.R;
import org.angmarch.views.SimpleSpinnerTextFormatter;
import org.angmarch.views.SpinnerTextFormatter;

public class NiceSpinner
extends AppCompatTextView {
    private static final int MAX_LEVEL = 10000;
    private static final int DEFAULT_ELEVATION = 16;
    private static final String INSTANCE_STATE = "instance_state";
    private static final String SELECTED_INDEX = "selected_index";
    private static final String IS_POPUP_SHOWING = "is_popup_showing";
    private static final String IS_ARROW_HIDDEN = "is_arrow_hidden";
    private static final String ARROW_DRAWABLE_RES_ID = "arrow_drawable_res_id";
    public static final int VERTICAL_OFFSET = 1;
    private int selectedIndex;
    private Drawable arrowDrawable;
    private PopupWindow popupWindow;
    private ListView listView;
    private NiceSpinnerBaseAdapter adapter;
    private AdapterView.OnItemClickListener onItemClickListener;
    private AdapterView.OnItemSelectedListener onItemSelectedListener;
    private boolean isArrowHidden;
    private int textColor;
    private int backgroundSelector;
    private int arrowDrawableTint;
    private int displayHeight;
    private int parentVerticalOffset;
    private int dropDownListPaddingBottom;
    @DrawableRes
    private int arrowDrawableResId;
    private SpinnerTextFormatter spinnerTextFormatter = new SimpleSpinnerTextFormatter();
    private SpinnerTextFormatter selectedTextFormatter = new SimpleSpinnerTextFormatter();
    private PopUpTextAlignment horizontalAlignment;
    @Nullable
    private ObjectAnimator arrowAnimator = null;

    public NiceSpinner(Context context) {
        super(context);
        this.init(context, null);
    }

    public NiceSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public NiceSpinner(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putInt(SELECTED_INDEX, this.selectedIndex);
        bundle.putBoolean(IS_ARROW_HIDDEN, this.isArrowHidden);
        bundle.putInt(ARROW_DRAWABLE_RES_ID, this.arrowDrawableResId);
        if (this.popupWindow != null) {
            bundle.putBoolean(IS_POPUP_SHOWING, this.popupWindow.isShowing());
        }
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable savedState) {
        if (savedState instanceof Bundle) {
            Bundle bundle = (Bundle)savedState;
            this.selectedIndex = bundle.getInt(SELECTED_INDEX);
            if (this.adapter != null) {
                this.setTextInternal(this.selectedTextFormatter.format(this.adapter.getItemInDataset(this.selectedIndex)).toString());
                this.adapter.setSelectedIndex(this.selectedIndex);
            }
            if (bundle.getBoolean(IS_POPUP_SHOWING) && this.popupWindow != null) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        NiceSpinner.this.showDropDown();
                    }
                });
            }
            this.isArrowHidden = bundle.getBoolean(IS_ARROW_HIDDEN, false);
            this.arrowDrawableResId = bundle.getInt(ARROW_DRAWABLE_RES_ID);
            savedState = bundle.getParcelable(INSTANCE_STATE);
        }
        super.onRestoreInstanceState(savedState);
    }

    private void init(Context context, AttributeSet attrs) {
        Resources resources = this.getResources();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NiceSpinner);
        int defaultPadding = resources.getDimensionPixelSize(R.dimen.one_and_a_half_grid_unit);
        this.setGravity(8388627);
        this.setPadding(resources.getDimensionPixelSize(R.dimen.three_grid_unit), defaultPadding, defaultPadding, defaultPadding);
        this.setClickable(true);
        this.backgroundSelector = typedArray.getResourceId(R.styleable.NiceSpinner_backgroundSelector, R.drawable.selector);
        this.setBackgroundResource(this.backgroundSelector);
        this.textColor = typedArray.getColor(R.styleable.NiceSpinner_textTint, this.getDefaultTextColor(context));
        this.setTextColor(this.textColor);
        this.listView = new ListView(context);
        this.listView.setId(this.getId());
        this.listView.setDivider(null);
        this.listView.setItemsCanFocus(true);
        this.listView.setVerticalScrollBarEnabled(false);
        this.listView.setHorizontalScrollBarEnabled(false);
        this.listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                int offsetPosition = position;
                if (position >= NiceSpinner.this.selectedIndex && position < NiceSpinner.this.adapter.getCount()) {
                    ++offsetPosition;
                }
                NiceSpinner.this.selectedIndex = offsetPosition;
                if (NiceSpinner.this.onItemClickListener != null) {
                    NiceSpinner.this.onItemClickListener.onItemClick(parent, view, position, id2);
                }
                if (NiceSpinner.this.onItemSelectedListener != null) {
                    NiceSpinner.this.onItemSelectedListener.onItemSelected(parent, view, position, id2);
                }
                NiceSpinner.this.adapter.setSelectedIndex(offsetPosition);
                NiceSpinner.this.setTextInternal(NiceSpinner.this.selectedTextFormatter.format(NiceSpinner.this.adapter.getItemInDataset(offsetPosition)).toString());
                NiceSpinner.this.dismissDropDown();
            }
        });
        this.popupWindow = new PopupWindow(context);
        this.popupWindow.setContentView((View)this.listView);
        this.popupWindow.setOutsideTouchable(true);
        this.popupWindow.setFocusable(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.popupWindow.setElevation(16.0f);
            this.popupWindow.setBackgroundDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.spinner_drawable));
        } else {
            this.popupWindow.setBackgroundDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.drop_down_shadow));
        }
        this.popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (!NiceSpinner.this.isArrowHidden) {
                    NiceSpinner.this.animateArrow(false);
                }
            }
        });
        this.isArrowHidden = typedArray.getBoolean(R.styleable.NiceSpinner_hideArrow, false);
        this.arrowDrawableTint = typedArray.getColor(R.styleable.NiceSpinner_arrowTint, Integer.MAX_VALUE);
        this.arrowDrawableResId = typedArray.getResourceId(R.styleable.NiceSpinner_arrowDrawable, R.drawable.arrow);
        this.dropDownListPaddingBottom = typedArray.getDimensionPixelSize(R.styleable.NiceSpinner_dropDownListPaddingBottom, 0);
        this.horizontalAlignment = PopUpTextAlignment.fromId(typedArray.getInt(R.styleable.NiceSpinner_popupTextAlignment, PopUpTextAlignment.CENTER.ordinal()));
        CharSequence[] entries = typedArray.getTextArray(R.styleable.NiceSpinner_entries);
        if (entries != null) {
            this.attachDataSource(Arrays.asList(entries));
        }
        typedArray.recycle();
        this.measureDisplayHeight();
    }

    private void measureDisplayHeight() {
        this.displayHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
    }

    private int getParentVerticalOffset() {
        if (this.parentVerticalOffset > 0) {
            return this.parentVerticalOffset;
        }
        int[] locationOnScreen = new int[2];
        this.getLocationOnScreen(locationOnScreen);
        this.parentVerticalOffset = locationOnScreen[1];
        return this.parentVerticalOffset;
    }

    protected void onDetachedFromWindow() {
        if (this.arrowAnimator != null) {
            this.arrowAnimator.cancel();
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (Build.VERSION.SDK_INT <= 19) {
            this.onVisibilityChanged((View)this, this.getVisibility());
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.arrowDrawable = this.initArrowDrawable(this.arrowDrawableTint);
        this.setArrowDrawableOrHide(this.arrowDrawable);
    }

    private Drawable initArrowDrawable(int drawableTint) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)this.arrowDrawableResId);
        if (drawable2 != null) {
            drawable2 = DrawableCompat.wrap((Drawable)drawable2);
            if (drawableTint != Integer.MAX_VALUE && drawableTint != 0) {
                DrawableCompat.setTint((Drawable)drawable2, (int)drawableTint);
            }
        }
        return drawable2;
    }

    private void setArrowDrawableOrHide(Drawable drawable2) {
        if (!this.isArrowHidden && drawable2 != null) {
            this.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
        } else {
            this.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        }
    }

    private int getDefaultTextColor(Context context) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(16842806, typedValue, true);
        TypedArray typedArray = context.obtainStyledAttributes(typedValue.data, new int[]{16842806});
        int defaultTextColor = typedArray.getColor(0, -16777216);
        typedArray.recycle();
        return defaultTextColor;
    }

    public Object getSelectedItem() {
        return this.adapter.getItemInDataset(this.selectedIndex);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setArrowDrawable(@DrawableRes @ColorRes int drawableId) {
        this.arrowDrawableResId = drawableId;
        this.arrowDrawable = this.initArrowDrawable(R.drawable.arrow);
        this.setArrowDrawableOrHide(this.arrowDrawable);
    }

    public void setArrowDrawable(Drawable drawable2) {
        this.arrowDrawable = drawable2;
        this.setArrowDrawableOrHide(this.arrowDrawable);
    }

    public void setTextInternal(String text) {
        if (this.selectedTextFormatter != null) {
            this.setText((CharSequence)this.selectedTextFormatter.format(text));
        } else {
            this.setText(text);
        }
    }

    public void setSelectedIndex(int position) {
        if (this.adapter != null) {
            if (position >= 0 && position <= this.adapter.getCount()) {
                this.adapter.setSelectedIndex(position);
                this.selectedIndex = position;
                this.setTextInternal(this.selectedTextFormatter.format(this.adapter.getItemInDataset(position)).toString());
            } else {
                throw new IllegalArgumentException("Position must be lower than adapter count!");
            }
        }
    }

    public void addOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public <T> void attachDataSource(@NonNull List<T> list) {
        this.adapter = new NiceSpinnerAdapter<T>(this.getContext(), list, this.textColor, this.backgroundSelector, this.spinnerTextFormatter, this.horizontalAlignment);
        this.setAdapterInternal(this.adapter);
    }

    public void setAdapter(ListAdapter adapter) {
        this.adapter = new NiceSpinnerAdapterWrapper(this.getContext(), adapter, this.textColor, this.backgroundSelector, this.spinnerTextFormatter, this.horizontalAlignment);
        this.setAdapterInternal(this.adapter);
    }

    public PopUpTextAlignment getPopUpTextAlignment() {
        return this.horizontalAlignment;
    }

    private void setAdapterInternal(NiceSpinnerBaseAdapter adapter) {
        this.selectedIndex = 0;
        this.listView.setAdapter((ListAdapter)adapter);
        this.setTextInternal(this.selectedTextFormatter.format(adapter.getItemInDataset(this.selectedIndex)).toString());
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled() && event.getAction() == 1) {
            if (!this.popupWindow.isShowing()) {
                this.showDropDown();
            } else {
                this.dismissDropDown();
            }
        }
        return super.onTouchEvent(event);
    }

    private void animateArrow(boolean shouldRotateUp) {
        int start = shouldRotateUp ? 0 : 10000;
        int end = shouldRotateUp ? 10000 : 0;
        this.arrowAnimator = ObjectAnimator.ofInt((Object)this.arrowDrawable, (String)"level", (int[])new int[]{start, end});
        this.arrowAnimator.setInterpolator((TimeInterpolator)new LinearOutSlowInInterpolator());
        this.arrowAnimator.start();
    }

    public void dismissDropDown() {
        if (!this.isArrowHidden) {
            this.animateArrow(false);
        }
        this.popupWindow.dismiss();
    }

    public void showDropDown() {
        if (!this.isArrowHidden) {
            this.animateArrow(true);
        }
        this.measurePopUpDimension();
        this.popupWindow.showAsDropDown((View)this);
    }

    private void measurePopUpDimension() {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.getPopUpHeight(), (int)Integer.MIN_VALUE);
        this.listView.measure(widthSpec, heightSpec);
        this.popupWindow.setWidth(this.listView.getMeasuredWidth());
        this.popupWindow.setHeight(this.listView.getMeasuredHeight() - this.dropDownListPaddingBottom);
    }

    private int getPopUpHeight() {
        return Math.max(this.verticalSpaceBelow(), this.verticalSpaceAbove());
    }

    private int verticalSpaceAbove() {
        return this.getParentVerticalOffset();
    }

    private int verticalSpaceBelow() {
        return this.displayHeight - this.getParentVerticalOffset() - this.getMeasuredHeight();
    }

    public void setTintColor(@ColorRes int resId) {
        if (this.arrowDrawable != null && !this.isArrowHidden) {
            DrawableCompat.setTint((Drawable)this.arrowDrawable, (int)ContextCompat.getColor((Context)this.getContext(), (int)resId));
        }
    }

    public void setArrowTintColor(int resolvedColor) {
        if (this.arrowDrawable != null && !this.isArrowHidden) {
            DrawableCompat.setTint((Drawable)this.arrowDrawable, (int)resolvedColor);
        }
    }

    public void hideArrow() {
        this.isArrowHidden = true;
        this.setArrowDrawableOrHide(this.arrowDrawable);
    }

    public void showArrow() {
        this.isArrowHidden = false;
        this.setArrowDrawableOrHide(this.arrowDrawable);
    }

    public boolean isArrowHidden() {
        return this.isArrowHidden;
    }

    public void setDropDownListPaddingBottom(int paddingBottom) {
        this.dropDownListPaddingBottom = paddingBottom;
    }

    public int getDropDownListPaddingBottom() {
        return this.dropDownListPaddingBottom;
    }

    public void setSpinnerTextFormatter(SpinnerTextFormatter spinnerTextFormatter) {
        this.spinnerTextFormatter = spinnerTextFormatter;
    }

    public void setSelectedTextFormatter(SpinnerTextFormatter textFormatter) {
        this.selectedTextFormatter = textFormatter;
    }
}

