/*
 * Decompiled with CFR 0.152.
 */
package org.angmarch.views;

import android.content.Context;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import org.angmarch.views.R;

public abstract class NiceSpinnerBaseAdapter<T>
extends BaseAdapter {
    protected Context mContext;
    protected int mSelectedIndex;
    protected int mTextColor;
    protected int mBackgroundSelector;

    public NiceSpinnerBaseAdapter(Context context, int textColor, int backgroundSelector) {
        this.mContext = context;
        this.mTextColor = textColor;
        this.mBackgroundSelector = backgroundSelector;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        TextView textView;
        if (convertView == null) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.spinner_list_item, null);
            textView = (TextView)convertView.findViewById(R.id.tv_tinted_spinner);
            if (Build.VERSION.SDK_INT >= 16) {
                textView.setBackground(ContextCompat.getDrawable((Context)this.mContext, (int)this.mBackgroundSelector));
            }
            convertView.setTag((Object)new ViewHolder(textView));
        } else {
            textView = ((ViewHolder)convertView.getTag()).textView;
        }
        textView.setText((CharSequence)this.getItem(position).toString());
        textView.setTextColor(this.mTextColor);
        return convertView;
    }

    public int getSelectedIndex() {
        return this.mSelectedIndex;
    }

    public void notifyItemSelected(int index) {
        this.mSelectedIndex = index;
    }

    public long getItemId(int position) {
        return position;
    }

    public abstract T getItem(int var1);

    public abstract int getCount();

    public abstract T getItemInDataset(int var1);

    protected static class ViewHolder {
        public TextView textView;

        public ViewHolder(TextView textView) {
            this.textView = textView;
        }
    }
}

