/*
 * Decompiled with CFR 0.152.
 */
package edu.arbelkilani.compass;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.RelativeLayout;

class CompassSkeleton
extends RelativeLayout {
    private static final int DEGREES_COLOR = -16777216;
    private static final boolean SHOW_ORIENTATION_LABEL = false;
    private static final int DEFAULT_DEGREES_STEP = 15;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final String EAST_INDEX = "E";
    private static final String NORTH_INDEX = "N";
    private static final String WEST_INDEX = "W";
    private static final String SOUTH_INDEX = "S";
    private static final int DEFAULT_MINIMIZED_ALPHA = 180;
    private static final int DEFAULT_ORIENTATION_LABELS_COLOR = -16777216;
    private static final boolean DEFAULT_SHOW_BORDER = false;
    private int mWidth;
    private int mCenterX;
    private int mCenterY;
    private int mDegreesColor = -16777216;
    private boolean mShowOrientationLabel = false;
    private int mDegreesStep = 15;
    private int mOrientationLabelsColor = -16777216;
    private boolean mShowBorder = false;
    private int mBorderColor = -16777216;

    public CompassSkeleton(Context context) {
        super(context);
        this.init(context, null);
    }

    public CompassSkeleton(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CompassSkeleton(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        Log.d((String)"TAG", (String)"init function");
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (widthMeasureSpec < heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, widthMeasureSpec);
        } else {
            super.onMeasure(heightMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mWidth = this.getHeight() > this.getWidth() ? this.getWidth() : this.getHeight();
        this.mCenterX = this.mWidth / 2;
        this.mCenterY = this.mWidth / 2;
        this.drawCompassSkeleton(canvas);
        this.drawOuterCircle(canvas);
    }

    private void drawOuterCircle(Canvas canvas) {
        int mStrokeWidth = (int)((float)this.mWidth * 0.01f);
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)mStrokeWidth);
        paint.setColor(this.mBorderColor);
        float radius = this.mWidth / 2 - mStrokeWidth / 2;
        RectF rectF = new RectF();
        rectF.set((float)this.mCenterX - radius, (float)this.mCenterY - radius, (float)this.mCenterX + radius, (float)this.mCenterY + radius);
        if (this.mShowBorder) {
            canvas.drawArc(rectF, 0.0f, 360.0f, false, paint);
        }
    }

    private void drawCompassSkeleton(Canvas canvas) {
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        paint.setStrokeCap(Paint.Cap.ROUND);
        TextPaint textPaint = new TextPaint();
        textPaint.setTextSize((float)this.mWidth * 0.06f);
        textPaint.setColor(this.mOrientationLabelsColor);
        Rect rect = new Rect();
        int rPadded = this.mCenterX - (int)((float)this.mWidth * 0.01f);
        for (int i = 0; i <= 360; i += this.mDegreesStep) {
            int rEnd;
            if (i % 90 == 0) {
                rEnd = this.mCenterX - (int)((float)this.mWidth * 0.08f);
                int rText = this.mCenterX - (int)((float)this.mWidth * 0.15f);
                paint.setColor(this.mDegreesColor);
                paint.setStrokeWidth((float)this.mWidth * 0.02f);
                this.showOrientationLabel(canvas, textPaint, rect, i, rText);
            } else if (i % 45 == 0) {
                rEnd = this.mCenterX - (int)((float)this.mWidth * 0.06f);
                paint.setColor(this.mDegreesColor);
                paint.setStrokeWidth((float)this.mWidth * 0.02f);
            } else {
                rEnd = this.mCenterX - (int)((float)this.mWidth * 0.04f);
                paint.setColor(this.mDegreesColor);
                paint.setStrokeWidth((float)this.mWidth * 0.015f);
                paint.setAlpha(180);
            }
            int startX = (int)((double)this.mCenterX + (double)rPadded * Math.cos(Math.toRadians(i)));
            int startY = (int)((double)this.mCenterX - (double)rPadded * Math.sin(Math.toRadians(i)));
            int stopX = (int)((double)this.mCenterX + (double)rEnd * Math.cos(Math.toRadians(i)));
            int stopY = (int)((double)this.mCenterX - (double)rEnd * Math.sin(Math.toRadians(i)));
            canvas.drawLine((float)startX, (float)startY, (float)stopX, (float)stopY, paint);
        }
    }

    private void showOrientationLabel(Canvas canvas, TextPaint textPaint, Rect rect, int i, int rText) {
        if (this.mShowOrientationLabel) {
            int textX = (int)((double)this.mCenterX + (double)rText * Math.cos(Math.toRadians(i)));
            int textY = (int)((double)this.mCenterX - (double)rText * Math.sin(Math.toRadians(i)));
            String direction = EAST_INDEX;
            if (i == 0) {
                direction = EAST_INDEX;
            } else if (i == 90) {
                direction = NORTH_INDEX;
            } else if (i == 180) {
                direction = WEST_INDEX;
            } else if (i == 270) {
                direction = SOUTH_INDEX;
            }
            textPaint.getTextBounds(direction, 0, 1, rect);
            canvas.drawText(direction, (float)(textX - rect.width() / 2), (float)(textY + rect.height() / 2), (Paint)textPaint);
        }
    }

    public void setDegreesColor(int degreesColor) {
        this.mDegreesColor = degreesColor;
        this.invalidate();
    }

    public void setShowOrientationLabel(boolean showOrientationLabel) {
        this.mShowOrientationLabel = showOrientationLabel;
        this.invalidate();
    }

    public void setDegreesStep(int degreesStep) throws Exception {
        if (degreesStep > 360 || degreesStep < 0 || 360 % degreesStep != 0) {
            throw new Exception("Degree step is invalid");
        }
        this.mDegreesStep = degreesStep;
        this.invalidate();
    }

    public void setOrientationLabelsColor(int orientationLabelsColor) {
        this.mOrientationLabelsColor = orientationLabelsColor;
        this.invalidate();
    }

    public void setShowBorder(boolean showBorder) {
        this.mShowBorder = showBorder;
        this.invalidate();
    }

    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
        this.invalidate();
    }
}

