/*
 * Decompiled with CFR 0.152.
 */
package edu.arbelkilani.compass;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import edu.arbelkilani.compass.CompassListener;
import edu.arbelkilani.compass.CompassSkeleton;
import edu.arbelkilani.compass.R;
import java.text.DecimalFormat;

public class Compass
extends RelativeLayout
implements SensorEventListener {
    private static final String TAG = Compass.class.getSimpleName();
    private static final float NEEDLE_PADDING = 0.17f;
    private static final String DEGREE = "\u00b0";
    private static final float DATA_PADDING = 0.35f;
    private static final float TEXT_SIZE_FACTOR = 0.014f;
    private static final int DEFAULT_DEGREES_STEP = 15;
    private static final boolean DEFAULT_SHOW_ORIENTATION_LABEL = false;
    private static final boolean DEFAULT_SHOW_DEGREE_VALUE = false;
    private static final int DEFAULT_ORIENTATION_LABEL_COLOR = -16777216;
    private static final boolean DEFAULT_SHOW_BORDER = false;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private ImageView mNeedleImageView;
    private TextView mDegreeTextView;
    private float mCurrentDegree = 0.0f;
    private boolean mShowBorder;
    private int mBorderColor;
    private int mDegreesColor;
    private boolean mShowOrientationLabels;
    private int mOrientationLabelsColor;
    private int mDegreeValueColor;
    private boolean mShowDegreeValue;
    private int mDegreesStep;
    private Drawable mNeedle;
    private CompassListener mCompassListener;

    public Compass(Context context) {
        super(context);
        this.init(context, null);
    }

    public Compass(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public Compass(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (widthMeasureSpec < heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, widthMeasureSpec);
        } else {
            super.onMeasure(heightMeasureSpec, heightMeasureSpec);
        }
    }

    private void init(Context context, AttributeSet attrs) {
        LayoutInflater.from((Context)context).inflate(R.layout.compass_layout, (ViewGroup)this, true);
        SensorManager mSensorManager = (SensorManager)this.getContext().getSystemService("sensor");
        mSensorManager.registerListener((SensorEventListener)this, mSensorManager.getDefaultSensor(3), 1);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Compass, 0, 0);
        if (typedArray != null) {
            this.mShowBorder = typedArray.getBoolean(R.styleable.Compass_show_border, false);
            this.mBorderColor = typedArray.getColor(R.styleable.Compass_border_color, -16777216);
            this.mDegreesColor = typedArray.getColor(R.styleable.Compass_degree_color, -16777216);
            this.mShowOrientationLabels = typedArray.getBoolean(R.styleable.Compass_show_orientation_labels, false);
            this.mOrientationLabelsColor = typedArray.getColor(R.styleable.Compass_orientation_labels_color, -16777216);
            this.mDegreeValueColor = typedArray.getColor(R.styleable.Compass_degree_value_color, -16777216);
            this.mShowDegreeValue = typedArray.getBoolean(R.styleable.Compass_show_degree_value, false);
            this.mDegreesStep = typedArray.getInt(R.styleable.Compass_degrees_step, 15);
            this.mNeedle = typedArray.getDrawable(R.styleable.Compass_needle);
            typedArray.recycle();
        }
        this.updateLayout();
        this.updateNeedle();
    }

    private void updateLayout() {
        this.mDegreeTextView = (TextView)this.findViewById(R.id.tv_degree);
        final CompassSkeleton compassSkeleton = (CompassSkeleton)this.findViewById(R.id.compass_skeleton);
        compassSkeleton.setDegreesColor(this.mDegreesColor);
        compassSkeleton.setShowOrientationLabel(this.mShowOrientationLabels);
        compassSkeleton.setShowBorder(this.mShowBorder);
        compassSkeleton.setBorderColor(this.mBorderColor);
        try {
            compassSkeleton.setDegreesStep(this.mDegreesStep);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        compassSkeleton.setOrientationLabelsColor(this.mOrientationLabelsColor);
        final View dataLayout = this.findViewById(R.id.data_layout);
        compassSkeleton.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                compassSkeleton.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                int width = compassSkeleton.getMeasuredWidth();
                int needlePadding = (int)((float)width * 0.17f);
                compassSkeleton.setPadding(needlePadding, needlePadding, needlePadding, needlePadding);
                int dataPaddingTop = (int)((float)width * 0.35f);
                dataLayout.setPadding(0, dataPaddingTop, 0, 0);
                float degreeTextSize = (float)width * 0.014f;
                Compass.this.mDegreeTextView.setTextSize(degreeTextSize);
            }
        });
        this.mDegreeTextView.setTextColor(this.mDegreeValueColor);
        if (this.mShowDegreeValue) {
            this.mDegreeTextView.setVisibility(0);
        } else {
            this.mDegreeTextView.setVisibility(8);
        }
    }

    private void updateNeedle() {
        if (this.mNeedle == null) {
            this.mNeedle = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_needle);
        }
        this.mNeedleImageView = (ImageView)this.findViewById(R.id.iv_needle);
        this.mNeedleImageView.setImageDrawable(this.mNeedle);
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.mCompassListener != null) {
            this.mCompassListener.onSensorChanged(event);
        }
        float degree = Math.round(event.values[0]);
        RotateAnimation rotateAnimation = new RotateAnimation(this.mCurrentDegree, -degree, 1, 0.5f, 1, 0.5f);
        rotateAnimation.setDuration(210L);
        rotateAnimation.setFillAfter(true);
        this.mNeedleImageView.startAnimation((Animation)rotateAnimation);
        this.updateTextDirection(this.mCurrentDegree);
        this.mCurrentDegree = -degree;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        if (this.mCompassListener != null) {
            this.mCompassListener.onAccuracyChanged(sensor, accuracy);
        }
    }

    private void updateTextDirection(double degree) {
        double deg = 360.0 + degree;
        DecimalFormat decimalFormat = new DecimalFormat("###.#");
        String value = deg > 0.0 && deg <= 90.0 ? String.format("%s%s NE", String.valueOf(decimalFormat.format(-degree)), DEGREE) : (deg > 90.0 && deg <= 180.0 ? String.format("%s%s ES", String.valueOf(decimalFormat.format(-degree)), DEGREE) : (deg > 180.0 && deg <= 270.0 ? String.format("%s%s SW", String.valueOf(decimalFormat.format(-degree)), DEGREE) : String.format("%s%s WN", String.valueOf(decimalFormat.format(-degree)), DEGREE)));
        this.mDegreeTextView.setText((CharSequence)value);
    }

    public void setListener(CompassListener compassListener) {
        this.mCompassListener = compassListener;
    }
}

