/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ws;

import io.appium.java_client.ws.CanHandleConnects;
import io.appium.java_client.ws.CanHandleDisconnects;
import io.appium.java_client.ws.CanHandleErrors;
import io.appium.java_client.ws.CanHandleMessages;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

public class StringWebSocketClient
extends WebSocketListener
implements CanHandleMessages<String>,
CanHandleErrors,
CanHandleConnects,
CanHandleDisconnects {
    private final List<Consumer<String>> messageHandlers = new CopyOnWriteArrayList<Consumer<String>>();
    private final List<Consumer<Throwable>> errorHandlers = new CopyOnWriteArrayList<Consumer<Throwable>>();
    private final List<Runnable> connectHandlers = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> disconnectHandlers = new CopyOnWriteArrayList<Runnable>();
    private volatile boolean isListening = false;
    private URI endpoint;

    private void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    @Nullable
    public URI getEndpoint() {
        return this.endpoint;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void connect(URI endpoint) {
        if (endpoint.equals(this.getEndpoint()) && this.isListening) {
            return;
        }
        OkHttpClient client = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
        Request request = new Request.Builder().url(endpoint.toString()).build();
        client.newWebSocket(request, (WebSocketListener)this);
        client.dispatcher().executorService().shutdown();
        this.setEndpoint(endpoint);
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.getConnectionHandlers().forEach(Runnable::run);
        this.isListening = true;
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.getDisconnectionHandlers().forEach(Runnable::run);
        this.isListening = false;
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.getErrorHandlers().forEach(x -> x.accept(t));
    }

    public void onMessage(WebSocket webSocket, String text) {
        this.getMessageHandlers().forEach(x -> x.accept(text));
    }

    @Override
    public List<Consumer<String>> getMessageHandlers() {
        return this.messageHandlers;
    }

    @Override
    public List<Consumer<Throwable>> getErrorHandlers() {
        return this.errorHandlers;
    }

    @Override
    public List<Runnable> getConnectionHandlers() {
        return this.connectHandlers;
    }

    @Override
    public List<Runnable> getDisconnectionHandlers() {
        return this.disconnectHandlers;
    }

    public void removeAllHandlers() {
        this.removeMessageHandlers();
        this.removeErrorHandlers();
        this.removeConnectionHandlers();
        this.removeDisconnectionHandlers();
    }
}

