/*
 * Decompiled with CFR 0.152.
 */
package com.github.apetrelli.gwtintegration.spring.security;

import com.github.apetrelli.gwtintegration.requestfactory.server.RequestFactoryServlet;
import com.github.apetrelli.gwtintegration.spring.context.server.requestfactory.CustomServiceLayerDecorator;
import com.github.apetrelli.gwtintegration.spring.security.SpringSecurityLoggingExceptionHandler;
import com.google.web.bindery.requestfactory.server.ExceptionHandler;
import com.google.web.bindery.requestfactory.server.ServiceLayerDecorator;
import com.google.web.bindery.requestfactory.server.SimpleRequestProcessor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;

public class SecureRequestFactoryServlet
extends RequestFactoryServlet {
    private static final long serialVersionUID = 1L;
    private SessionAuthenticationStrategy strategy = new SessionFixationProtectionStrategy();
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();

    public SecureRequestFactoryServlet() {
        this(new SpringSecurityLoggingExceptionHandler(), new ServiceLayerDecorator[]{new CustomServiceLayerDecorator()});
    }

    public SecureRequestFactoryServlet(ExceptionHandler exceptionHandler, ServiceLayerDecorator ... serviceDecorators) {
        super(exceptionHandler, serviceDecorators);
    }

    protected String process(SimpleRequestProcessor processor, HttpServletRequest request, HttpServletResponse response, String jsonRequestString) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean loggedIn = authentication != null && !this.authenticationTrustResolver.isAnonymous(authentication);
        String payload = processor.process(jsonRequestString);
        if (!loggedIn && (authentication = SecurityContextHolder.getContext().getAuthentication()) != null && !this.authenticationTrustResolver.isAnonymous(authentication)) {
            this.strategy.onAuthentication(authentication, request, response);
        }
        return payload;
    }
}

