/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.TableScanIterable;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;

public class IcebergGenerics {
    private IcebergGenerics() {
    }

    public static ScanBuilder read(Table table) {
        return new ScanBuilder(table);
    }

    public static class ScanBuilder {
        private final Table table;
        private Expression where = Expressions.alwaysTrue();
        private List<String> columns = ImmutableList.of((Object)"*");
        private boolean reuseContainers = false;
        private boolean caseSensitive = true;

        public ScanBuilder(Table table) {
            this.table = table;
        }

        public ScanBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public ScanBuilder where(Expression rowFilter) {
            this.where = Expressions.and((Expression)this.where, (Expression)rowFilter);
            return this;
        }

        public ScanBuilder caseInsensitive() {
            this.caseSensitive = false;
            return this;
        }

        public ScanBuilder select(String ... selectedColumns) {
            this.columns = ImmutableList.copyOf((Object[])selectedColumns);
            return this;
        }

        public Iterable<Record> build() {
            return new TableScanIterable(this.table.newScan().filter(this.where).caseSensitive(this.caseSensitive).select(this.columns), this.reuseContainers);
        }
    }
}

