/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class IndexByName
extends TypeUtil.CustomOrderSchemaVisitor<Map<String, Integer>> {
    private static final Joiner DOT = Joiner.on((String)".");
    private final Deque<String> fieldNames = Lists.newLinkedList();
    private final Map<String, Integer> nameToId = Maps.newHashMap();

    @Override
    public Map<String, Integer> schema(Schema schema, Supplier<Map<String, Integer>> structResult) {
        return structResult.get();
    }

    @Override
    public Map<String, Integer> struct(Types.StructType struct, Iterable<Map<String, Integer>> fieldResults) {
        Lists.newArrayList(fieldResults).size();
        return this.nameToId;
    }

    @Override
    public Map<String, Integer> field(Types.NestedField field, Supplier<Map<String, Integer>> fieldResult) {
        this.withName(field.name(), fieldResult::get);
        this.addField(field.name(), field.fieldId());
        return null;
    }

    @Override
    public Map<String, Integer> list(Types.ListType list, Supplier<Map<String, Integer>> elementResult) {
        for (Types.NestedField field : list.fields()) {
            this.addField(field.name(), field.fieldId());
        }
        if (list.elementType().isStructType()) {
            return elementResult.get();
        }
        this.withName("element", elementResult::get);
        return null;
    }

    @Override
    public Map<String, Integer> map(Types.MapType map, Supplier<Map<String, Integer>> keyResult, Supplier<Map<String, Integer>> valueResult) {
        this.withName("key", keyResult::get);
        for (Types.NestedField field : map.fields()) {
            this.addField(field.name(), field.fieldId());
        }
        if (map.valueType().isStructType()) {
            return valueResult.get();
        }
        this.withName("value", valueResult::get);
        return null;
    }

    private <T> T withName(String name, Callable<T> callable) {
        this.fieldNames.push(name);
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.fieldNames.pop();
        }
    }

    private void addField(String name, int fieldId) {
        Integer existingFieldId;
        String fullName = name;
        if (!this.fieldNames.isEmpty()) {
            fullName = DOT.join((Object)DOT.join(this.fieldNames.descendingIterator()), (Object)name, new Object[0]);
        }
        if ((existingFieldId = this.nameToId.put(fullName, fieldId)) != null && !"element".equals(name) && !"value".equals(name)) {
            throw new ValidationException("Invalid schema: multiple fields for name %s: %s and %s", fullName, existingFieldId, fieldId);
        }
    }
}

