/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.jdom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.jdom.JDOMNamespacePointer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;

public class JDOMNamespaceIterator
implements NodeIterator {
    private NodePointer parent;
    private List namespaces;
    private Set prefixes;
    private int position = 0;

    public JDOMNamespaceIterator(NodePointer parent) {
        this.parent = parent;
        Object node = parent.getNode();
        if (node instanceof Document) {
            node = ((Document)node).getRootElement();
        }
        if (node instanceof Element) {
            this.namespaces = new ArrayList();
            this.prefixes = new HashSet();
            this.collectNamespaces((Element)node);
        }
    }

    private void collectNamespaces(Element element) {
        Namespace ns = element.getNamespace();
        if (ns != null && !this.prefixes.contains(ns.getPrefix())) {
            this.namespaces.add(ns);
            this.prefixes.add(ns.getPrefix());
        }
        List others = element.getAdditionalNamespaces();
        for (int i = 0; i < others.size(); ++i) {
            ns = (Namespace)others.get(i);
            if (ns == null || this.prefixes.contains(ns.getPrefix())) continue;
            this.namespaces.add(ns);
            this.prefixes.add(ns.getPrefix());
        }
        Parent elementParent = element.getParent();
        if (elementParent instanceof Element) {
            this.collectNamespaces((Element)elementParent);
        }
    }

    @Override
    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        Namespace ns = (Namespace)this.namespaces.get(index);
        return new JDOMNamespacePointer(this.parent, ns.getPrefix(), ns.getURI());
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean setPosition(int position) {
        if (this.namespaces == null) {
            return false;
        }
        this.position = position;
        return position >= 1 && position <= this.namespaces.size();
    }
}

