/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.Constant;
import org.apache.commons.jxpath.ri.compiler.CoreFunction;
import org.apache.commons.jxpath.ri.compiler.CoreOperationAdd;
import org.apache.commons.jxpath.ri.compiler.CoreOperationAnd;
import org.apache.commons.jxpath.ri.compiler.CoreOperationDivide;
import org.apache.commons.jxpath.ri.compiler.CoreOperationEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationGreaterThan;
import org.apache.commons.jxpath.ri.compiler.CoreOperationGreaterThanOrEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationLessThan;
import org.apache.commons.jxpath.ri.compiler.CoreOperationLessThanOrEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationMod;
import org.apache.commons.jxpath.ri.compiler.CoreOperationMultiply;
import org.apache.commons.jxpath.ri.compiler.CoreOperationNegate;
import org.apache.commons.jxpath.ri.compiler.CoreOperationNotEqual;
import org.apache.commons.jxpath.ri.compiler.CoreOperationOr;
import org.apache.commons.jxpath.ri.compiler.CoreOperationSubtract;
import org.apache.commons.jxpath.ri.compiler.CoreOperationUnion;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.ExpressionPath;
import org.apache.commons.jxpath.ri.compiler.ExtensionFunction;
import org.apache.commons.jxpath.ri.compiler.LocationPath;
import org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.ProcessingInstructionTest;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.compiler.VariableReference;

public class TreeCompiler
implements Compiler {
    private static final QName QNAME_NAME = new QName(null, "name");

    @Override
    public Object number(String value) {
        return new Constant(new Double(value));
    }

    @Override
    public Object literal(String value) {
        return new Constant(value);
    }

    @Override
    public Object qname(String prefix, String name) {
        return new QName(prefix, name);
    }

    @Override
    public Object sum(Object[] arguments) {
        return new CoreOperationAdd(this.toExpressionArray(arguments));
    }

    @Override
    public Object minus(Object left, Object right) {
        return new CoreOperationSubtract((Expression)left, (Expression)right);
    }

    @Override
    public Object multiply(Object left, Object right) {
        return new CoreOperationMultiply((Expression)left, (Expression)right);
    }

    @Override
    public Object divide(Object left, Object right) {
        return new CoreOperationDivide((Expression)left, (Expression)right);
    }

    @Override
    public Object mod(Object left, Object right) {
        return new CoreOperationMod((Expression)left, (Expression)right);
    }

    @Override
    public Object lessThan(Object left, Object right) {
        return new CoreOperationLessThan((Expression)left, (Expression)right);
    }

    @Override
    public Object lessThanOrEqual(Object left, Object right) {
        return new CoreOperationLessThanOrEqual((Expression)left, (Expression)right);
    }

    @Override
    public Object greaterThan(Object left, Object right) {
        return new CoreOperationGreaterThan((Expression)left, (Expression)right);
    }

    @Override
    public Object greaterThanOrEqual(Object left, Object right) {
        return new CoreOperationGreaterThanOrEqual((Expression)left, (Expression)right);
    }

    @Override
    public Object equal(Object left, Object right) {
        return this.isNameAttributeTest((Expression)left) ? new NameAttributeTest((Expression)left, (Expression)right) : new CoreOperationEqual((Expression)left, (Expression)right);
    }

    @Override
    public Object notEqual(Object left, Object right) {
        return new CoreOperationNotEqual((Expression)left, (Expression)right);
    }

    @Override
    public Object minus(Object argument) {
        return new CoreOperationNegate((Expression)argument);
    }

    @Override
    public Object variableReference(Object qName) {
        return new VariableReference((QName)qName);
    }

    @Override
    public Object function(int code, Object[] args) {
        return new CoreFunction(code, this.toExpressionArray(args));
    }

    @Override
    public Object function(Object name, Object[] args) {
        return new ExtensionFunction((QName)name, this.toExpressionArray(args));
    }

    @Override
    public Object and(Object[] arguments) {
        return new CoreOperationAnd(this.toExpressionArray(arguments));
    }

    @Override
    public Object or(Object[] arguments) {
        return new CoreOperationOr(this.toExpressionArray(arguments));
    }

    @Override
    public Object union(Object[] arguments) {
        return new CoreOperationUnion(this.toExpressionArray(arguments));
    }

    @Override
    public Object locationPath(boolean absolute, Object[] steps) {
        return new LocationPath(absolute, this.toStepArray(steps));
    }

    @Override
    public Object expressionPath(Object expression, Object[] predicates, Object[] steps) {
        return new ExpressionPath((Expression)expression, this.toExpressionArray(predicates), this.toStepArray(steps));
    }

    @Override
    public Object nodeNameTest(Object qname) {
        return new NodeNameTest((QName)qname);
    }

    @Override
    public Object nodeTypeTest(int nodeType) {
        return new NodeTypeTest(nodeType);
    }

    @Override
    public Object processingInstructionTest(String instruction) {
        return new ProcessingInstructionTest(instruction);
    }

    @Override
    public Object step(int axis, Object nodeTest, Object[] predicates) {
        return new Step(axis, (NodeTest)nodeTest, this.toExpressionArray(predicates));
    }

    private Expression[] toExpressionArray(Object[] array) {
        Expression[] expArray = null;
        if (array != null) {
            expArray = new Expression[array.length];
            for (int i = 0; i < expArray.length; ++i) {
                expArray[i] = (Expression)array[i];
            }
        }
        return expArray;
    }

    private Step[] toStepArray(Object[] array) {
        Step[] stepArray = null;
        if (array != null) {
            stepArray = new Step[array.length];
            for (int i = 0; i < stepArray.length; ++i) {
                stepArray[i] = (Step)array[i];
            }
        }
        return stepArray;
    }

    private boolean isNameAttributeTest(Expression arg) {
        if (!(arg instanceof LocationPath)) {
            return false;
        }
        Step[] steps = ((LocationPath)arg).getSteps();
        if (steps.length != 1) {
            return false;
        }
        if (steps[0].getAxis() != 5) {
            return false;
        }
        NodeTest test = steps[0].getNodeTest();
        if (!(test instanceof NodeNameTest)) {
            return false;
        }
        return ((NodeNameTest)test).getNodeName().equals(QNAME_NAME);
    }
}

