/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.jxpath.Container;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.xml.DocumentContainer;

public class XMLDocumentContainer
implements Container {
    private DocumentContainer delegate;
    private Object document;
    private URL xmlURL;
    private Source source;

    public XMLDocumentContainer(URL xmlURL) {
        this.xmlURL = xmlURL;
        this.delegate = new DocumentContainer(xmlURL);
    }

    public XMLDocumentContainer(Source source) {
        this.source = source;
        if (source == null) {
            throw new RuntimeException("Source is null");
        }
    }

    @Override
    public Object getValue() {
        if (this.document == null) {
            try {
                if (this.source != null) {
                    DOMResult result = new DOMResult();
                    Transformer trans = TransformerFactory.newInstance().newTransformer();
                    trans.transform(this.source, result);
                    this.document = result.getNode();
                } else {
                    this.document = this.delegate.getValue();
                }
            }
            catch (Exception ex) {
                throw new JXPathException("Cannot read XML from: " + (this.xmlURL != null ? this.xmlURL.toString() : (this.source != null ? this.source.getSystemId() : "<<undefined source>>")), ex);
            }
        }
        return this.document;
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }
}

