/*
 * Decompiled with CFR 0.152.
 */
package com.github.anzewei.parallaxbacklayout.transform;

import android.graphics.Canvas;
import android.view.View;
import com.github.anzewei.parallaxbacklayout.transform.ITransform;
import com.github.anzewei.parallaxbacklayout.widget.ParallaxBackLayout;

public class ParallaxTransform
implements ITransform {
    @Override
    public void transform(Canvas canvas, ParallaxBackLayout parallaxBackLayout, View child) {
        int mEdgeFlag = parallaxBackLayout.getEdgeFlag();
        int width = parallaxBackLayout.getWidth();
        int height = parallaxBackLayout.getHeight();
        int leftBar = parallaxBackLayout.getSystemLeft();
        int topBar = parallaxBackLayout.getSystemTop();
        if (mEdgeFlag == 1) {
            int left = (child.getLeft() - width) / 2;
            canvas.translate((float)left, 0.0f);
            canvas.clipRect(0, 0, left + width, child.getBottom());
        } else if (mEdgeFlag == 4) {
            int top = (child.getTop() - child.getHeight()) / 2;
            canvas.translate(0.0f, (float)top);
            canvas.clipRect(0, 0, child.getRight(), child.getHeight() + top + topBar);
        } else if (mEdgeFlag == 2) {
            int left = (child.getLeft() + child.getWidth() - leftBar) / 2;
            canvas.translate((float)left, 0.0f);
            canvas.clipRect(left + leftBar, 0, width, child.getBottom());
        } else if (mEdgeFlag == 8) {
            int top = (child.getBottom() - topBar) / 2;
            canvas.translate(0.0f, (float)top);
            canvas.clipRect(0, top + topBar, child.getRight(), height);
        }
    }
}

