/*
 * Decompiled with CFR 0.152.
 */
package com.guanaj.easyswipemenulibrary;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.Scroller;
import com.guanaj.easyswipemenulibrary.R;
import com.guanaj.easyswipemenulibrary.State;
import java.util.ArrayList;

public class EasySwipeMenuLayout
extends ViewGroup {
    private static final String TAG = "EasySwipeMenuLayout";
    private final ArrayList<View> mMatchParentChildren = new ArrayList(1);
    private int mLeftViewResID;
    private int mRightViewResID;
    private int mContentViewResID;
    private View mLeftView;
    private View mRightView;
    private View mContentView;
    private ViewGroup.MarginLayoutParams mContentViewLp;
    private boolean isSwipeing;
    private PointF mLastP;
    private PointF mFirstP;
    private float mFraction = 0.3f;
    private boolean mCanLeftSwipe = true;
    private boolean mCanRightSwipe = true;
    private int mScaledTouchSlop;
    private Scroller mScroller;
    private static EasySwipeMenuLayout mViewCache;
    private static State mStateCache;
    private float distanceX;
    private float finalyDistanceX;
    State result;

    public EasySwipeMenuLayout(Context context) {
        this(context, null);
    }

    public EasySwipeMenuLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EasySwipeMenuLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mScaledTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mScroller = new Scroller(context);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EasySwipeMenuLayout, defStyleAttr, 0);
        try {
            int indexCount = typedArray.getIndexCount();
            for (int i = 0; i < indexCount; ++i) {
                int attr = typedArray.getIndex(i);
                if (attr == R.styleable.EasySwipeMenuLayout_leftMenuView) {
                    this.mLeftViewResID = typedArray.getResourceId(R.styleable.EasySwipeMenuLayout_leftMenuView, -1);
                    continue;
                }
                if (attr == R.styleable.EasySwipeMenuLayout_rightMenuView) {
                    this.mRightViewResID = typedArray.getResourceId(R.styleable.EasySwipeMenuLayout_rightMenuView, -1);
                    continue;
                }
                if (attr == R.styleable.EasySwipeMenuLayout_contentView) {
                    this.mContentViewResID = typedArray.getResourceId(R.styleable.EasySwipeMenuLayout_contentView, -1);
                    continue;
                }
                if (attr == R.styleable.EasySwipeMenuLayout_canLeftSwipe) {
                    this.mCanLeftSwipe = typedArray.getBoolean(R.styleable.EasySwipeMenuLayout_canLeftSwipe, true);
                    continue;
                }
                if (attr == R.styleable.EasySwipeMenuLayout_canRightSwipe) {
                    this.mCanRightSwipe = typedArray.getBoolean(R.styleable.EasySwipeMenuLayout_canRightSwipe, true);
                    continue;
                }
                if (attr != R.styleable.EasySwipeMenuLayout_fraction) continue;
                this.mFraction = typedArray.getFloat(R.styleable.EasySwipeMenuLayout_fraction, 0.5f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        ViewGroup.MarginLayoutParams lp;
        View child;
        int i;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setClickable(true);
        int count = this.getChildCount();
        boolean measureMatchParentChildren = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000 || View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        this.mMatchParentChildren.clear();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = EasySwipeMenuLayout.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            if (!measureMatchParentChildren || lp.width != -1 && lp.height != -1) continue;
            this.mMatchParentChildren.add(child);
        }
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(EasySwipeMenuLayout.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)childState), EasySwipeMenuLayout.resolveSizeAndState((int)maxHeight, (int)heightMeasureSpec, (int)(childState << 16)));
        count = this.mMatchParentChildren.size();
        if (count > 1) {
            for (i = 0; i < count; ++i) {
                int childHeightMeasureSpec;
                int childWidthMeasureSpec;
                child = this.mMatchParentChildren.get(i);
                lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                if (lp.width == -1) {
                    int width = Math.max(0, this.getMeasuredWidth() - lp.leftMargin - lp.rightMargin);
                    childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
                } else {
                    childWidthMeasureSpec = EasySwipeMenuLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(lp.leftMargin + lp.rightMargin), (int)lp.width);
                }
                if (lp.height == -1) {
                    int height = Math.max(0, this.getMeasuredHeight() - lp.topMargin - lp.bottomMargin);
                    childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
                } else {
                    childHeightMeasureSpec = EasySwipeMenuLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(lp.topMargin + lp.bottomMargin), (int)lp.height);
                }
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int lBottom;
        int lRight;
        int lLeft;
        int lTop;
        int count = this.getChildCount();
        int left = 0 + this.getPaddingLeft();
        int right = 0 + this.getPaddingLeft();
        int top = 0 + this.getPaddingTop();
        int bottom = 0 + this.getPaddingTop();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (this.mLeftView == null && child.getId() == this.mLeftViewResID) {
                this.mLeftView = child;
                this.mLeftView.setClickable(true);
                continue;
            }
            if (this.mRightView == null && child.getId() == this.mRightViewResID) {
                this.mRightView = child;
                this.mRightView.setClickable(true);
                continue;
            }
            if (this.mContentView != null || child.getId() != this.mContentViewResID) continue;
            this.mContentView = child;
            this.mContentView.setClickable(true);
        }
        int cRight = 0;
        if (this.mContentView != null) {
            this.mContentViewLp = (ViewGroup.MarginLayoutParams)this.mContentView.getLayoutParams();
            int cTop = top + this.mContentViewLp.topMargin;
            int cLeft = left + this.mContentViewLp.leftMargin;
            cRight = left + this.mContentViewLp.leftMargin + this.mContentView.getMeasuredWidth();
            int cBottom = cTop + this.mContentView.getMeasuredHeight();
            this.mContentView.layout(cLeft, cTop, cRight, cBottom);
        }
        if (this.mLeftView != null) {
            ViewGroup.MarginLayoutParams leftViewLp = (ViewGroup.MarginLayoutParams)this.mLeftView.getLayoutParams();
            lTop = top + leftViewLp.topMargin;
            lLeft = 0 - this.mLeftView.getMeasuredWidth() + leftViewLp.leftMargin + leftViewLp.rightMargin;
            lRight = 0 - leftViewLp.rightMargin;
            lBottom = lTop + this.mLeftView.getMeasuredHeight();
            this.mLeftView.layout(lLeft, lTop, lRight, lBottom);
        }
        if (this.mRightView != null) {
            ViewGroup.MarginLayoutParams rightViewLp = (ViewGroup.MarginLayoutParams)this.mRightView.getLayoutParams();
            lTop = top + rightViewLp.topMargin;
            lLeft = this.mContentView.getRight() + this.mContentViewLp.rightMargin + rightViewLp.leftMargin;
            lRight = lLeft + this.mRightView.getMeasuredWidth();
            lBottom = lTop + this.mRightView.getMeasuredHeight();
            this.mRightView.layout(lLeft, lTop, lRight, lBottom);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.isSwipeing = false;
                if (this.mLastP == null) {
                    this.mLastP = new PointF();
                }
                this.mLastP.set(ev.getRawX(), ev.getRawY());
                if (this.mFirstP == null) {
                    this.mFirstP = new PointF();
                }
                this.mFirstP.set(ev.getRawX(), ev.getRawY());
                if (mViewCache == null) break;
                if (mViewCache != this) {
                    mViewCache.handlerSwipeMenu(State.CLOSE);
                }
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                float distanceX = this.mLastP.x - ev.getRawX();
                float distanceY = this.mLastP.y - ev.getRawY();
                if (Math.abs(distanceY) > (float)this.mScaledTouchSlop && Math.abs(distanceY) > Math.abs(distanceX)) break;
                this.scrollBy((int)distanceX, 0);
                if (this.getScrollX() < 0) {
                    if (!this.mCanRightSwipe || this.mLeftView == null) {
                        this.scrollTo(0, 0);
                    } else if (this.getScrollX() < this.mLeftView.getLeft()) {
                        this.scrollTo(this.mLeftView.getLeft(), 0);
                    }
                } else if (this.getScrollX() > 0) {
                    if (!this.mCanLeftSwipe || this.mRightView == null) {
                        this.scrollTo(0, 0);
                    } else if (this.getScrollX() > this.mRightView.getRight() - this.mContentView.getRight() - this.mContentViewLp.rightMargin) {
                        this.scrollTo(this.mRightView.getRight() - this.mContentView.getRight() - this.mContentViewLp.rightMargin, 0);
                    }
                }
                if (Math.abs(distanceX) > (float)this.mScaledTouchSlop) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                this.mLastP.set(ev.getRawX(), ev.getRawY());
                break;
            }
            case 1: 
            case 3: {
                this.finalyDistanceX = this.mFirstP.x - ev.getRawX();
                if (Math.abs(this.finalyDistanceX) > (float)this.mScaledTouchSlop) {
                    this.isSwipeing = true;
                }
                this.result = this.isShouldOpen(this.getScrollX());
                this.handlerSwipeMenu(this.result);
                break;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                break;
            }
            case 2: {
                if (!(Math.abs(this.finalyDistanceX) > (float)this.mScaledTouchSlop)) break;
                return true;
            }
            case 1: 
            case 3: {
                if (!this.isSwipeing) break;
                this.isSwipeing = false;
                this.finalyDistanceX = 0.0f;
                return true;
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    private void handlerSwipeMenu(State result) {
        if (result == State.LEFTOPEN) {
            this.mScroller.startScroll(this.getScrollX(), 0, this.mLeftView.getLeft() - this.getScrollX(), 0);
            mViewCache = this;
            mStateCache = result;
        } else if (result == State.RIGHTOPEN) {
            mViewCache = this;
            this.mScroller.startScroll(this.getScrollX(), 0, this.mRightView.getRight() - this.mContentView.getRight() - this.mContentViewLp.rightMargin - this.getScrollX(), 0);
            mStateCache = result;
        } else {
            this.mScroller.startScroll(this.getScrollX(), 0, -this.getScrollX(), 0);
            mViewCache = null;
            mStateCache = null;
        }
        this.invalidate();
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.scrollTo(this.mScroller.getCurrX(), this.mScroller.getCurrY());
            this.invalidate();
        }
    }

    private State isShouldOpen(int scrollX) {
        if (!((float)this.mScaledTouchSlop < Math.abs(this.finalyDistanceX))) {
            return mStateCache;
        }
        Log.i((String)TAG, (String)(">>>finalyDistanceX:" + this.finalyDistanceX));
        if (this.finalyDistanceX < 0.0f) {
            if (this.getScrollX() < 0 && this.mLeftView != null && Math.abs((float)this.mLeftView.getWidth() * this.mFraction) < (float)Math.abs(this.getScrollX())) {
                return State.LEFTOPEN;
            }
            if (this.getScrollX() > 0 && this.mRightView != null) {
                return State.CLOSE;
            }
        } else if (this.finalyDistanceX > 0.0f) {
            if (this.getScrollX() > 0 && this.mRightView != null && Math.abs((float)this.mRightView.getWidth() * this.mFraction) < (float)Math.abs(this.getScrollX())) {
                return State.RIGHTOPEN;
            }
            if (this.getScrollX() < 0 && this.mLeftView != null) {
                return State.CLOSE;
            }
        }
        return State.CLOSE;
    }

    protected void onDetachedFromWindow() {
        if (this == mViewCache) {
            mViewCache.handlerSwipeMenu(State.CLOSE);
        }
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this == mViewCache) {
            mViewCache.handlerSwipeMenu(mStateCache);
        }
    }

    public void resetStatus() {
        if (mViewCache != null && mStateCache != null && mStateCache != State.CLOSE && this.mScroller != null) {
            this.mScroller.startScroll(mViewCache.getScrollX(), 0, -mViewCache.getScrollX(), 0);
            mViewCache.invalidate();
            mViewCache = null;
            mStateCache = null;
        }
    }

    public float getFraction() {
        return this.mFraction;
    }

    public void setFraction(float mFraction) {
        this.mFraction = mFraction;
    }

    public boolean isCanLeftSwipe() {
        return this.mCanLeftSwipe;
    }

    public void setCanLeftSwipe(boolean mCanLeftSwipe) {
        this.mCanLeftSwipe = mCanLeftSwipe;
    }

    public boolean isCanRightSwipe() {
        return this.mCanRightSwipe;
    }

    public void setCanRightSwipe(boolean mCanRightSwipe) {
        this.mCanRightSwipe = mCanRightSwipe;
    }

    public static EasySwipeMenuLayout getViewCache() {
        return mViewCache;
    }

    public static State getStateCache() {
        return mStateCache;
    }

    private boolean isLeftToRight() {
        return this.distanceX < 0.0f;
    }
}

