/*
 * Decompiled with CFR 0.152.
 */
package com.anthonynsimon.url;

import com.anthonynsimon.url.DefaultURLParser;
import com.anthonynsimon.url.PathResolver;
import com.anthonynsimon.url.PercentEncoder;
import com.anthonynsimon.url.URLBuilder;
import com.anthonynsimon.url.URLParser;
import com.anthonynsimon.url.URLPart;
import com.anthonynsimon.url.exceptions.InvalidURLReferenceException;
import com.anthonynsimon.url.exceptions.MalformedURLException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class URL
implements Serializable {
    private static final long serialVersionUID = 80443L;
    private static final transient URLParser URL_PARSER = new DefaultURLParser();
    private final String scheme;
    private final String username;
    private final String password;
    private final String host;
    private final String hostname;
    private final Integer port;
    private final String path;
    private final String rawPath;
    private final String query;
    private final String fragment;
    private final String opaque;
    private transient Map<String, Collection<String>> parsedQueryPairs;
    private transient String stringRepresentation;

    URL(String scheme, String username, String password, String host, String path, String query, String fragment, String opaque) {
        this.scheme = URL.mapToNullIfEmpty(scheme);
        this.username = URL.mapToNullIfEmpty(username);
        this.password = URL.mapToNullIfEmpty(password);
        this.host = URL.mapToNullIfEmpty(host);
        this.hostname = URL.extractHostname(host);
        this.port = URL.extractPort(host);
        this.path = URL.mapToNullIfEmpty(path);
        this.rawPath = null;
        this.query = URL.mapToNullIfEmpty(query);
        this.fragment = URL.mapToNullIfEmpty(fragment);
        this.opaque = URL.mapToNullIfEmpty(opaque);
    }

    URL(String scheme, String username, String password, String host, String path, String rawPath, String query, String fragment, String opaque) {
        this.scheme = URL.mapToNullIfEmpty(scheme);
        this.username = URL.mapToNullIfEmpty(username);
        this.password = URL.mapToNullIfEmpty(password);
        this.host = URL.mapToNullIfEmpty(host);
        this.hostname = URL.extractHostname(host);
        this.port = URL.extractPort(host);
        this.path = URL.mapToNullIfEmpty(path);
        this.rawPath = URL.mapToNullIfEmpty(rawPath);
        this.query = URL.mapToNullIfEmpty(query);
        this.fragment = URL.mapToNullIfEmpty(fragment);
        this.opaque = URL.mapToNullIfEmpty(opaque);
    }

    URL(String scheme, String username, String password, String hostname, Integer port, String path, String rawPath, String query, String fragment, String opaque) {
        this.scheme = URL.mapToNullIfEmpty(scheme);
        this.username = URL.mapToNullIfEmpty(username);
        this.password = URL.mapToNullIfEmpty(password);
        this.host = URL.mergeHostPortIfSet(hostname, port);
        this.hostname = URL.mapToNullIfEmpty(hostname);
        this.port = port;
        this.path = URL.mapToNullIfEmpty(path);
        this.rawPath = URL.mapToNullIfEmpty(rawPath);
        this.query = URL.mapToNullIfEmpty(query);
        this.fragment = URL.mapToNullIfEmpty(fragment);
        this.opaque = URL.mapToNullIfEmpty(opaque);
    }

    public static URL parse(String url) throws MalformedURLException {
        return URL_PARSER.parse(url);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public java.net.URL toJavaURL() throws java.net.MalformedURLException {
        return new java.net.URL(this.toString());
    }

    public URI toJavaURI() throws URISyntaxException {
        return new URI(this.toString());
    }

    public Map<String, Collection<String>> getQueryPairs() {
        if (this.parsedQueryPairs != null) {
            return this.parsedQueryPairs;
        }
        this.parsedQueryPairs = new HashMap<String, Collection<String>>();
        if (!this.nullOrEmpty(this.query) && !this.query.equals("?")) {
            String[] pairs;
            for (String pair : pairs = this.query.split("&")) {
                String[] parts = pair.split("=");
                if (parts.length <= 0 || parts[0].isEmpty()) continue;
                Collection existing = this.parsedQueryPairs.getOrDefault(parts[0], new ArrayList());
                if (parts.length == 2) {
                    existing.add(parts[1]);
                }
                this.parsedQueryPairs.put(parts[0], existing);
            }
        }
        return this.parsedQueryPairs;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof URL)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public String toString() {
        if (this.stringRepresentation != null) {
            return this.stringRepresentation;
        }
        boolean hasScheme = !this.nullOrEmpty(this.scheme);
        StringBuffer sb = new StringBuffer();
        if (hasScheme) {
            sb.append(this.scheme);
            sb.append(":");
        }
        if (!this.nullOrEmpty(this.opaque)) {
            sb.append(this.opaque);
        } else {
            if (hasScheme || !this.nullOrEmpty(this.host)) {
                if (hasScheme) {
                    sb.append("//");
                }
                if (!this.nullOrEmpty(this.username)) {
                    sb.append(PercentEncoder.encode(this.username, URLPart.CREDENTIALS));
                    if (!this.nullOrEmpty(this.password)) {
                        sb.append(":");
                        sb.append(PercentEncoder.encode(this.password, URLPart.CREDENTIALS));
                    }
                    sb.append("@");
                }
                if (!this.nullOrEmpty(this.host)) {
                    sb.append(PercentEncoder.encode(this.host, URLPart.HOST));
                }
            }
            if (!this.nullOrEmpty(this.rawPath)) {
                sb.append(this.rawPath);
            } else if (!this.nullOrEmpty(this.path)) {
                if (this.path.indexOf(47) != 0 && !"*".equals(this.path)) {
                    sb.append("/");
                }
                sb.append(this.path);
            }
        }
        if (!this.nullOrEmpty(this.query)) {
            sb.append("?");
            if (!"?".equals(this.query)) {
                sb.append(this.query);
            }
        }
        if (!this.nullOrEmpty(this.fragment)) {
            sb.append("#");
            sb.append(this.fragment);
        }
        this.stringRepresentation = sb.toString();
        return this.stringRepresentation;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private boolean nullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public boolean isOpaque() {
        return !this.nullOrEmpty(this.opaque);
    }

    public boolean isAbsolute() {
        return !this.nullOrEmpty(this.scheme);
    }

    public URL resolveReference(String ref) throws MalformedURLException, InvalidURLReferenceException {
        URL url = URL_PARSER.parse(ref);
        return this.resolveReference(url);
    }

    public URL resolveReference(URL ref) throws InvalidURLReferenceException {
        if (!this.isAbsolute()) {
            throw new InvalidURLReferenceException("base url is not absolute");
        }
        if (ref == null) {
            throw new InvalidURLReferenceException("reference url is null");
        }
        URLBuilder builder = new URLBuilder().setScheme(ref.getScheme()).setUsername(ref.getUsername()).setPassword(ref.getPassword()).setHost(ref.getHost()).setPath(ref.getPath()).setQuery(ref.getQuery()).setFragment(ref.getFragment()).setOpaque(ref.getOpaque());
        if (!ref.isAbsolute()) {
            builder.setScheme(this.scheme);
        }
        if (!this.nullOrEmpty(ref.scheme) || !this.nullOrEmpty(ref.host)) {
            builder.setPath(PathResolver.resolve(ref.path, ""));
            return builder.build();
        }
        if (ref.isOpaque() || this.isOpaque()) {
            return builder.build();
        }
        return builder.setHost(this.host).setUsername(this.username).setPassword(this.password).setPath(PathResolver.resolve(this.path, ref.path)).build();
    }

    private static String mapToNullIfEmpty(String str) {
        return str != null && !str.isEmpty() ? str : null;
    }

    private static String mergeHostPortIfSet(String hostname, Integer port) {
        StringBuilder sb = new StringBuilder();
        boolean exists = false;
        if (hostname != null) {
            sb.append(hostname);
            exists = true;
        }
        if (port != null) {
            sb.append(":");
            sb.append(port);
            exists = true;
        }
        if (exists) {
            return sb.toString();
        }
        return null;
    }

    private static String extractHostname(String host) {
        if (host != null) {
            int separator = host.lastIndexOf(":");
            if (separator > -1) {
                return host.substring(0, separator);
            }
            return host;
        }
        return null;
    }

    private static Integer extractPort(String host) {
        String part;
        int separator;
        if (host != null && (separator = host.lastIndexOf(":")) > -1 && (part = host.substring(separator + 1, host.length())) != null && part != "") {
            try {
                return Integer.parseInt(part);
            }
            catch (NumberFormatException exception) {
                return null;
            }
        }
        return null;
    }
}

