/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core.entity.enums;

import com.github.jaemon.dinger.bytetalk.FeiShuDefinitionGenerator;
import com.github.jaemon.dinger.core.DingerDefinitionGenerator;
import com.github.jaemon.dinger.core.entity.enums.DingerType;
import com.github.jaemon.dinger.core.entity.enums.MessageMainType;
import com.github.jaemon.dinger.core.entity.enums.MessageSubType;
import com.github.jaemon.dinger.dingtalk.DingTalkDefinitionGenerator;
import com.github.jaemon.dinger.wetalk.WeTalkDefinitionGenerator;

public enum DingerDefinitionType {
    DINGTALK_XML_TEXT(DingerType.DINGTALK, MessageMainType.XML, MessageSubType.TEXT, DingTalkDefinitionGenerator.XmlText.class),
    DINGTALK_XML_MARKDOWN(DingerType.DINGTALK, MessageMainType.XML, MessageSubType.MARKDOWN, DingTalkDefinitionGenerator.XmlMarkdown.class),
    DINGTALK_ANNOTATION_TEXT(DingerType.DINGTALK, MessageMainType.ANNOTATION, MessageSubType.TEXT, DingTalkDefinitionGenerator.AnotationText.class),
    DINGTALK_ANNOTATION_MARKDOWN(DingerType.DINGTALK, MessageMainType.ANNOTATION, MessageSubType.MARKDOWN, DingTalkDefinitionGenerator.AnnotationMarkdown.class),
    DINGTALK_XML_IMAGETEXT(DingerType.DINGTALK, MessageMainType.XML, MessageSubType.IMAGETEXT, DingTalkDefinitionGenerator.XmlImageText.class),
    DINGTALK_ANNOTATION_IMAGETEXT(DingerType.DINGTALK, MessageMainType.ANNOTATION, MessageSubType.IMAGETEXT, DingTalkDefinitionGenerator.AnnotationImageText.class),
    DINGTALK_XML_LINK(DingerType.DINGTALK, MessageMainType.XML, MessageSubType.LINK, DingTalkDefinitionGenerator.XmlLink.class),
    DINGTALK_ANNOTATION_LINK(DingerType.DINGTALK, MessageMainType.ANNOTATION, MessageSubType.LINK, DingTalkDefinitionGenerator.AnnotationLink.class),
    WETALK_XML_TEXT(DingerType.WETALK, MessageMainType.XML, MessageSubType.TEXT, WeTalkDefinitionGenerator.XmlText.class),
    WETALK_XML_MARKDOWN(DingerType.WETALK, MessageMainType.XML, MessageSubType.MARKDOWN, WeTalkDefinitionGenerator.XmlMarkdown.class),
    WETALK_ANNOTATION_TEXT(DingerType.WETALK, MessageMainType.ANNOTATION, MessageSubType.TEXT, WeTalkDefinitionGenerator.AnnotationText.class),
    WETALK_ANNOTATION_MARKDOWN(DingerType.WETALK, MessageMainType.ANNOTATION, MessageSubType.MARKDOWN, WeTalkDefinitionGenerator.AnnotationMarkDown.class),
    WETALK_XML_IMAGETEXT(DingerType.WETALK, MessageMainType.XML, MessageSubType.IMAGETEXT, WeTalkDefinitionGenerator.XmlImageText.class),
    WETALK_ANNOTATION_IMAGETEXT(DingerType.WETALK, MessageMainType.ANNOTATION, MessageSubType.IMAGETEXT, WeTalkDefinitionGenerator.AnnotationImageText.class),
    BYTETALK_XML_TEXT(DingerType.BYTETALK, MessageMainType.XML, MessageSubType.TEXT, FeiShuDefinitionGenerator.XmlText.class),
    BYTETALK_ANNOTATION_TEXT(DingerType.BYTETALK, MessageMainType.ANNOTATION, MessageSubType.TEXT, FeiShuDefinitionGenerator.AnnotationText.class);

    public static final DingerDefinitionType[] dingerDefinitionTypes;
    private DingerType dingerType;
    private MessageMainType messageMainType;
    private MessageSubType messageSubType;
    private Class<? extends DingerDefinitionGenerator> dingerDefinitionGenerator;

    private DingerDefinitionType(DingerType dingerType, MessageMainType messageMainType, MessageSubType messageSubType, Class<? extends DingerDefinitionGenerator> dingerDefinitionGenerator) {
        this.dingerType = dingerType;
        this.messageMainType = messageMainType;
        this.messageSubType = messageSubType;
        this.dingerDefinitionGenerator = dingerDefinitionGenerator;
    }

    public DingerType dingerType() {
        return this.dingerType;
    }

    public MessageMainType messageMainType() {
        return this.messageMainType;
    }

    public MessageSubType messageSubType() {
        return this.messageSubType;
    }

    public Class<? extends DingerDefinitionGenerator> dingerDefinitionGenerator() {
        return this.dingerDefinitionGenerator;
    }

    static {
        for (DingerDefinitionType dingTalkMessageType : dingerDefinitionTypes = DingerDefinitionType.values()) {
            try {
                dingTalkMessageType.dingerDefinitionGenerator().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
    }
}

