/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaemon.dinger.core;

import com.github.jaemon.dinger.core.AbstractDingerDefinitionResolver;
import com.github.jaemon.dinger.core.DingerConfig;
import com.github.jaemon.dinger.core.annatations.DingerImageText;
import com.github.jaemon.dinger.core.annatations.DingerLink;
import com.github.jaemon.dinger.core.annatations.DingerMarkdown;
import com.github.jaemon.dinger.core.annatations.DingerText;
import com.github.jaemon.dinger.core.entity.DingerMethod;
import com.github.jaemon.dinger.core.entity.enums.ExceptionEnum;
import com.github.jaemon.dinger.core.entity.enums.MessageMainType;
import com.github.jaemon.dinger.core.entity.enums.MessageSubType;
import com.github.jaemon.dinger.exception.DingerException;
import com.github.jaemon.dinger.utils.DingerUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationDingerDefinitionResolver
extends AbstractDingerDefinitionResolver<List<Class<?>>> {
    private static final Logger log = LoggerFactory.getLogger(AnnotationDingerDefinitionResolver.class);

    @Override
    public void resolver(List<Class<?>> dingerClasses) {
        for (Class<?> dingerClass : dingerClasses) {
            Method[] methods;
            DingerConfig dingerConfiguration = this.dingerConfiguration(dingerClass);
            String namespace = dingerClass.getName();
            for (Method method : methods = dingerClass.getMethods()) {
                MessageSubType messageSubType;
                Annotation source;
                String dingerName = namespace + "." + method.getName();
                String dingerDefinitionKey = (Object)((Object)MessageMainType.ANNOTATION) + ".";
                int[] paramTypes = null;
                if (method.isAnnotationPresent(DingerText.class)) {
                    source = method.getAnnotation(DingerText.class);
                    messageSubType = MessageSubType.TEXT;
                } else if (method.isAnnotationPresent(DingerMarkdown.class)) {
                    source = method.getAnnotation(DingerMarkdown.class);
                    messageSubType = MessageSubType.MARKDOWN;
                } else if (method.isAnnotationPresent(DingerImageText.class)) {
                    paramTypes = DingerUtils.methodParamsGenericType(method, DingerImageText.clazz);
                    if (paramTypes.length != 1) {
                        throw new DingerException(ExceptionEnum.IMAGETEXT_METHOD_PARAM_EXCEPTION, dingerName);
                    }
                    source = method.getAnnotation(DingerImageText.class);
                    messageSubType = MessageSubType.IMAGETEXT;
                } else if (method.isAnnotationPresent(DingerLink.class)) {
                    paramTypes = DingerUtils.methodParamsType(method, DingerLink.clazz);
                    if (paramTypes.length != 1) {
                        throw new DingerException(ExceptionEnum.LINK_METHOD_PARAM_EXCEPTION, dingerName);
                    }
                    source = method.getAnnotation(DingerLink.class);
                    messageSubType = MessageSubType.LINK;
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("register annotation dingerDefinition and skip method={}(possible use xml definition).", (Object)dingerName);
                    continue;
                }
                this.registerDingerDefinition(dingerName, source, dingerDefinitionKey + (Object)((Object)messageSubType), dingerConfiguration, new DingerMethod(dingerName, this.parameterNameDiscoverer.getParameterNames(method), paramTypes));
            }
        }
    }
}

