/*
 * Decompiled with CFR 0.152.
 */
package com.github.ansell.shp;

import com.fasterxml.jackson.databind.SequenceWriter;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.github.ansell.csv.sum.CSVSummariser;
import com.github.ansell.csv.util.CSVUtil;
import com.github.ansell.shp.SHPUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.geotools.data.FeatureSource;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class SHPDump {
    public static void main(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        AbstractOptionSpec help = parser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec input = parser.accepts("input").withRequiredArg().ofType(File.class).required().describedAs("The input SHP file");
        ArgumentAcceptingOptionSpec output = parser.accepts("output").withRequiredArg().ofType(File.class).required().describedAs("The output directory to use for debugging files");
        ArgumentAcceptingOptionSpec outputPrefix = parser.accepts("prefix").withRequiredArg().ofType(String.class).defaultsTo((Object)"shp-debug", (Object[])new String[0]).describedAs("The output prefix to use for debugging files");
        ArgumentAcceptingOptionSpec resolution = parser.accepts("resolution").withRequiredArg().ofType(Integer.class).defaultsTo((Object)2048, (Object[])new Integer[0]).describedAs("The output image file resolution");
        ArgumentAcceptingOptionSpec format = parser.accepts("format").withRequiredArg().ofType(String.class).defaultsTo((Object)"png", (Object[])new String[0]).describedAs("The output image format");
        ArgumentAcceptingOptionSpec removeIfEmpty = parser.accepts("remove-if-empty").withRequiredArg().ofType(String.class).describedAs("The name of an attribute to remove if its value is empty before outputting the resulting shapefile. Use multiple times to specify multiple fields to check");
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (OptionException e) {
            System.out.println(e.getMessage());
            parser.printHelpOn((OutputStream)System.out);
            throw e;
        }
        if (options.has((OptionSpec)help)) {
            parser.printHelpOn((OutputStream)System.out);
            return;
        }
        Path inputPath = ((File)input.value(options)).toPath();
        if (!Files.exists(inputPath, new LinkOption[0])) {
            throw new FileNotFoundException("Could not find input SHP file: " + inputPath.toString());
        }
        Path outputPath = ((File)output.value(options)).toPath();
        if (!Files.exists(outputPath, new LinkOption[0])) {
            throw new FileNotFoundException("Output directory does not exist: " + outputPath.toString());
        }
        ConcurrentHashMap.KeySetView filterFields = ConcurrentHashMap.newKeySet();
        if (options.has((OptionSpec)removeIfEmpty)) {
            for (String nextFilterField : removeIfEmpty.values(options)) {
                System.out.println("Will filter field if empty value found: " + nextFilterField);
                filterFields.add(nextFilterField);
            }
        }
        if (!filterFields.isEmpty()) {
            System.out.println("Full set of filter fields: " + filterFields);
        }
        String prefix = (String)outputPrefix.value(options);
        FileDataStore store = FileDataStoreFinder.getDataStore((File)inputPath.toFile());
        for (String typeName : store.getTypeNames()) {
            Throwable throwable;
            System.out.println("");
            System.out.println("Type: " + typeName);
            SimpleFeatureSource featureSource = store.getFeatureSource(typeName);
            SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
            NameImpl outputSchemaName = new NameImpl(schema.getName().getNamespaceURI(), schema.getName().getLocalPart().replace(" ", "").replace("%20", ""));
            System.out.println("Replacing name on schema: " + schema.getName() + " with " + outputSchemaName);
            SimpleFeatureTypeImpl outputSchema = SHPUtils.changeSchemaName(schema, (Name)outputSchemaName);
            ArrayList<String> attributeList = new ArrayList<String>();
            for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
                System.out.println("Attribute: " + attribute.getName().toString());
                attributeList.add(attribute.getName().toString());
            }
            CsvSchema csvSchema = CSVUtil.buildSchema(attributeList);
            SimpleFeatureCollection collection = featureSource.getFeatures();
            int featureCount = 0;
            Path nextCSVFile = outputPath.resolve(prefix + ".csv");
            Path nextSummaryCSVFile = outputPath.resolve(prefix + "-" + outputSchema.getTypeName() + "-Summary.csv");
            CopyOnWriteArrayList<SimpleFeature> outputFeatureList = new CopyOnWriteArrayList<SimpleFeature>();
            try (SimpleFeatureIterator iterator = collection.features();){
                throwable = null;
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(nextCSVFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);
                     SequenceWriter csv2 = CSVUtil.newCSVWriter((Writer)bufferedWriter, (CsvSchema)csvSchema);){
                    ArrayList<String> nextLine = new ArrayList<String>();
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        if (++featureCount <= 2) {
                            System.out.println("");
                            System.out.println(feature.getIdentifier());
                        } else if (featureCount % 100 == 0) {
                            System.out.print(".");
                        }
                        boolean filterThisFeature = false;
                        for (AttributeDescriptor attribute : schema.getAttributeDescriptors()) {
                            String featureString = feature.getAttribute(attribute.getName()).toString();
                            nextLine.add(featureString);
                            if (filterFields.contains(attribute.getName().toString()) && featureString.trim().isEmpty()) {
                                filterThisFeature = true;
                            }
                            if (featureString.length() > 100) {
                                featureString = featureString.substring(0, 100) + "...";
                            }
                            if (featureCount > 2) continue;
                            System.out.print(attribute.getName() + "=");
                            System.out.println(featureString);
                        }
                        if (!filterThisFeature) {
                            outputFeatureList.add(SHPUtils.changeSchemaName(feature, (SimpleFeatureType)outputSchema));
                            csv2.write(nextLine);
                        }
                        nextLine.clear();
                    }
                }
                catch (Throwable csv2) {
                    throwable = csv2;
                    throw csv2;
                }
            }
            var31_32 = null;
            try (BufferedReader csvReader = Files.newBufferedReader(nextCSVFile, StandardCharsets.UTF_8);){
                throwable = null;
                try (BufferedWriter summaryOutput = Files.newBufferedWriter(nextSummaryCSVFile, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
                    CSVSummariser.runSummarise((Reader)csvReader, (Writer)summaryOutput, (int)6);
                }
                catch (Throwable csv2) {
                    throwable = csv2;
                    throw csv2;
                }
            }
            catch (Throwable summaryOutput) {
                var31_32 = summaryOutput;
                throw summaryOutput;
            }
            if (featureCount > 100) {
                System.out.println("");
            }
            System.out.println("");
            System.out.println("Feature count: " + featureCount);
            ListFeatureCollection outputCollection = new ListFeatureCollection((SimpleFeatureType)outputSchema, outputFeatureList);
            Path outputShapefilePath = outputPath.resolve(prefix + "-" + outputSchema.getTypeName() + "-dump");
            if (!Files.exists(outputShapefilePath, new LinkOption[0])) {
                Files.createDirectory(outputShapefilePath, new FileAttribute[0]);
            }
            SHPUtils.writeShapefile((SimpleFeatureCollection)outputCollection, outputShapefilePath);
            throwable = null;
            try (OutputStream outputStream = Files.newOutputStream(outputPath.resolve(prefix + "." + (String)format.value(options)), StandardOpenOption.CREATE_NEW);){
                MapContent map = new MapContent();
                map.setTitle(prefix + "-" + outputSchema.getTypeName());
                Style style = SLD.createSimpleStyle((FeatureType)featureSource.getSchema());
                FeatureLayer layer = new FeatureLayer((FeatureSource)new CollectionFeatureSource((SimpleFeatureCollection)outputCollection), style);
                map.addLayer((Layer)layer);
                SHPUtils.renderImage(map, outputStream, (Integer)resolution.value(options), (String)format.value(options));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

