/*
 * Decompiled with CFR 0.152.
 */
package com.github.angads25.filepicker.utils;

import android.content.Context;
import android.os.Build;
import com.github.angads25.filepicker.model.FileListItem;
import com.github.angads25.filepicker.utils.ExtensionFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class Utility {
    public static boolean checkStorageAccessPermissions(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            String permission = "android.permission.READ_EXTERNAL_STORAGE";
            int res = context.checkCallingOrSelfPermission(permission);
            return res == 0;
        }
        return true;
    }

    public static ArrayList<FileListItem> prepareFileListEntries(ArrayList<FileListItem> internalList, File inter, ExtensionFilter filter) {
        try {
            for (File name : inter.listFiles(filter)) {
                if (!name.canRead()) continue;
                FileListItem item = new FileListItem();
                item.setFilename(name.getName());
                item.setDirectory(name.isDirectory());
                item.setLocation(name.getAbsolutePath());
                item.setTime(name.lastModified());
                internalList.add(item);
            }
            Collections.sort(internalList);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            internalList = new ArrayList();
        }
        return internalList;
    }

    private boolean hasSupportLibraryInClasspath() {
        try {
            Class.forName("com.android.support:appcompat-v7");
            return true;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

