/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.x.imageio.plugins.png;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.harmony.luni.util.NotImplementedException;
import org.apache.harmony.x.imageio.internal.OutputStreamWrapper;
import org.apache.harmony.x.imageio.internal.nls.Messages;
import org.apache.harmony.x.imageio.plugins.png.PNGImageWriterParam;

public class PNGImageWriter
extends ImageWriter {
    private static int[][] BAND_OFFSETS = new int[][]{new int[0], {0}, {0, 1}, {0, 1, 2}, {0, 1, 2, 3}};
    private static final int PNG_COLOR_TYPE_GRAY = 0;
    private static final int PNG_COLOR_TYPE_RGB = 2;
    private static final int PNG_COLOR_TYPE_PLTE = 3;
    private static final int PNG_COLOR_TYPE_GRAY_ALPHA = 4;
    private static final int PNG_COLOR_TYPE_RGBA = 6;

    public PNGImageWriter(ImageWriterSpi iwSpi) {
        super(iwSpi);
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata arg0, ImageWriteParam arg1) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata arg0, ImageTypeSpecifier arg1, ImageWriteParam arg2) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier arg0, ImageWriteParam arg1) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam arg0) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage iioimage, ImageWriteParam param) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException(Messages.getString("imageio.81"));
        }
        if (iioimage == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.82"));
        }
        if (iioimage.hasRaster() && !this.canWriteRasters()) {
            throw new UnsupportedOperationException(Messages.getString("imageio.83"));
        }
        RenderedImage image = iioimage.getRenderedImage();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Imaging.writeImage((BufferedImage)image, this.wrapOutput(this.getOutput()), (ImageFormat)ImageFormats.PNG, params);
        }
        catch (ImageWriteException e) {
            e.printStackTrace();
        }
    }

    private OutputStream wrapOutput(Object output) {
        if (output instanceof OutputStream) {
            return (OutputStream)output;
        }
        if (output instanceof ImageOutputStream) {
            return new OutputStreamWrapper((ImageOutputStream)output);
        }
        throw new UnsupportedOperationException(output.getClass().getName());
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new PNGImageWriterParam();
    }
}

